/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftConfigTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiftExcludeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GivePriceTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.constant.GiveTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.BalanceQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.request.balance.ItemSkuListQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.BalanceDetailRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.GiftConfigBaseRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.dto.response.balance.ItemSkuListRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.gift.query.IGiftConfigQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.GiftRebateRespDto;
import com.dtyunxi.yundt.module.trade.biz.IGiftBalanceService;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GiftBalanceServiceImpl
implements IGiftBalanceService {
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private IContext context;
    @Autowired
    private IGiftBalanceQueryApi giftBalanceQueryApi;
    @Autowired
    private IGiftConfigQueryApi giftConfigQueryApi;

    @Override
    public RestResponse<GiftRebateRespDto> queryGiftQuota(List<OrderItemInfoDto> itemList, List<OrderItemInfoDto> giftItems) {
        if (CollectionUtils.isEmpty(itemList) && CollectionUtils.isEmpty(giftItems)) {
            return new RestResponse();
        }
        List customerIds = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerIdsByUserId(this.context.userId()));
        if (CollectionUtils.isEmpty((Collection)customerIds)) {
            return new RestResponse();
        }
        BalanceQueryReqDto balanceQueryReqDto = new BalanceQueryReqDto();
        balanceQueryReqDto.setCustomerId((Long)customerIds.get(0));
        BalanceDetailRespDto balanceDetailRespDto = (BalanceDetailRespDto)RestResponseHelper.extractData((RestResponse)this.giftBalanceQueryApi.queryByCustomerId(balanceQueryReqDto));
        BigDecimal totalGiveQuota = BigDecimal.ZERO;
        if (Objects.equals("01", balanceDetailRespDto.getGiveFlag())) {
            totalGiveQuota = this.calculateTotalGiveQuota(itemList, balanceDetailRespDto);
        }
        GiftRebateRespDto giftRebateRespDto = new GiftRebateRespDto();
        BigDecimal totalUsableBalance = balanceDetailRespDto.getUsableBalance().add(totalGiveQuota);
        this.calculateDeductAmount(giftItems, totalUsableBalance, giftRebateRespDto);
        giftRebateRespDto.setTotalUsableBalance(totalUsableBalance);
        giftRebateRespDto.setUsableBalance(balanceDetailRespDto.getUsableBalance());
        giftRebateRespDto.setTotalGiveQuota(totalGiveQuota);
        giftRebateRespDto.setGiftItems(giftItems);
        return new RestResponse((Object)giftRebateRespDto);
    }

    private BigDecimal calculateTotalGiveQuota(List<OrderItemInfoDto> itemList, BalanceDetailRespDto balanceDetailRespDto) {
        BigDecimal totalGiveQuota = BigDecimal.ZERO;
        Map<Long, OrderItemInfoDto> giftItemGroup = itemList.stream().collect(Collectors.toMap(OrderItemInfoDto::getSkuId, e -> e, (e1, e2) -> e1));
        ItemSkuListQueryReqDto itemSkuListQueryReqDto = new ItemSkuListQueryReqDto();
        itemSkuListQueryReqDto.setShopId(itemList.get(0).getShopId());
        itemSkuListQueryReqDto.setOutSkuIds(new ArrayList<Long>(giftItemGroup.keySet()));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.giftConfigQueryApi.getSkuList(itemSkuListQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemList.size())));
        for (ItemSkuListRespDto itemSkuListRespDto : pageInfo.getList()) {
            if (GiftExcludeEnum.EXCLUDE.getCode().equals(itemSkuListRespDto.getGiftExclude())) continue;
            totalGiveQuota = totalGiveQuota.add(this.calculateGiveQuota(giftItemGroup.get(itemSkuListRespDto.getSkuId()), balanceDetailRespDto));
        }
        return totalGiveQuota;
    }

    private BigDecimal calculateGiveQuota(OrderItemInfoDto orderItemInfoDto, BalanceDetailRespDto balanceDetailRespDto) {
        BigDecimal giveQuota = BigDecimal.ZERO;
        if (orderItemInfoDto == null) {
            return giveQuota;
        }
        BigDecimal giveProportion = balanceDetailRespDto.getGiveProportion().divide(BigDecimal.valueOf(100L), 2, 4);
        if (GiveTypeEnum.AMOUNT_OF_MONEY.getCode().equals(balanceDetailRespDto.getGiveType())) {
            giveQuota = GivePriceTypeEnum.ORIGINAL_PRICE.getCode().equals(balanceDetailRespDto.getGivePriceType()) ? orderItemInfoDto.getSellPrice().multiply(giveProportion).multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue())) : orderItemInfoDto.getSellPrice().subtract(orderItemInfoDto.getDiscountAmount()).multiply(giveProportion).multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()));
        } else {
            BigDecimal scale = balanceDetailRespDto.getQuantityScaleAmount().divide(balanceDetailRespDto.getQuantityScaleSum(), 2, RoundingMode.HALF_UP);
            giveQuota = BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()).multiply(giveProportion).multiply(scale);
        }
        return giveQuota;
    }

    /*
     * WARNING - void declaration
     */
    private void calculateDeductAmount(List<OrderItemInfoDto> giftItems, BigDecimal totalUsableBalance, GiftRebateRespDto giftRebateRespDto) {
        void var6_14;
        BigDecimal totalGiftAmount = BigDecimal.ZERO;
        for (OrderItemInfoDto orderItemInfoDto : giftItems) {
            totalGiftAmount = totalGiftAmount.add(orderItemInfoDto.getSellPrice().multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue())));
        }
        BigDecimal totalDeductAmount = BigDecimal.ZERO;
        Integer n = 0;
        GiftConfigBaseRespDto giftConfigBaseRespDto = (GiftConfigBaseRespDto)RestResponseHelper.extractData((RestResponse)this.giftConfigQueryApi.queryBase());
        giftItems = giftItems.stream().sorted(Comparator.comparing(OrderItemInfoDto::getSellPrice).reversed()).collect(Collectors.toList());
        if (GiftConfigTypeEnum.ALL_DEDUCT.equals((Object)giftConfigBaseRespDto.getGiftConfigTypeEnum())) {
            for (OrderItemInfoDto orderItemInfoDto : giftItems) {
                void var6_8;
                BigDecimal sellPrice = orderItemInfoDto.getSellPrice();
                BigDecimal num = totalUsableBalance.divide(sellPrice, 0, RoundingMode.DOWN);
                BigDecimal singleDeductAmount = BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(num) > 0) continue;
                if (orderItemInfoDto.getItemNum() - num.intValue() > 0) {
                    Integer n2 = var6_8.intValue() + num.intValue();
                    singleDeductAmount = sellPrice.multiply(num);
                } else {
                    Integer n3 = var6_8.intValue() + orderItemInfoDto.getItemNum();
                    singleDeductAmount = sellPrice.multiply(BigDecimal.valueOf(orderItemInfoDto.getItemNum().intValue()));
                }
                orderItemInfoDto.setDeductAmount(singleDeductAmount);
                totalUsableBalance = totalUsableBalance.subtract(singleDeductAmount);
                totalDeductAmount = totalDeductAmount.add(singleDeductAmount);
            }
        } else if (GiftConfigTypeEnum.PART_DEDUCT.equals((Object)giftConfigBaseRespDto.getGiftConfigTypeEnum())) {
            void var9_20;
            totalDeductAmount = totalUsableBalance.compareTo(totalGiftAmount) >= 0 ? totalGiftAmount : totalUsableBalance;
            BigDecimal usabledDeductAmount = BigDecimal.ZERO;
            boolean bl = false;
            while (var9_20 < giftItems.size()) {
                void var6_12;
                OrderItemInfoDto giftItem = (OrderItemInfoDto)giftItems.get((int)var9_20);
                Integer n4 = var6_12.intValue() + giftItem.getItemNum();
                if (var9_20 == giftItems.size() - 1) {
                    giftItem.setDeductAmount(totalDeductAmount.subtract(usabledDeductAmount));
                } else {
                    BigDecimal totalSellPrice = giftItem.getSellPrice().multiply(BigDecimal.valueOf(giftItem.getItemNum().longValue()));
                    BigDecimal singleDeductAmount = totalDeductAmount.multiply(totalSellPrice.divide(totalGiftAmount, 2, RoundingMode.HALF_UP));
                    giftItem.setDeductAmount(singleDeductAmount);
                    usabledDeductAmount = usabledDeductAmount.add(singleDeductAmount);
                }
                ++var9_20;
            }
        }
        giftRebateRespDto.setTotalDeductItemNum((Integer)var6_14);
        giftRebateRespDto.setTotalDeductAmount(totalDeductAmount);
        giftRebateRespDto.setTotalGiftAmount(totalGiftAmount);
    }

    public static void main(String[] args) {
    }
}

