/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.module.bo.ConfigItem;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.control.api.IControlItemAreaApi;
import com.dtyunxi.tcbj.center.control.api.IControlItemCustomerApi;
import com.dtyunxi.tcbj.center.control.api.dto.constant.ControlTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.OrderAmountCalculateTypeEnum;
import com.dtyunxi.tcbj.center.control.api.dto.constant.SharePurchaseRestrictionEnum;
import com.dtyunxi.tcbj.center.control.api.dto.request.ControlItemCustomerReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlBaseReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.request.CustomerControlInventoryReqDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlInventoryItemRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemAreaRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlItemCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlOrderRespDto;
import com.dtyunxi.tcbj.center.control.api.dto.response.ControlToCustomerRespDto;
import com.dtyunxi.tcbj.center.control.api.query.IControlInventoryQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlItemAreaQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlItemCustomerQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlItemQueryApi;
import com.dtyunxi.tcbj.center.control.api.query.IControlOrderQueryApi;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ParentAreCodeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerExtDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ITcbjInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjAvilableReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjAvilableRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BranchQueryItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemDetailReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BranchItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SimpleSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderRebateAmountQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.OrderRebateAmountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.query.IBalanceQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ActivityConstant;
import com.dtyunxi.yundt.cube.center.trade.api.constants.ExchangeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoJoinReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.order.activity.OrderActivityInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.IItemActivityStockApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityPriceBranchQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.SimpleCouponRespDto;
import com.dtyunxi.yundt.module.bitem.api.dto.request.ItemActivityPriceReqDto;
import com.dtyunxi.yundt.module.bitem.api.dto.response.ItemActivityPriceRespDto;
import com.dtyunxi.yundt.module.bitem.biz.price.ItemPriceHelper;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.constant.TradeConstant;
import com.dtyunxi.yundt.module.trade.api.dto.ControlItemMsgRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderExchangeDealDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemExtDto;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemInfoDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.OrderCommonItemDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.PlaceOrderItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.PlaceOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderItemBaseReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.SubmitOrderReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.activity.OrderActivityBizReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.BizItemDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.ControlRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ActivityTypeTobEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.ILocalCacheService;
import com.dtyunxi.yundt.module.trade.biz.IPriceService;
import com.dtyunxi.yundt.module.trade.biz.util.PageInfoUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CommonServiceImpl
implements ICommonService {
    private static final Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IContext context;
    @Resource(name="yundt.module.trade")
    private IConfig config;
    @Resource
    private IPriceService priceService;
    @Resource
    private ItemPriceHelper itemPriceHelper;
    @Resource
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private IBalanceQueryApi balanceQueryApi;
    @Value(value="${com.dtyunxi.yundt.module.trade.order.effectiveTime:1140}")
    private Integer effectiveTime;
    @Resource
    private IControlItemCustomerApi controlItemCustomerApi;
    @Resource
    private IControlItemAreaApi controlItemAreaApi;
    @Resource
    private IControlItemAreaQueryApi controlItemAreaQueryApi;
    @Resource
    private IControlItemCustomerQueryApi controlItemCustomerQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IControlItemQueryApi controlItemQueryApi;
    @Resource
    private IControlOrderQueryApi controlOrderQueryApi;
    @Resource
    private IControlInventoryQueryApi controlInventoryQueryApi;
    @Resource
    private ITcbjInventoryApi inventoryApi;
    @Resource
    private IOrderQueryApi orderQueryApi;
    @Resource
    private IItemActivityStockApi itemActivityStockApi;
    @Resource
    protected ICacheService cacheService;
    @Resource
    private ILocalCacheService localCacheService;
    static String customerFirstPlaceTime = "customerFirstPlaceTime";
    static String commonGroup = "commonGroup:";

    private Date queryFirstPlaceOrderByCustomerIdCache(Long customerId) {
        Date firstPlaceTime = (Date)this.cacheService.getCache(commonGroup, customerFirstPlaceTime, Date.class);
        if (Objects.isNull(firstPlaceTime) && Objects.nonNull(firstPlaceTime = (Date)RestResponseHelper.extractData((RestResponse)this.orderQueryApi.getFirstPlaceOrderByCustomerId(customerId)))) {
            this.cacheService.setCache(commonGroup, customerFirstPlaceTime, (Object)firstPlaceTime);
        }
        return firstPlaceTime;
    }

    @Override
    public String getShippingType(OrderReqDto orderReqDto) {
        String shopId = null;
        if (!CollectionUtils.isNotEmpty((Collection)orderReqDto.getOrderItems())) {
            return "express";
        }
        shopId = ((TradeItemReqDto)orderReqDto.getOrderItems().get(0)).getShopId();
        RestResponse shopDtoRestResponse = this.shopQueryApi.queryById(Long.parseLong(shopId), new String[]{"{}"});
        RestResponseHelper.checkOrThrow((RestResponse)shopDtoRestResponse);
        ShopDto shopDto = (ShopDto)shopDtoRestResponse.getData();
        if (shopDto != null && shopDto.getType().equals(2L)) {
            return "intra-city";
        }
        return "express";
    }

    @Override
    public Map<Long, ItemDetailRespDto> queryItemDetails(List<Long> itemIdList, Long shopId) {
        HashMap itemDetailMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(itemIdList)) {
            return itemDetailMap;
        }
        ItemDetailReqDto itemDetailReqDto = new ItemDetailReqDto();
        itemDetailReqDto.setItemIds(itemIdList);
        itemDetailReqDto.setFields(Arrays.asList("attributes", "sku", "medias"));
        itemDetailReqDto.setShopId(shopId);
        List itemDetailRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.listItemDetail(itemDetailReqDto));
        for (ItemDetailRespDto itemDetailRespDto : itemDetailRespDtos) {
            itemDetailMap.put(itemDetailRespDto.getItem().getId(), itemDetailRespDto);
        }
        return itemDetailMap;
    }

    @Override
    public ItemShelfRespDto getOnSelfInfo(Long skuId, Long shopId, Integer busType) {
        ShelfReqDto shelfReqDto = new ShelfReqDto();
        shelfReqDto.setShopId(shopId);
        shelfReqDto.setSkuId(skuId);
        shelfReqDto.setStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        shelfReqDto.setBusType(busType);
        PageInfo pageInfo = (PageInfo)this.itemQueryApi.queryItemShelf(JSON.toJSONString((Object)shelfReqDto), Integer.valueOf(1), Integer.valueOf(1)).getData();
        if (PageInfoUtil.isNotEmpty(pageInfo).booleanValue()) {
            logger.info("\u5546\u54c1\u4e0a\u67b6\u4fe1\u606f: shopId={}, skuId={}, shelfInfo={}", new Object[]{shopId, skuId, JSON.toJSONString(pageInfo.getList().get(0))});
            return (ItemShelfRespDto)pageInfo.getList().get(0);
        }
        logger.info("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u4e0a\u67b6\u4fe1\u606fshelfReqDto={}", (Object)shelfReqDto);
        throw new BizException("\u5546\u54c1\u5df2\u4e0b\u67b6");
    }

    @Override
    public ItemSkuRespDto getItemSkuRespDto(Long skuId, ItemDetailRespDto itemDetailRespDto) {
        ItemSkuRespDto sku = itemDetailRespDto.getItemSkuList().stream().filter(itemSku -> skuId.equals(itemSku.getId())).findAny().orElseThrow(() -> new BizException("\u5546\u54c1\u89c4\u683c\u4fe1\u606f\u4e0d\u5b58\u5728"));
        return sku;
    }

    @Override
    public void covertPrice(TradeItemReqDto tradeItem, SubmitOrderReqDto orderInfoDto, OrderItemInfoDto item, Map<String, List<Long>> activityIdsMap, ItemPolicyPriceRespDto itemPolicyPriceRespDto) {
        if ("SKILL_ORDER".equals(orderInfoDto.getFlowType())) {
            tradeItem.setItemPrice(item.getActivityPrice().getActivityPrice());
            tradeItem.setItemOrigPrice(item.getActivityPrice().getActivityPrice());
            tradeItem.setItemMarketPrice(item.getSellPrice());
        } else {
            item.setShelfType(Integer.valueOf(1));
            if (item.getGift() == 0) {
                SimpleSkuPriceQueryReqDto reqDto = new SimpleSkuPriceQueryReqDto();
                reqDto.customerId(orderInfoDto.getCustomerId()).shopId(item.getShopId()).skuId(item.getSkuId()).itemId(item.getItemId()).buyNum(item.getItemNum()).policyDate(orderInfoDto.getSubmitDate());
                itemPolicyPriceRespDto = this.priceService.getItemDistributePolicy(reqDto);
                BigDecimal itemPrice = this.itemPriceHelper.getActualPolicyPrice(itemPolicyPriceRespDto, reqDto.getBuyNum());
                if (itemPrice != null) {
                    tradeItem.setItemPrice(itemPrice);
                    tradeItem.setItemOrigPrice(itemPrice);
                } else {
                    String errMsg = String.format(TradeModuleExcpCode.ITEM_SKU_PRICE_INVALID.getMsg(), item.getItemName());
                    logger.error(errMsg);
                }
            } else {
                tradeItem.setItemPrice(BigDecimal.ZERO);
                tradeItem.setItemOrigPrice(BigDecimal.ZERO);
                tradeItem.setPayTotalAmount(BigDecimal.ZERO);
                tradeItem.setItemMarketPrice(BigDecimal.ZERO);
            }
        }
        if (item.getItemNum() == null) {
            throw new BizException(TradeModuleExcpCode.ORDER_ITEM_NOT_VALID.getCode(), "\u8bf7\u8f93\u5165\u8ba2\u8d2d\u6570\u91cf");
        }
        BigDecimal skuTotalAmount = BigDecimal.ZERO;
        if (tradeItem.getItemPrice() != null) {
            skuTotalAmount = tradeItem.getItemPrice().multiply(new BigDecimal(item.getItemNum()));
        }
        tradeItem.setPayTotalAmount(skuTotalAmount);
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606fsku\u603b\u4ef7 PayTotalAmount num={},skuTotalAmount={}, integral={}", new Object[]{item.getItemNum(), skuTotalAmount, tradeItem.getIntegral()});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("remark", item.getRemark());
        map.put("itemOrigAmount", item.getSubTotal());
        map.put("unit", item.getUnit());
        if (itemPolicyPriceRespDto != null) {
            map.put("policyCode", itemPolicyPriceRespDto.getPricePolicyCode());
            map.put("limitPolicyCode", itemPolicyPriceRespDto.getPriceLimitPolicyCode());
            map.put("adjustApplyCode", itemPolicyPriceRespDto.getAdjustApplyCode());
            map.put("skuOutOfLimitRange", itemPolicyPriceRespDto.getSkuOutOfLimitRange() ? "true" : "" + itemPolicyPriceRespDto.getSkuOutOfLimitRange());
            map.put("skuLimitControlType", itemPolicyPriceRespDto.getSkuLimitControlType());
        }
        if (TradeConstant.NO.equals(item.getGift())) {
            if (StringUtils.isNotEmpty((String)item.getActivityIds())) {
                map.put("activityIds", item.getActivityIds());
            } else {
                List<Long> activityIds = activityIdsMap.get(item.getShopId() + "_" + item.getSkuId());
                map.put("activityIds", activityIds);
            }
        }
        tradeItem.setExtFields(map);
    }

    @Override
    public TradeItemReqDto covertToTradeItem(OrderItemInfoDto item, ItemDetailRespDto itemDetail, Map<Long, ShopDto> shopMap) {
        Map skuAttr;
        TradeItemReqDto tradeItem = new TradeItemReqDto();
        tradeItem.setItemSerial(item.getItemId().toString());
        tradeItem.setSkuSerial(item.getSkuId().toString());
        tradeItem.setSellerId(String.valueOf(itemDetail.getItem().getSellerId()));
        tradeItem.setItemCode(itemDetail.getItem().getCode());
        tradeItem.setCargoSerial(item.getCargoCode());
        tradeItem.setSubType(itemDetail.getItem().getSubType());
        ItemSkuRespDto sku = this.getItemSkuRespDto(item.getSkuId(), itemDetail);
        tradeItem.setSkuCode(sku.getCode());
        tradeItem.setSkuName(sku.getName());
        tradeItem.setItemName(item.getItemName());
        tradeItem.setItemNum(item.getItemNum());
        tradeItem.setItemSrc("icommerceb");
        tradeItem.setBrandSerial(String.valueOf(itemDetail.getItem().getBrandId()));
        tradeItem.setCatalogSerial(String.valueOf(itemDetail.getItem().getDirId()));
        tradeItem.setDiscounted(Integer.valueOf(0));
        tradeItem.setIsNotCondition(Integer.valueOf(0));
        tradeItem.setItemDetail(ObjectHelper.bean2Json((Object)itemDetail));
        tradeItem.setItemType(itemDetail.getItem().getType());
        tradeItem.setBusType(item.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : item.getBusType());
        tradeItem.setItemVer(String.valueOf(itemDetail.getItem().getVersion()));
        tradeItem.setPriceType(Integer.valueOf(0));
        if (itemDetail.getItem().getSupplierId() != null) {
            tradeItem.setSupplierSerial(itemDetail.getItem().getSupplierId().toString());
        }
        if (null != (skuAttr = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class))) {
            String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
            tradeItem.setSkuDesc(skuDesc);
        }
        tradeItem.setCargoSrc("icommerceb");
        tradeItem.setCargoSerial(sku.getCargoCode());
        tradeItem.setThirdSkuSerial(null);
        tradeItem.setShopId(item.getShopId().toString());
        if (shopMap != null && CollectionUtils.isNotEmpty(shopMap.values())) {
            tradeItem.setShopType(String.valueOf(shopMap.get(item.getShopId()).getType()));
        }
        tradeItem.setInstanceId(itemDetail.getItem().getInstanceId());
        tradeItem.setTenantId(itemDetail.getItem().getTenantId());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(this.getItemImgPath(itemDetail));
        orderItemExtDto.setShopName(item.getShopName());
        orderItemExtDto.setShelfType(item.getShelfType());
        tradeItem.setExtension(ObjectHelper.bean2Json((Object)orderItemExtDto));
        tradeItem.setGift(item.getGift());
        tradeItem.setRemark(item.getRemark());
        tradeItem.setTradeItemNo(item.getTradeItemNo());
        tradeItem.setIfExchange(item.getIfExchange());
        tradeItem.setExchangeActivityId(item.getExchangeActivityId());
        tradeItem.setRebateAmount(item.getRebateAmount());
        tradeItem.setDiscountTotalAmount(item.getDiscountTotalAmount());
        if (item.getIsCombinedPackage() == 1) {
            tradeItem.setIsCombinedPackage(item.getIsCombinedPackage());
            tradeItem.setCombinedPackageActivityId(item.getActivityId());
        }
        return tradeItem;
    }

    @Override
    public TradeItemReqDto covertToTradeItemForView(OrderItemInfoDto item, OrderExchangeDealDto orderExchangeDto, PlaceOrderReqDto placeOrderReqDto) {
        Map skuAttr;
        Long customerId = placeOrderReqDto.getCustomerId();
        ItemDetailRespDto itemDetail = orderExchangeDto.getByItemId(item.getItemId());
        TradeItemReqDto tradeItem = new TradeItemReqDto();
        tradeItem.setItemSerial(item.getItemId().toString());
        tradeItem.setSkuSerial(item.getSkuId().toString());
        tradeItem.setSellerId(String.valueOf(itemDetail.getItem().getSellerId()));
        tradeItem.setItemCode(itemDetail.getItem().getCode());
        tradeItem.setSubType(itemDetail.getItem().getSubType());
        ItemSkuRespDto sku = this.getItemSkuRespDto(item.getSkuId(), itemDetail);
        ItemShelfRespDto onSelfInfo = orderExchangeDto.getOnSelfInfo(item.getSkuId(), item.getShopId());
        item.setShelfType(onSelfInfo.getType());
        tradeItem.setShelfId(onSelfInfo.getId().toString());
        BigDecimal onShelfPrice = onSelfInfo.getPrice();
        if (item.getSellPrice() != null) {
            onShelfPrice = item.getSellPrice();
        } else {
            String errMsg = String.format(TradeModuleExcpCode.ITEM_SKU_PRICE_INVALID.getMsg(), item.getItemName());
            logger.error(errMsg);
        }
        tradeItem.setItemPrice(item.getGift() == 1 ? BigDecimal.ZERO : onShelfPrice);
        if (tradeItem.getItemPrice().compareTo(BigDecimal.ZERO) < 0) {
            tradeItem.setItemPrice(BigDecimal.ZERO);
        }
        ShelfIntegralRespDto shelfIntegralRespDto = onSelfInfo.getShelfIntegral();
        if (ItemBusTypeEnum.INTEGRAL.getType().intValue() == item.getBusType().intValue() && shelfIntegralRespDto != null) {
            tradeItem.setIntegral(Integer.valueOf(shelfIntegralRespDto.getCashIntegral().intValue() * item.getItemNum()));
            tradeItem.setItemPrice(shelfIntegralRespDto.getCashAmount());
            tradeItem.setCashLimit(shelfIntegralRespDto.getCashLimit());
            tradeItem.setCashAmount(shelfIntegralRespDto.getCashAmount());
            tradeItem.setCashIntegral(shelfIntegralRespDto.getCashIntegral());
            tradeItem.setCashType(shelfIntegralRespDto.getCashType());
            tradeItem.setRuleRemark(shelfIntegralRespDto.getRuleRemark());
        }
        tradeItem.setItemOrigPrice(onShelfPrice);
        tradeItem.setSkuCode(sku.getCode());
        tradeItem.setSkuName(sku.getName());
        tradeItem.setWeight(sku.getGrossWeight());
        tradeItem.setWeightUnit(sku.getGrossWeightUnit());
        tradeItem.setVolume(sku.getVolume());
        tradeItem.setVolumeUnit(sku.getVolumeUnit());
        tradeItem.setFreightTemplateId(onSelfInfo.getFreightTemplateId());
        BigDecimal skuTotalAmount = BigDecimal.ZERO;
        if (tradeItem.getItemPrice() != null) {
            skuTotalAmount = tradeItem.getItemPrice().multiply(new BigDecimal(item.getItemNum()));
        }
        tradeItem.setPayTotalAmount(skuTotalAmount);
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606fsku\u603b\u4ef7 PayTotalAmount sku={},num={},skuTotalAmount={}, integral={}", new Object[]{JSON.toJSON((Object)sku), item.getItemNum(), skuTotalAmount, tradeItem.getIntegral()});
        tradeItem.setItemName(item.getItemName());
        tradeItem.setItemNum(item.getItemNum());
        tradeItem.setItemSrc("icommerceb");
        tradeItem.setBrandSerial(String.valueOf(itemDetail.getItem().getBrandId()));
        tradeItem.setCatalogSerial(String.valueOf(itemDetail.getItem().getDirId()));
        tradeItem.setDiscounted(Integer.valueOf(0));
        tradeItem.setIsNotCondition(Integer.valueOf(0));
        BizItemDetailRespDto bizItemDetailRespDto = new BizItemDetailRespDto();
        BeanUtils.copyProperties((Object)itemDetail, (Object)bizItemDetailRespDto, (String[])new String[]{"dirsItemsList"});
        bizItemDetailRespDto.setSkuBundleItems(orderExchangeDto.getSkuBundleItems(item.getSkuId()));
        tradeItem.setItemDetail(ObjectHelper.bean2Json((Object)bizItemDetailRespDto));
        tradeItem.setItemType(itemDetail.getItem().getType());
        tradeItem.setBusType(item.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : item.getBusType());
        tradeItem.setItemVer(String.valueOf(itemDetail.getItem().getVersion()));
        tradeItem.setPriceType(Integer.valueOf(0));
        if (itemDetail.getItem().getSupplierId() != null) {
            tradeItem.setSupplierSerial(itemDetail.getItem().getSupplierId().toString());
        }
        if (null != (skuAttr = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class))) {
            String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
            tradeItem.setSkuDesc(skuDesc);
        }
        tradeItem.setCargoSrc("icommerceb");
        tradeItem.setCargoSerial(null);
        tradeItem.setThirdSkuSerial(null);
        tradeItem.setShopId(item.getShopId().toString());
        ShopDto shopDto = orderExchangeDto.getByShopId(item.getShopId());
        if (shopDto != null) {
            tradeItem.setShopType(String.valueOf(shopDto.getType()));
        }
        tradeItem.setInstanceId(itemDetail.getItem().getInstanceId());
        tradeItem.setTenantId(itemDetail.getItem().getTenantId());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(this.getItemImgPath(itemDetail));
        orderItemExtDto.setShopName(item.getShopName());
        orderItemExtDto.setShelfType(item.getShelfType());
        orderItemExtDto.setShelfIntegral(shelfIntegralRespDto);
        tradeItem.setExtension(ObjectHelper.bean2Json((Object)orderItemExtDto));
        tradeItem.setImgPath(this.getItemImgPath(itemDetail));
        tradeItem.setGift(item.getGift());
        tradeItem.setRebateAmount(item.getRebateAmount());
        tradeItem.setIfExchange(item.getIfExchange());
        tradeItem.setExchangeActivityId(item.getExchangeActivityId());
        if (item.getIsCombinedPackage() == 1) {
            tradeItem.setIsCombinedPackage(item.getIsCombinedPackage());
            tradeItem.setCombinedPackageActivityId(item.getActivityId());
        }
        return tradeItem;
    }

    private TradeItemReqDto covertToTradeItemForViewSeckill(PlaceOrderItemReqDto item, OrderExchangeDealDto orderExchangeDto, Long customerId) {
        ItemDetailRespDto itemDetail = orderExchangeDto.getByItemId(item.getItemId());
        TradeItemReqDto tradeItem = new TradeItemReqDto();
        tradeItem.setItemSerial(item.getItemId().toString());
        tradeItem.setSkuSerial(item.getSkuId().toString());
        tradeItem.setSellerId(String.valueOf(itemDetail.getItem().getSellerId()));
        tradeItem.setItemCode(itemDetail.getItem().getCode());
        tradeItem.setSubType(itemDetail.getItem().getSubType());
        tradeItem.setItemPrice(item.getActivityPrice().getActivityPrice());
        tradeItem.setItemOrigPrice(item.getActivityPrice().getActivityPrice());
        tradeItem.setItemMarketPrice(item.getSellPrice());
        ItemSkuRespDto sku = this.getItemSkuRespDto(item.getSkuId(), itemDetail);
        tradeItem.setSkuCode(sku.getCode());
        tradeItem.setSkuName(sku.getName());
        BigDecimal skuTotalAmount = BigDecimal.ZERO;
        if (tradeItem.getItemPrice() != null) {
            skuTotalAmount = tradeItem.getItemPrice().multiply(new BigDecimal(item.getItemNum()));
        }
        tradeItem.setPayTotalAmount(skuTotalAmount);
        logger.info("\u63d0\u4ea4\u8ba2\u5355\u4fe1\u606fsku\u603b\u4ef7 PayTotalAmount sku={},num={},skuTotalAmount={}, integral={}", new Object[]{JSON.toJSON((Object)sku), item.getItemNum(), skuTotalAmount, tradeItem.getIntegral()});
        tradeItem.setItemName(item.getItemName());
        tradeItem.setItemNum(item.getItemNum());
        tradeItem.setItemSrc("icommerceb");
        tradeItem.setBrandSerial(String.valueOf(itemDetail.getItem().getBrandId()));
        tradeItem.setCatalogSerial(String.valueOf(itemDetail.getItem().getDirId()));
        tradeItem.setDiscounted(Integer.valueOf(0));
        tradeItem.setIsNotCondition(Integer.valueOf(0));
        tradeItem.setItemType(itemDetail.getItem().getType());
        tradeItem.setBusType(item.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : item.getBusType());
        tradeItem.setItemVer(String.valueOf(itemDetail.getItem().getVersion()));
        tradeItem.setPriceType(Integer.valueOf(0));
        Map skuAttr = (Map)ObjectHelper.Json2Bean((String)sku.getAttr(), Map.class);
        if (null != skuAttr) {
            String skuDesc = StringUtils.join(skuAttr.values(), (String)" ");
            tradeItem.setSkuDesc(skuDesc);
        }
        tradeItem.setCargoSrc("icommerceb");
        tradeItem.setCargoSerial(null);
        tradeItem.setThirdSkuSerial(null);
        tradeItem.setShopId(item.getShopId().toString());
        ShopDto shopDto = orderExchangeDto.getByShopId(item.getShopId());
        if (shopDto != null) {
            tradeItem.setShopType(String.valueOf(shopDto.getType()));
        }
        tradeItem.setInstanceId(itemDetail.getItem().getInstanceId());
        tradeItem.setTenantId(itemDetail.getItem().getTenantId());
        tradeItem.setGift(item.getGift());
        tradeItem.setRebateAmount(item.getRebateAmount());
        return tradeItem;
    }

    @Override
    public String getItemImgPath(ItemDetailRespDto itemDetailRespDto) {
        if (CollectionUtils.isEmpty((Collection)itemDetailRespDto.getItemMediasList())) {
            return null;
        }
        return ((ItemMediasRespDto)itemDetailRespDto.getItemMediasList().get(0)).getPath1();
    }

    @Override
    public void operateVirSotrage(Long shopId, Long skuId, Long quantity) {
        ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
        itemStorageReqDto.setSkuId(skuId);
        itemStorageReqDto.setShopId(shopId);
        itemStorageReqDto.setBalance(quantity);
        itemStorageReqDto.setInstanceId(this.context.instanceId());
        itemStorageReqDto.setTenantId(this.context.tenantId());
        try {
            RestResponse restResponse = this.itemStorageApi.operatingItemStorage(itemStorageReqDto);
            RestResponseHelper.extractData((RestResponse)restResponse);
            logger.info("\u3010\u5546\u54c1\u865a\u62df\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1ashopId={}, skuId={}, quantity={}\u3011", new Object[]{shopId, skuId, quantity});
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3\u629b\u9519", (Throwable)e);
            throw new BizException(TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getCode(), TradeModuleExcpCode.ITEM_STORAGAE_NOT_ENOUGH.getMsg());
        }
    }

    @Override
    public Integer getEffectiveTime() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne("trade", "com.dtyunxi.yundt.module.trade.order.effectiveTime");
            logger.info("\u3010\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u8ba2\u5355\u652f\u4ed8\u6709\u6548\u65f6\u95f4\u5f53\u524d\u914d\u7f6e\u4e3a{}\u5206\u949f\u3011", (Object)JSON.toJSONString((Object)configItem));
        }
        catch (Exception e) {
            logger.error("getEffectiveTime.error...", (Throwable)e);
        }
        if (null == configItem || null == configItem.getValue()) {
            logger.info("\u3010\u8ba2\u5355\u652f\u4ed8\u6709\u6548\u65f6\u95f4\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4{}\u5206\u949f\u3011", (Object)this.effectiveTime);
            return this.effectiveTime;
        }
        return Integer.valueOf(configItem.getValue());
    }

    @Override
    public Integer getOrderAuditconfig() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne(null, "com.dtyunxi.yundt.module.trade.order.orderAudit");
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8ba2\u5355\u5ba1\u6838\u914d\u7f6e\u5931\u8d25", (Throwable)e);
        }
        if (null == configItem || null == configItem.getValue()) {
            logger.info("\u3010\u5355\u5ba1\u6838\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba40\u4e0d\u9700\u8981\u5ba1\u6838\u3011");
            configItem = new ConfigItem();
            configItem.setValue("false");
        }
        Integer audit = Boolean.valueOf(configItem.getValue()) != false ? 1 : 0;
        return audit;
    }

    @Override
    public Integer getAfterSalePattern() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne("trade", "com.dtyunxi.yundt.module.trade.order.orderAfterSale");
        }
        catch (Exception e) {
            logger.error("getAfterSalePattern.error...", (Throwable)e);
        }
        if (null == configItem || StringUtils.isEmpty((String)configItem.getValue())) {
            logger.info("\u3010\u7ef4\u6743\u7533\u8bf7\u6a21\u5f0f\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4\u4e3a2-\u5141\u8bb8\u5355\u4e2a\u5546\u54c1\u9000\u548c\u6574\u5355\u9000");
            configItem = new ConfigItem();
            configItem.setValue("2");
        }
        return Integer.valueOf(configItem.getValue());
    }

    @Override
    public OrderPreviewReqDto getOrderViewParam(PlaceOrderReqDto placeOrderReqDto, OrderExchangeDealDto orderExchangeDealDto, Long userId) {
        BigDecimal rebateTotalAmount = this.queryAndDealRebate(placeOrderReqDto);
        List tradeItems = placeOrderReqDto.getItemList().stream().filter(orderItem -> orderItem.getGift() == 0).map(placeOrderItemReqDto -> {
            placeOrderItemReqDto.setBusType(placeOrderItemReqDto.getBusType() != null ? placeOrderItemReqDto.getBusType() : ItemBusTypeEnum.ORDINARY.getType());
            placeOrderItemReqDto.setItemType(placeOrderItemReqDto.getItemType() != null ? placeOrderItemReqDto.getItemType() : ItemTypeEnum.GENERAL.getType());
            OrderItemInfoDto item = new OrderItemInfoDto();
            BeanUtils.copyProperties((Object)placeOrderItemReqDto, (Object)item);
            return this.covertToTradeItemForView(item, orderExchangeDealDto, placeOrderReqDto);
        }).collect(Collectors.toList());
        OrderPreviewReqDto orderPreviewReqDto = new OrderPreviewReqDto();
        orderPreviewReqDto.setOrderItems(tradeItems);
        orderPreviewReqDto.setUserId(userId.toString());
        orderPreviewReqDto.setTotalRebateAmount(rebateTotalAmount);
        if (placeOrderReqDto.getOrderActivity() != null && CollectionUtils.isNotEmpty((Collection)placeOrderReqDto.getOrderActivity().getActivityList())) {
            OrderActivityInfoJoinReqDto activity = new OrderActivityInfoJoinReqDto();
            List<OrderActivityInfoReqDto> activityList = this.convertOrderActivityInfoReqDtos(placeOrderReqDto);
            activity.setActivityList(activityList);
            orderPreviewReqDto.setActivity(activity);
        }
        orderPreviewReqDto.setShippingType(this.getShippingType((OrderReqDto)orderPreviewReqDto));
        orderPreviewReqDto.setUseExchangeAccount(placeOrderReqDto.isUseExchangeAccount());
        return orderPreviewReqDto;
    }

    @Override
    public OrderPreviewReqDto getSeckillOrderViewParam(PlaceOrderReqDto placeOrderReqDto, OrderExchangeDealDto orderExchangeDealDto, Long userId) {
        BigDecimal rebateTotalAmount = this.queryAndDealRebate(placeOrderReqDto);
        ArrayList<TradeItemReqDto> tradeItems = new ArrayList<TradeItemReqDto>(1);
        Iterator iterator = placeOrderReqDto.getItemList().iterator();
        while (iterator.hasNext()) {
            PlaceOrderItemReqDto placeOrderItemReqDto;
            placeOrderItemReqDto.setBusType((placeOrderItemReqDto = (PlaceOrderItemReqDto)iterator.next()).getBusType() != null ? placeOrderItemReqDto.getBusType() : ItemBusTypeEnum.ORDINARY.getType());
            placeOrderItemReqDto.setItemType(placeOrderItemReqDto.getItemType() != null ? placeOrderItemReqDto.getItemType() : ItemTypeEnum.GENERAL.getType());
            TradeItemReqDto itemReqDto = this.covertToTradeItemForViewSeckill(placeOrderItemReqDto, orderExchangeDealDto, placeOrderReqDto.getCustomerId());
            tradeItems.add(itemReqDto);
        }
        OrderPreviewReqDto orderPreviewReqDto = new OrderPreviewReqDto();
        orderPreviewReqDto.setOrderItems(tradeItems);
        orderPreviewReqDto.setUserId(userId.toString());
        orderPreviewReqDto.setTotalRebateAmount(rebateTotalAmount);
        return orderPreviewReqDto;
    }

    private BigDecimal queryAndDealRebate(PlaceOrderReqDto placeOrderReqDto) {
        BigDecimal rebateTotalAmount = placeOrderReqDto.getRebateTotalAmount();
        if (rebateTotalAmount == null) {
            OrderRebateAmountQueryReqDto amountQueryReqDto = new OrderRebateAmountQueryReqDto();
            amountQueryReqDto.setPayAmount(BigDecimal.ZERO);
            amountQueryReqDto.setCustomerId(placeOrderReqDto.getCustomerId());
            amountQueryReqDto.setShopId(((PlaceOrderItemReqDto)placeOrderReqDto.getItemList().get(0)).getShopId());
            List itemList = placeOrderReqDto.getItemList().stream().map(e -> {
                com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto orderItemInfoDtor = new com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto();
                orderItemInfoDtor.setSellPrice(e.getSellPrice());
                orderItemInfoDtor.setItemNum(e.getItemNum());
                orderItemInfoDtor.setSkuId(e.getSkuId());
                orderItemInfoDtor.setSubType(e.getSubType());
                return orderItemInfoDtor;
            }).collect(Collectors.toList());
            amountQueryReqDto.setItemList(itemList);
            logger.info("\u9884\u89c8\u8ba2\u5355-\u67e5\u8be2\u6298\u6263\u8d26\u6237\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)amountQueryReqDto));
            OrderRebateAmountRespDto amountRespDto = (OrderRebateAmountRespDto)RestResponseHelper.extractData((RestResponse)this.balanceQueryApi.queryUsableBalance(amountQueryReqDto));
            logger.info("\u9884\u89c8\u8ba2\u5355-\u67e5\u8be2\u6298\u6263\u8d26\u6237\u4fe1\u606f\u54cd\u5e94\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)amountRespDto));
            rebateTotalAmount = amountRespDto.getUseBalance();
        }
        return rebateTotalAmount;
    }

    private List<com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto> buildNotBlackItemRebate(List<com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto> itemList, BigDecimal payAmount, BigDecimal waitGive, List<PlaceOrderItemReqDto> list) {
        if (waitGive != null && waitGive.compareTo(BigDecimal.ZERO) > 0) {
            HashMap<Long, BigDecimal> skuRebateMap = new HashMap<Long, BigDecimal>();
            List itemListNotBlack = itemList.stream().filter(data -> !data.getBlackItem()).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(itemListNotBlack)) {
                BigDecimal rebateRatio = waitGive.divide(payAmount, 4).setScale(4, 1);
                BigDecimal haveGave = BigDecimal.ZERO;
                for (int i = 0; i < itemListNotBlack.size(); ++i) {
                    boolean isLast;
                    com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto orderItemInfoDto = (com.dtyunxi.yundt.cube.center.rebate.api.dto.request.OrderItemInfoDto)itemListNotBlack.get(i);
                    boolean bl = isLast = i == itemListNotBlack.size() - 1;
                    if (!isLast) {
                        BigDecimal thisAmount = orderItemInfoDto.getSellPrice().multiply(rebateRatio).setScale(2, 1);
                        skuRebateMap.put(orderItemInfoDto.getSkuId(), thisAmount);
                        haveGave = haveGave.add(thisAmount);
                        continue;
                    }
                    skuRebateMap.put(orderItemInfoDto.getSkuId(), waitGive.subtract(haveGave));
                }
            }
            Iterator<PlaceOrderItemReqDto> iterator = list.iterator();
            while (iterator.hasNext()) {
                PlaceOrderItemReqDto orderItemInfoDto;
                BigDecimal bigDecimal = (BigDecimal)skuRebateMap.get((orderItemInfoDto = iterator.next()).getSkuId());
                orderItemInfoDto.setRebateAmount(bigDecimal == null ? BigDecimal.ZERO : bigDecimal);
            }
        }
        return itemList;
    }

    @Override
    public OrderExchangeDealDto prepareOrderExchange(List<OrderCommonItemDto> orderCommonItemDtos) {
        return this.prepareOrderExchange(orderCommonItemDtos, true);
    }

    @Override
    public OrderExchangeDealDto prepareOrderExchange(List<OrderCommonItemDto> allItemList, Boolean isContainShop) {
        List shelfReqDtos = allItemList.stream().map(orderItemInfoDto -> {
            ShelfReqDto shelfReqDto = new ShelfReqDto();
            shelfReqDto.setBusType(orderItemInfoDto.getBusType());
            shelfReqDto.setItemType(orderItemInfoDto.getItemType());
            shelfReqDto.setItemId(orderItemInfoDto.getItemId());
            shelfReqDto.setShopId(orderItemInfoDto.getShopId());
            shelfReqDto.setSkuId(orderItemInfoDto.getSkuId());
            return shelfReqDto;
        }).collect(Collectors.toList());
        BranchQueryItemReqDto branchQueryItemReqDto = new BranchQueryItemReqDto();
        branchQueryItemReqDto.setShelfItemList(shelfReqDtos);
        RestResponse branchItemRespDtoRestResponse = this.itemQueryApi.branchQueryItem(branchQueryItemReqDto);
        BranchItemRespDto branchItemRespDto = (BranchItemRespDto)RestResponseHelper.extractData((RestResponse)branchItemRespDtoRestResponse);
        OrderExchangeDealDto orderExchangeDealDto = new OrderExchangeDealDto();
        for (ItemDetailRespDto itemDetailRespDto : branchItemRespDto.getItemDetailList()) {
            orderExchangeDealDto.addItemDetail(itemDetailRespDto);
        }
        for (ItemShelfRespDto itemShelfRespDto : branchItemRespDto.getItemShelfList()) {
            orderExchangeDealDto.addItemShelf(itemShelfRespDto);
        }
        for (OrderCommonItemDto orderCommonItemDto2 : allItemList) {
            if (!ItemTypeEnum.BUNDLE.getType().equals(orderCommonItemDto2.getItemType())) continue;
            RestResponse listRestResponse = this.itemQueryApi.queryBundleItemDetail(orderCommonItemDto2.getShopId(), orderCommonItemDto2.getItemId(), orderCommonItemDto2.getBusType());
            List bundleItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            Map<Long, List<BundleItemRespDto>> skuItems = bundleItemRespDtos.stream().collect(Collectors.groupingBy(BundleItemRespDto::getSkuId));
            for (Long skuId : skuItems.keySet()) {
                if (!skuId.equals(orderCommonItemDto2.getSkuId())) continue;
                orderExchangeDealDto.addSkuBundleItems(skuId, skuItems.get(skuId));
            }
        }
        if (isContainShop.booleanValue()) {
            Set shopIds = allItemList.stream().map(orderCommonItemDto -> orderCommonItemDto.getShopId()).collect(Collectors.toSet());
            RestResponse listRestResponse = this.shopQueryApi.queryBaseListByIds(shopIds);
            List shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
            for (ShopBaseDto shopBaseDto : shopBaseDtos) {
                ShopDto shopDto = new ShopDto();
                BeanUtils.copyProperties((Object)shopBaseDto, (Object)shopDto);
                orderExchangeDealDto.addShop(shopDto);
            }
        }
        return orderExchangeDealDto;
    }

    @Override
    public List<OrderActivityBizReqDto> getPromotionActivityList(List<PlaceOrderItemReqDto> itemList, Long customerId) {
        OrderActivityBizReqDto activityBizReqDto;
        Long shopId;
        ArrayList itemIds = Lists.newArrayList();
        ArrayList shopIds = Lists.newArrayList();
        ArrayList dimensionList = Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ORDER.getKey(), ActivityDimensionEnum.COUPON.getKey(), ActivityDimensionEnum.ITEM.getKey()});
        for (PlaceOrderItemReqDto itemReqDto : itemList) {
            if (!ExchangeEnum.NO.getType().equals(itemReqDto.getIfExchange())) continue;
            itemIds.add(itemReqDto.getItemId());
            shopIds.add(itemReqDto.getShopId());
        }
        List shopIdsDistinct = shopIds.stream().distinct().collect(Collectors.toList());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setItemIdList((List)itemIds);
        queryReqDto.setShopIdList(shopIdsDistinct);
        queryReqDto.setDimensionList((List)dimensionList);
        queryReqDto.setCustomerId(customerId);
        RestResponse promotionCouponRestResp = this.activityQueryApi.queryActivityByItem(queryReqDto);
        PromotionCouponRespDto promotionCouponRespDto = (PromotionCouponRespDto)RestResponseHelper.extractData((RestResponse)promotionCouponRestResp);
        List promotionActivityIds = promotionCouponRespDto.getPromotionActivityIds();
        List activityRespDtos = promotionCouponRespDto.getActivityRespDtos();
        List couponList = promotionCouponRespDto.getCouponList();
        ArrayList activityBizList = Lists.newArrayList();
        Long l = shopId = !CollectionUtils.isEmpty(shopIdsDistinct) && shopIdsDistinct.size() == 1 ? (Long)shopIdsDistinct.get(0) : null;
        if (CollectionUtils.isNotEmpty((Collection)activityRespDtos)) {
            for (ActivityRespDto activityRespDto : activityRespDtos) {
                activityBizReqDto = new OrderActivityBizReqDto();
                activityBizReqDto.setActivityId(activityRespDto.getId());
                activityBizReqDto.setType(ActivityTypeEnum.PROMOTION.getCode());
                ActivityTypeTobEnum activityTypeTobEnum = ActivityTypeTobEnum.fromCode((Long)activityRespDto.getActivityTemplateId());
                activityBizReqDto.setActivityType(activityTypeTobEnum != null ? activityTypeTobEnum.getName() : null);
                activityBizReqDto.setSort(activityTypeTobEnum != null ? activityTypeTobEnum.getSort() : -1);
                activityBizReqDto.setShopId(shopId);
                activityBizList.add(activityBizReqDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)couponList)) {
            for (SimpleCouponRespDto simpleCouponRespDto : couponList) {
                activityBizReqDto = new OrderActivityBizReqDto();
                activityBizReqDto.setActivityId(simpleCouponRespDto.getActivityId());
                activityBizReqDto.setCouponIds((List)Lists.newArrayList((Object[])new String[]{simpleCouponRespDto.getCouponId().toString()}));
                activityBizReqDto.setType(ActivityTypeEnum.COUPON.getCode());
                activityBizReqDto.setSort(ActivityTypeTobEnum.COUPON_TOB_ACTIVITY.getSort().intValue());
                activityBizReqDto.setShopId(shopId);
                activityBizList.add(activityBizReqDto);
            }
        }
        return activityBizList;
    }

    @Override
    public List<OrderActivityInfoReqDto> convertOrderActivityInfoReqDtos(PlaceOrderReqDto placeOrderReqDto) {
        List activityList = placeOrderReqDto.getOrderActivity().getActivityList();
        if (CollectionUtils.isEmpty((Collection)activityList)) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Long> set = new HashSet<Long>();
        ArrayList<OrderActivityBizReqDto> newActivityList = new ArrayList<OrderActivityBizReqDto>(activityList.size());
        for (OrderActivityBizReqDto activityBizReqDto : activityList) {
            if (CollectionUtils.isNotEmpty((Collection)activityBizReqDto.getCouponIds())) {
                newActivityList.add(activityBizReqDto);
                List couponIds = placeOrderReqDto.getCouponIdsMap().computeIfAbsent(activityBizReqDto.getActivityId().toString(), k -> Lists.newArrayList());
                couponIds.add(Long.valueOf((String)activityBizReqDto.getCouponIds().get(0)));
                continue;
            }
            if (!set.add(activityBizReqDto.getActivityId())) continue;
            newActivityList.add(activityBizReqDto);
            if (activityBizReqDto.getType() != null && activityBizReqDto.getType() != 6) continue;
            placeOrderReqDto.getItemActivityIds().add(activityBizReqDto.getActivityId());
        }
        return newActivityList.stream().map(orderActivityBizReqDto -> {
            OrderActivityInfoReqDto orderActivityInfoReqDto = new OrderActivityInfoReqDto();
            orderActivityInfoReqDto.setType(orderActivityBizReqDto.getType());
            if (orderActivityBizReqDto.getActivityGroupId() != null) {
                orderActivityInfoReqDto.setType(ActivityConstant.GROUP_ACTIVITY);
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(orderActivityBizReqDto.getActivityGroupId().toString());
                orderActivityInfoReqDto.setActivityItemIds(list);
            }
            if (CollectionUtils.isNotEmpty((Collection)orderActivityBizReqDto.getCouponIds())) {
                orderActivityInfoReqDto.setType(ActivityConstant.COUPON_ACTIVITY);
                orderActivityInfoReqDto.setActivityItemIds(orderActivityBizReqDto.getCouponIds());
            }
            orderActivityInfoReqDto.setActivityId(orderActivityBizReqDto.getActivityId());
            return orderActivityInfoReqDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<Long> getCustomerIdListByUserId(Long userId, Map<String, String> nameMap) {
        ArrayList customerIds = Lists.newArrayList();
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        Long orgInfoId = this.getCurrentUserOrgIdNoException(userId);
        ArrayList<Long> orgInfoIdList = new ArrayList<Long>();
        orgInfoIdList.add(orgInfoId);
        searchReqDto.setOrgInfoIds(orgInfoIdList);
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse listRestResp = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            for (CustomerRespDto customerRespDto : customerRespDtos) {
                customerIds.add(customerRespDto.getId());
                nameMap.put(customerRespDto.getId().toString(), customerRespDto.getName());
            }
        }
        return customerIds;
    }

    @Override
    public List<CustomerRespDto> getCustomerDtoByUserId(Long userId) {
        Object customerIds = null;
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        Long orgInfoId = this.getCurrentUserOrgIdNoException(userId);
        ArrayList<Long> orgInfoIdList = new ArrayList<Long>();
        orgInfoIdList.add(orgInfoId);
        searchReqDto.setOrgInfoIds(orgInfoIdList);
        searchReqDto.setTenantId(this.context.tenantId());
        RestResponse listRestResp = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        return customerRespDtos;
    }

    @Override
    public List<SellerRespDto> getSellerDtoByUserId(Long userId) {
        List<CustomerRespDto> custList = this.getCustomerDtoByUserId(userId);
        List res = null;
        if (CollectionUtils.isNotEmpty(custList)) {
            SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
            List upOrgIds = custList.stream().map(e -> e.getMerchantId()).collect(Collectors.toList());
            sellerQueryReqDto.setOrganizationIds(upOrgIds);
            res = (List)this.sellerQueryApi.queryList(sellerQueryReqDto).getData();
            return res;
        }
        return null;
    }

    private Long getCurrentUserOrgIdNoException(Long userId) {
        return (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(userId));
    }

    @Override
    public Long getCustomerIdByUserIdAndSellerId(Long userId, Long sellerId) {
        SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(sellerId).getData();
        Long merchantId = sellerRespDto.getOrganizationId();
        Long userOrgInfoId = this.getCurrentUserOrgIdNoException(userId);
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        ArrayList<Long> orgInfoIdList = new ArrayList<Long>();
        orgInfoIdList.add(userOrgInfoId);
        searchReqDto.setOrgInfoIds(orgInfoIdList);
        searchReqDto.setTenantId(this.context.tenantId());
        searchReqDto.setMerchantId(merchantId);
        RestResponse listRestResp = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (!CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            return ((CustomerRespDto)customerRespDtos.get(0)).getId();
        }
        return null;
    }

    @Override
    public Long getCustomerIdByUserIdAndShopId(Long userId, Long shopId) {
        ShopDto shopDto = (ShopDto)this.shopQueryApi.queryById(shopId.longValue(), new String[0]).getData();
        Long sellerId = shopDto.getSellerId();
        SellerRespDto sellerRespDto = (SellerRespDto)this.sellerQueryApi.queryById(sellerId).getData();
        Long merchantId = sellerRespDto.getOrganizationId();
        Long userOrgInfoId = this.getCurrentUserOrgIdNoException(userId);
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        ArrayList<Long> orgInfoIdList = new ArrayList<Long>();
        orgInfoIdList.add(userOrgInfoId);
        searchReqDto.setOrgInfoIds(orgInfoIdList);
        searchReqDto.setTenantId(this.context.tenantId());
        searchReqDto.setMerchantId(merchantId);
        RestResponse listRestResp = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResp);
        if (!CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            return ((CustomerRespDto)customerRespDtos.get(0)).getId();
        }
        return null;
    }

    @Override
    public ControlRespDto checkControlRule(OrderBaseReqDto orderReqDto, Long orgId, boolean ignoreWarn, boolean placeOrder) {
        logger.info("\u7ba1\u63a7\u5f00\u59cb,\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderReqDto));
        ControlRespDto controlRespDto = new ControlRespDto();
        List<Long> customerIdList = Collections.singletonList(orderReqDto.getCustomerId());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u5ba2\u6237{}\u4e0d\u5b58\u5728", (Object)orderReqDto.getCustomerId());
            return null;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        logger.info("\u83b7\u53d6\u5230\u7684\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerRespDto));
        List regionCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(regionCodeList)) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(regionCodeList);
            List<String> parentAreaCodeList = (List<String>)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
            }
            this.checkOrderControl(controlRespDto, customerRespDto, orderReqDto, orgId, placeOrder, parentAreaCodeList);
            logger.info("\u8ba2\u5355\u7ba1\u63a7\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)controlRespDto));
            this.checkItemControl(controlRespDto, customerRespDto, orderReqDto, orgId, placeOrder, parentAreaCodeList);
            logger.info("\u5355\u54c1\u7ba1\u63a7\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)controlRespDto));
        }
        return controlRespDto;
    }

    private boolean checkCustomerByFirstPlaceOrder(Long customerId) {
        Date firstPlaceTime = this.queryFirstPlaceOrderByCustomerIdCache(customerId);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        if (null == firstPlaceTime || calendar.getTime().compareTo(firstPlaceTime) < 0) {
            return true;
        }
        logger.info("\u5f53\u524d\u65f6\u95f4\u8ddd\u79bb\u9996\u8d2d\u65f6\u95f4\u8d85\u8fc73\u4e2a\u6708\uff0c\u8fdb\u884c\u7ba1\u63a7\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        return false;
    }

    @Override
    public void checkOrderControl(ControlRespDto controlRespDto, CustomerRespDto customerRespDto, OrderBaseReqDto orderReqDto, Long orgId, boolean placeOrder, List<String> areaCodeList) {
        logger.info("\u8ba2\u5355\u7ba1\u63a7\u5f00\u59cb========\u300b");
        CustomerControlBaseReqDto controlBaseReqDto = new CustomerControlBaseReqDto();
        controlBaseReqDto.setCustomerId(customerRespDto.getId());
        controlBaseReqDto.setOrgId(orgId);
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            controlBaseReqDto.setCustomerAreaCodeList(areaCodeList);
        }
        logger.info("\u8ba2\u5355\u7ba1\u63a7\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)controlBaseReqDto));
        ControlOrderRespDto controlOrderRespDto = (ControlOrderRespDto)RestResponseHelper.extractData((RestResponse)this.controlOrderQueryApi.queryRuleByCustomer(controlBaseReqDto));
        logger.info("\u7ba1\u63a7\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)controlOrderRespDto));
        StringBuilder orderControlMsg = new StringBuilder(50);
        boolean allowSubmit = true;
        int orderControlFlag = 0;
        if (null != controlOrderRespDto) {
            BigDecimal minAmount = controlOrderRespDto.getMinAmount();
            if (OrderAmountCalculateTypeEnum.PAYMENT_AMOUNT.getType().equals(controlOrderRespDto.getCalculateType())) {
                orderControlMsg.append(minAmount.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u8d77\u8ba2\uff0c\u5f53\u524d\u91d1\u989d").append(orderReqDto.getPayAmount().subtract(orderReqDto.getDeductionAmount()).setScale(2, RoundingMode.HALF_UP)).append("\u5143");
                if (orderReqDto.getPayAmount().subtract(orderReqDto.getDeductionAmount()).compareTo(controlOrderRespDto.getMinAmount()) < 0) {
                    orderControlFlag = 1;
                    if (ControlTypeEnum.CONTROL.getType().equals(controlOrderRespDto.getControlType())) {
                        allowSubmit = false;
                        orderControlFlag = 2;
                    }
                    orderControlMsg.append("\uff0c\u8fd8\u5dee").append(minAmount.subtract(orderReqDto.getPayAmount().subtract(orderReqDto.getDeductionAmount())).setScale(2, RoundingMode.HALF_UP)).append("\u5143");
                }
            } else if (OrderAmountCalculateTypeEnum.SUPPLY_AMOUNT.getType().equals(controlOrderRespDto.getCalculateType())) {
                BigDecimal totalSupplyAmount = orderReqDto.getTotalAmount().add(orderReqDto.getTotalGiftOrigAmount());
                orderControlMsg.append(minAmount.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u8d77\u8ba2\uff0c\u5f53\u524d\u91d1\u989d").append(totalSupplyAmount.setScale(2, RoundingMode.HALF_UP)).append("\u5143");
                if (totalSupplyAmount.compareTo(controlOrderRespDto.getMinAmount()) < 0) {
                    orderControlFlag = 1;
                    if (ControlTypeEnum.CONTROL.getType().equals(controlOrderRespDto.getControlType())) {
                        allowSubmit = false;
                        orderControlFlag = 2;
                    }
                    orderControlMsg.append("\uff0c\u8fd8\u5dee").append(minAmount.subtract(totalSupplyAmount).setScale(2, RoundingMode.HALF_UP)).append("\u5143");
                }
            }
        }
        controlRespDto.setOrderControlFlag(orderControlFlag);
        controlRespDto.setAllowSubmit(allowSubmit);
        controlRespDto.setOrderControlMsg(orderControlMsg.toString());
        logger.info("\u8ba2\u5355\u7ba1\u63a7\u7ed3\u675f========\u300b");
    }

    @Override
    public void checkItemControl(ControlRespDto controlRespDto, CustomerRespDto customerRespDto, OrderBaseReqDto orderReqDto, Long orgId, boolean placeOrder, List<String> areaCodeList) {
        logger.info("\u5355\u54c1\u7ba1\u63a7\u5f00\u59cb========\u300b");
        List itemIdList = orderReqDto.getItemList().stream().map(OrderItemBaseReqDto::getItemId).distinct().collect(Collectors.toList());
        Map itemIdToMap = orderReqDto.getItemList().stream().collect(Collectors.toMap(OrderItemBaseReqDto::getItemId, Function.identity(), (old, now) -> {
            old.setItemNum(Integer.valueOf(old.getItemNum() + now.getItemNum()));
            return old;
        }));
        CustomerControlBaseReqDto controlBaseReqDto = new CustomerControlBaseReqDto();
        controlBaseReqDto.setCustomerId(customerRespDto.getId());
        controlBaseReqDto.setOrgId(orgId);
        controlBaseReqDto.setItemIdList(itemIdList);
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            controlBaseReqDto.setCustomerAreaCodeList(areaCodeList);
        }
        logger.info("\u5355\u54c1\u7ba1\u63a7\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)controlBaseReqDto));
        ControlToCustomerRespDto controlToCustomerRespDto = (ControlToCustomerRespDto)RestResponseHelper.extractData((RestResponse)this.controlItemQueryApi.queryRuleByCustomer(controlBaseReqDto));
        logger.info("\u9884\u89c8\u8ba2\u5355\u5355\u54c1\u7ba1\u63a7\u89c4\u5219\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)controlToCustomerRespDto));
        ArrayList itemControlFlags = Lists.newArrayList();
        ArrayList allowSubmits = Lists.newArrayList();
        ArrayList controlItemMsgRespDtos = Lists.newArrayList();
        if (null != controlToCustomerRespDto && CollectionUtils.isNotEmpty((Collection)controlToCustomerRespDto.getControlToCustomerRules())) {
            controlToCustomerRespDto.getControlToCustomerRules().forEach(controlItemRespDto -> {
                block15: {
                    block16: {
                        if (null == controlItemRespDto || !Objects.nonNull(customerRespDto.getId())) break block15;
                        if (!CollectionUtils.isNotEmpty((Collection)controlItemRespDto.getCustomerList())) break block16;
                        logger.info("\u6307\u5b9a\u5ba2\u6237\u7ba1\u63a7");
                        boolean onFirstPlaceOrderTime = this.checkCustomerByFirstPlaceOrder(orderReqDto.getCustomerId());
                        for (ControlItemCustomerRespDto controlItemCustomerRespDto : controlItemRespDto.getCustomerList()) {
                            if (Objects.equals(controlItemCustomerRespDto.getCalculateType(), 0)) {
                                logger.info("\u6307\u5b9a\u5ba2\u6237\u56fa\u5b9a\u9650\u8d2d\u91cf\u4e0d\u9700\u8981\u9650\u523690\u5929\u4e0b\u5355");
                            } else if (onFirstPlaceOrderTime) {
                                logger.info("\u7528\u6237\u9996\u8d2d\u8ddd\u79bb\u5f53\u524d\u65f6\u95f4\u672a\u8d85\u8fc790\u5929\uff0c\u4e0d\u8fdb\u884c\u7ba1\u63a7\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                                return;
                            }
                            OrderItemBaseReqDto tradeItemReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemCustomerRespDto.getItemId());
                            if (null == tradeItemReqDto || controlItemCustomerRespDto.getLimitCount() == null) {
                                logger.error("\u6307\u5b9a\u5ba2\u6237-\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\u6e05\u5355\u4e2d: {}", (Object)JSON.toJSONString((Object)controlItemCustomerRespDto));
                                continue;
                            }
                            Integer purchasedCount = controlItemCustomerRespDto.getPurchasedCount() == null ? 0 : controlItemCustomerRespDto.getPurchasedCount();
                            if (controlItemCustomerRespDto.getLimitCount().compareTo(tradeItemReqDto.getItemNum() + purchasedCount) >= 0) continue;
                            ControlItemMsgRespDto dto = new ControlItemMsgRespDto();
                            CubeBeanUtils.copyProperties((Object)dto, (Object)tradeItemReqDto, (String[])new String[0]);
                            dto.setItemId(controlItemCustomerRespDto.getItemId());
                            dto.setItemName(controlItemCustomerRespDto.getItemName());
                            dto.setExceedNum(Integer.valueOf(tradeItemReqDto.getItemNum() + purchasedCount - controlItemCustomerRespDto.getLimitCount()));
                            dto.setLimitCount(controlItemCustomerRespDto.getLimitCount());
                            dto.setRemainingNum(Integer.valueOf(controlItemCustomerRespDto.getLimitCount() - purchasedCount));
                            controlItemMsgRespDtos.add(dto);
                            itemControlFlags.add(1);
                            if (!ControlTypeEnum.CONTROL.getType().equals(controlItemRespDto.getControlType())) continue;
                            allowSubmits.add(false);
                            itemControlFlags.add(2);
                        }
                        break block15;
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)controlItemRespDto.getAreaList())) break block15;
                    logger.info("\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u7ba1\u63a7");
                    boolean onFirstPlaceOrderTime = this.checkCustomerByFirstPlaceOrder(orderReqDto.getCustomerId());
                    if (onFirstPlaceOrderTime) {
                        logger.info("\u7528\u6237\u9996\u8d2d\u8ddd\u79bb\u5f53\u524d\u65f6\u95f4\u672a\u8d85\u8fc790\u5929\uff0c\u4e0d\u8fdb\u884c\u7ba1\u63a7\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                        return;
                    }
                    List areaList = controlItemRespDto.getAreaList().stream().filter(controlArea -> areaCodeList.contains(controlArea.getAreaCode()) && itemIdToMap.containsKey(controlArea.getItemId())).collect(Collectors.toList());
                    Map<String, List<ControlItemAreaRespDto>> areaItemMap = controlItemRespDto.getAreaList().stream().collect(Collectors.groupingBy(ControlItemAreaRespDto::getAreaCode));
                    logger.info("\u6307\u5b9a\u7684\u5ba2\u6237\u533a\u57df\u5546\u54c1\u7ba1\u63a7:{}", (Object)JSON.toJSONString(areaItemMap));
                    String areaCode = "";
                    if (CollectionUtils.isNotEmpty(areaList)) {
                        areaCode = ((ControlItemAreaRespDto)areaList.get(0)).getAreaCode();
                    } else {
                        logger.error("\u6307\u5b9a\u5ba2\u6237\u533a\u57df-\u8be5\u5546\u54c1\u4e0d\u5b58\u5728\u6e05\u5355\u4e2d: {}", (Object)JSON.toJSONString((Object)customerRespDto.getRegionCodeList()));
                        areaCode = ((ControlItemAreaRespDto)controlItemRespDto.getAreaList().get(0)).getAreaCode();
                    }
                    List<ControlItemAreaRespDto> controlItemAreaRespDtos = areaItemMap.get(areaCode);
                    List itemIds = controlItemAreaRespDtos.stream().map(ControlItemAreaRespDto::getItemId).collect(Collectors.toList());
                    if (SharePurchaseRestrictionEnum.NO_SHARE.getType().equals(controlItemRespDto.getSharePurchaseRestriction())) {
                        List controlItemCustomerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlItemCustomerQueryApi.queryItemCustomerByAreaAndItemIds(areaCode, itemIds, controlItemRespDto.getId()));
                        logger.info("\u67e5\u8be2\u6307\u5b9a\u5ba2\u6237\u8868\u4e2d\u5c5e\u4e8e\u6307\u5b9a\u533a\u57df\u7684\u5546\u54c1:{}", (Object)controlItemCustomerRespDtos.size());
                        if (CollectionUtils.isNotEmpty((Collection)controlItemCustomerRespDtos)) {
                            for (ControlItemCustomerRespDto controlItemCustomerRespDto : controlItemCustomerRespDtos) {
                                OrderItemBaseReqDto orderItemBaseReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemCustomerRespDto.getItemId());
                                if (orderItemBaseReqDto == null || controlItemCustomerRespDto.getLimitCount() == null) continue;
                                Integer limitCount = controlItemCustomerRespDto.getLimitCount();
                                Integer purchasedCount = controlItemCustomerRespDto.getPurchasedCount() == null ? 0 : controlItemCustomerRespDto.getPurchasedCount();
                                Integer itemNum = orderItemBaseReqDto.getItemNum();
                                logger.info("\u5355\u54c1\u7ba1\u63a7\u5ba2\u6237\u533a\u57df\u72ec\u4eab\u9650\u8d2d={},\u7d2f\u8ba1\u6570\u91cf={},\u5546\u54c1\u6570\u91cf={}", new Object[]{limitCount, purchasedCount, itemNum});
                                if (itemNum <= limitCount - purchasedCount) continue;
                                ControlItemMsgRespDto dto = new ControlItemMsgRespDto();
                                CubeBeanUtils.copyProperties((Object)dto, (Object)orderItemBaseReqDto, (String[])new String[0]);
                                dto.setItemId(controlItemCustomerRespDto.getItemId());
                                dto.setItemName(controlItemCustomerRespDto.getItemName());
                                dto.setExceedNum(Integer.valueOf(itemNum + purchasedCount - limitCount));
                                dto.setLimitCount(controlItemCustomerRespDto.getLimitCount());
                                dto.setRemainingNum(Integer.valueOf(limitCount - purchasedCount));
                                controlItemMsgRespDtos.add(dto);
                                itemControlFlags.add(1);
                                if (!ControlTypeEnum.CONTROL.getType().equals(controlItemRespDto.getControlType())) continue;
                                allowSubmits.add(false);
                                itemControlFlags.add(2);
                            }
                        } else {
                            for (ControlItemAreaRespDto controlItemAreaRespDto : areaList) {
                                OrderItemBaseReqDto tradeItemReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemAreaRespDto.getItemId());
                                if (tradeItemReqDto == null || controlItemAreaRespDto.getLimitCount() == null || controlItemAreaRespDto.getLimitCount() >= tradeItemReqDto.getItemNum()) continue;
                                ControlItemMsgRespDto dto = new ControlItemMsgRespDto();
                                CubeBeanUtils.copyProperties((Object)dto, (Object)tradeItemReqDto, (String[])new String[0]);
                                dto.setItemId(controlItemAreaRespDto.getItemId());
                                dto.setItemName(controlItemAreaRespDto.getItemName());
                                dto.setExceedNum(Integer.valueOf(tradeItemReqDto.getItemNum() - controlItemAreaRespDto.getLimitCount()));
                                dto.setLimitCount(controlItemAreaRespDto.getLimitCount());
                                dto.setRemainingNum(controlItemAreaRespDto.getLimitCount());
                                controlItemMsgRespDtos.add(dto);
                                itemControlFlags.add(1);
                                if (!ControlTypeEnum.CONTROL.getType().equals(controlItemRespDto.getControlType())) continue;
                                allowSubmits.add(false);
                                itemControlFlags.add(2);
                            }
                        }
                    } else {
                        for (ControlItemAreaRespDto controlItemAreaRespDto : areaList) {
                            OrderItemBaseReqDto tradeItemReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemAreaRespDto.getItemId());
                            if (tradeItemReqDto == null || controlItemAreaRespDto.getLimitCount() == null) continue;
                            Integer limitCount = controlItemAreaRespDto.getLimitCount();
                            Integer purchasedCount = controlItemAreaRespDto.getPurchasedCount() == null ? 0 : controlItemAreaRespDto.getPurchasedCount();
                            Integer itemNum = tradeItemReqDto.getItemNum();
                            logger.info("\u5355\u54c1\u7ba1\u63a7\u5ba2\u6237\u533a\u57df\u5171\u4eab\u9650\u8d2d={},\u7d2f\u8ba1\u6570\u91cf={},\u5546\u54c1\u6570\u91cf={}", new Object[]{limitCount, purchasedCount, itemNum});
                            if (itemNum <= limitCount - purchasedCount) continue;
                            ControlItemMsgRespDto dto = new ControlItemMsgRespDto();
                            CubeBeanUtils.copyProperties((Object)dto, (Object)tradeItemReqDto, (String[])new String[0]);
                            dto.setItemId(controlItemAreaRespDto.getItemId());
                            dto.setItemName(controlItemAreaRespDto.getItemName());
                            dto.setExceedNum(Integer.valueOf(itemNum + purchasedCount - limitCount));
                            dto.setLimitCount(controlItemAreaRespDto.getLimitCount());
                            dto.setRemainingNum(Integer.valueOf(limitCount - purchasedCount));
                            controlItemMsgRespDtos.add(dto);
                            itemControlFlags.add(1);
                            if (!ControlTypeEnum.CONTROL.getType().equals(controlItemRespDto.getControlType())) continue;
                            allowSubmits.add(false);
                            itemControlFlags.add(2);
                        }
                    }
                }
            });
            controlRespDto.setControlItemMsgRespDtos((List)controlItemMsgRespDtos);
            if (CollectionUtils.isNotEmpty((Collection)allowSubmits)) {
                controlRespDto.setAllowSubmit(!allowSubmits.contains(false));
            }
            if (CollectionUtils.isNotEmpty((Collection)itemControlFlags)) {
                controlRespDto.setItemControlFlag(itemControlFlags.contains(2) ? 2 : 1);
            }
        }
        logger.info("\u5355\u54c1\u7ba1\u63a7\u7ed3\u675f========\u300b");
    }

    @Override
    public void checkInventoryControl(OrderReqDto orderReqDto, Long orgId) {
        Long customerId = ParamConverter.convertToLong((Object)orderReqDto.getCustomerId());
        List<Long> customerIdList = Collections.singletonList(customerId);
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customerIdList));
        if (CollectionUtils.isEmpty((Collection)customerRespDtos)) {
            logger.info("\u8be5\u7ba1\u63a7\u89c4\u5219\u5ba2\u6237{}\u4e0d\u5b58\u5728", (Object)customerId);
            return;
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
        List<Long> itemIdList = orderReqDto.getOrderItems().stream().map(tradeItemReqDto -> ParamConverter.convertToLong((Object)tradeItemReqDto.getItemSerial())).collect(Collectors.toList());
        Map itemIdToMap = orderReqDto.getOrderItems().stream().collect(Collectors.toMap(tradeItemReqDto -> ParamConverter.convertToLong((Object)tradeItemReqDto.getItemSerial()), Function.identity(), (old, now) -> old));
        CustomerControlInventoryReqDto reqDto = new CustomerControlInventoryReqDto();
        reqDto.setCustomerId(ParamConverter.convertToLong((Object)orderReqDto.getCustomerId()));
        reqDto.setItemIdList(itemIdList);
        reqDto.setOrgId(orgId);
        List areaCodeList = Optional.ofNullable(customerRespDto.getRegionCodeList()).orElse(Lists.newArrayList()).stream().filter(e -> StringUtils.isNotEmpty((String)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(areaCodeList)) {
            ParentAreCodeReqDto parentAreCodeReqDto = new ParentAreCodeReqDto();
            parentAreCodeReqDto.setCodes(areaCodeList);
            List parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryAllParentCode(parentAreCodeReqDto));
            if (CollectionUtils.isNotEmpty((Collection)parentAreaCodeList)) {
                parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
                reqDto.setCustomerAreaCodeList(parentAreaCodeList);
            }
        }
        logger.info("\u67e5\u8be2\u5ba2\u6237\u5e93\u5b58\u5b89\u5168\u7ba1\u63a7\u89c4\u5219\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqDto));
        List controlInventoryItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.controlInventoryQueryApi.queryRuleByCustomerNew(reqDto));
        if (CollectionUtils.isNotEmpty((Collection)controlInventoryItemRespDtos)) {
            Map itemIdMap = controlInventoryItemRespDtos.stream().collect(Collectors.toMap(ControlInventoryItemRespDto::getItemId, Function.identity(), (old, now) -> old));
            itemIdList.forEach(itemId -> {
                Double available;
                ControlInventoryItemRespDto controlInventoryItemRespDto = (ControlInventoryItemRespDto)itemIdMap.get(itemId);
                TradeItemReqDto tradeItemReqDto = (TradeItemReqDto)itemIdToMap.get(itemId);
                if (null == controlInventoryItemRespDto) {
                    return;
                }
                TcbjAvilableReqDto tcbjAvilableReqDto = new TcbjAvilableReqDto();
                tcbjAvilableReqDto.setWarehouseCode(orderReqDto.getWarehouseCode());
                tcbjAvilableReqDto.setCargoCode(tradeItemReqDto.getSkuCode());
                TcbjAvilableReqDto sonTcbjAvilableReqDto = new TcbjAvilableReqDto();
                sonTcbjAvilableReqDto.setCargoCode(tradeItemReqDto.getSkuCode());
                sonTcbjAvilableReqDto.setWarehouseCode(orderReqDto.getWarehouseCode());
                tcbjAvilableReqDto.setList(Collections.singletonList(sonTcbjAvilableReqDto));
                logger.info("\u7ec4\u88c5\u7684\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u7684\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)tcbjAvilableReqDto));
                List tcbjAvilableRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.inventoryApi.avilableYingXiaoYun(tcbjAvilableReqDto));
                logger.info("\u67e5\u8be2\u53ef\u7528\u5e93\u5b58\u7684\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)tcbjAvilableRespDtos));
                if (CollectionUtils.isNotEmpty((Collection)tcbjAvilableRespDtos) && Double.valueOf((available = ((TcbjAvilableRespDto)tcbjAvilableRespDtos.get(0)).getAvailable()) - (double)controlInventoryItemRespDto.getFloorInventoryCount().intValue()).compareTo((double)tradeItemReqDto.getItemNum()) < 0) {
                    throw new BizException(String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u53d7\u5b89\u5168\u5e93\u5b58\u7ba1\u63a7\uff0c\u7ba1\u63a7\u89c4\u5219id\u4e3a%d, \u53d7\u7ba1\u63a7\u5546\u54c1\u7f16\u7801\u4e3a%s, \u8be5\u5546\u54c1\u7684\u53ef\u7528\u5e93\u5b58\u4e3a%f, \u7ba1\u63a7\u89c4\u5219\u8bbe\u7f6e\u7684\u5b89\u5168\u5e93\u5b58\u4e3a%d, \u8d2d\u4e70\u7684\u5546\u54c1\u6570\u91cf\u4e3a%d", tradeItemReqDto.getItemName(), controlInventoryItemRespDto.getRuleId(), controlInventoryItemRespDto.getItemCode(), available, controlInventoryItemRespDto.getFloorInventoryCount(), tradeItemReqDto.getItemNum()));
                }
            });
        }
    }

    @Override
    public void recalculatePrice(Long customerId, List<PlaceOrderItemReqDto> placeOrderItemReqDtos) {
        ArrayList skuActivityPriceDtos = Lists.newArrayList();
        Map<Long, ItemPolicyPriceRespDto> itemPolicyPriceRespDtoMap = this.priceService.getItemDistributePolicyMap(placeOrderItemReqDtos, customerId, new Date());
        placeOrderItemReqDtos.stream().forEach(placeOrderItemReqDto -> {
            ItemPolicyPriceRespDto itemPolicyPriceRespDto = (ItemPolicyPriceRespDto)itemPolicyPriceRespDtoMap.get(placeOrderItemReqDto.getSkuId());
            BigDecimal itemPrice = this.itemPriceHelper.getActualPolicyPrice(itemPolicyPriceRespDto, placeOrderItemReqDto.getItemNum());
            logger.info("\u5546\u54c1\u7f16\u53f7\uff1a{},\u653f\u7b56\u4ef7\u683c:{}", (Object)placeOrderItemReqDto.getItemCode(), (Object)itemPrice);
            placeOrderItemReqDto.setSellPrice(itemPrice != null ? itemPrice : placeOrderItemReqDto.getSellPrice());
            ItemSkuActivityPriceDto skuActivityPriceDto = new ItemSkuActivityPriceDto();
            skuActivityPriceDto.setItemId(placeOrderItemReqDto.getItemId());
            skuActivityPriceDto.setSkuId(placeOrderItemReqDto.getSkuId());
            skuActivityPriceDto.setShopId(placeOrderItemReqDto.getShopId());
            skuActivityPriceDto.setCustomerId(customerId);
            skuActivityPriceDto.setSellPrice(placeOrderItemReqDto.getSellPrice());
            skuActivityPriceDtos.add(skuActivityPriceDto);
        });
        ActivityPriceBranchQueryReqDto branchQueryReqDto = new ActivityPriceBranchQueryReqDto();
        branchQueryReqDto.setItemSkuActivityPriceList((List)skuActivityPriceDtos);
        List itemSkuActivityPriceDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemActivityStockApi.queryBranchItemSkuActivityPrice(branchQueryReqDto));
        logger.info("\u67e5\u8be2\u6d3b\u52a8\u4ef7\u683c\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)itemSkuActivityPriceDtos));
        for (PlaceOrderItemReqDto placeOrderItemReqDto2 : placeOrderItemReqDtos) {
            ItemActivityPriceReqDto activityPrice;
            ItemSkuActivityPriceDto activityPriceDto;
            Map<Long, ItemSkuActivityPriceDto> priceMap = itemSkuActivityPriceDtos.stream().collect(Collectors.toMap(ItemSkuActivityPriceDto::getActivityId, e -> e, (e1, e2) -> e1));
            if (placeOrderItemReqDto2.getActivityPrice() != null && (activityPriceDto = priceMap.get((activityPrice = placeOrderItemReqDto2.getActivityPrice()).getActivityId())) != null) {
                activityPrice.setActivityPrice(activityPriceDto.getActivityPrice());
            }
            if (!CollectionUtils.isNotEmpty((Collection)placeOrderItemReqDto2.getActivityPriceList())) continue;
            List activityPriceList = placeOrderItemReqDto2.getActivityPriceList();
            for (ItemActivityPriceRespDto priceRespDto : activityPriceList) {
                ItemSkuActivityPriceDto activityPriceDto2 = priceMap.get(priceRespDto.getActivityId());
                if (activityPriceDto2 == null) continue;
                priceRespDto.setActivityPrice(activityPriceDto2.getActivityPrice());
            }
        }
    }

    private void updateCustomerInventory(Map<Long, OrderItemBaseReqDto> itemIdToMap, List<ControlItemCustomerRespDto> controlItemCustomerRespDtos) {
        controlItemCustomerRespDtos.forEach(controlItemCustomerRespDto -> {
            OrderItemBaseReqDto tradeItemReqDto = (OrderItemBaseReqDto)itemIdToMap.get(controlItemCustomerRespDto.getItemId());
            Integer update = (Integer)RestResponseHelper.extractData((RestResponse)this.controlItemCustomerApi.modifyPurchasedCount(tradeItemReqDto.getItemNum(), controlItemCustomerRespDto.getId()));
            if (null == update) {
                Integer purchasedCount = controlItemCustomerRespDto.getPurchasedCount() == null ? 0 : controlItemCustomerRespDto.getPurchasedCount();
                throw new BizException(String.format("\u8be5\u8ba2\u5355\u8d2d\u4e70\u7684\u5546\u54c1%s\u8d85\u8fc7\u5355\u54c1\u7ba1\u63a7\u7684\u9650\u8d2d\u91cf\uff0c\u9650\u8d2d\u91cf\u4e3a%d,\u5f53\u524d\u7d2f\u8ba1\u8d2d\u4e70\u6570\u91cf%d,\u672c\u6b21\u8d2d\u4e70\u6570\u91cf%d", tradeItemReqDto.getItemCode(), controlItemCustomerRespDto.getLimitCount(), purchasedCount, tradeItemReqDto.getItemNum()));
            }
        });
    }

    private void buildInsertItemCustomerReqDtos(Long customerId, CustomerExtDetailRespDto customerExtDetailRespDto, List<ControlItemAreaRespDto> controlItemAreaRespDtos, List<ControlItemCustomerReqDto> insertControlItemCustomerReqDtos) {
        insertControlItemCustomerReqDtos.addAll(controlItemAreaRespDtos.stream().map(controlItemAreaRespDto -> {
            ControlItemCustomerReqDto controlItemCustomerReqDto = new ControlItemCustomerReqDto();
            controlItemCustomerReqDto.setItemId(controlItemAreaRespDto.getItemId());
            controlItemCustomerReqDto.setItemCode(controlItemAreaRespDto.getItemCode());
            controlItemCustomerReqDto.setCustomerId(customerId);
            controlItemCustomerReqDto.setCustomerName(customerExtDetailRespDto.getCustomerName());
            controlItemCustomerReqDto.setAreaCode(controlItemAreaRespDto.getAreaCode());
            controlItemCustomerReqDto.setCalculateType(controlItemAreaRespDto.getCalculateType());
            controlItemCustomerReqDto.setLimitContent(controlItemAreaRespDto.getLimitContent());
            controlItemCustomerReqDto.setEnableArea(YesNoEnum.YES.getValue());
            controlItemCustomerReqDto.setLimitCount(controlItemAreaRespDto.getLimitCount());
            Integer purchasedCount = controlItemAreaRespDto.getPurchasedCount() == null ? 0 : controlItemAreaRespDto.getPurchasedCount();
            controlItemCustomerReqDto.setPurchasedCount(purchasedCount);
            controlItemCustomerReqDto.setRuleId(controlItemAreaRespDto.getRuleId());
            return controlItemCustomerReqDto;
        }).collect(Collectors.toList()));
    }
}

