/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.pay;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.payment.api.trade.ICreateTradeService;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.VerifyException;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundRequest;
import com.dtyunxi.yundt.cube.center.payment.dto.trade.RefundResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.dto.request.SimplePayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.WeChatPayReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AddPayRecordReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.WeChatPayRespDto;
import com.dtyunxi.yundt.module.trade.biz.config.PayConfig;
import com.dtyunxi.yundt.module.trade.biz.pay.AbstractPayHelp;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="weChatPayPayHelp")
public class WeChatPayPayHelp
extends AbstractPayHelp<WeChatPayRespDto> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayConfig payConfig;
    @Resource
    private ICreateTradeService createTradeService;
    @Autowired
    private IContext iContext;
    private static final String WECHAT = "101";
    @Value(value="${yundt.cube.center.payment.appvo.apiSecret}")
    public String apiSecret;

    @Override
    public SimplePayReqDto initParam(Object ... objects) {
        SimplePayReqDto simplePayReqDto = new SimplePayReqDto();
        WeChatPayReqDto weChatPayReqDto = new WeChatPayReqDto();
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)weChatPayReqDto);
        }
        for (Object object : objects) {
            BeanUtils.copyProperties((Object)object, (Object)simplePayReqDto);
        }
        simplePayReqDto.setWeChatPayReqDto(weChatPayReqDto);
        return simplePayReqDto;
    }

    @Override
    protected SimplePayReqDto buildResult(SimplePayReqDto request) {
        return request;
    }

    @Override
    public SimplePayReqDto map2Bean(Map<String, Object> request) {
        String re = JSON.toJSONString(request);
        SimplePayReqDto simplePayReqDto = (SimplePayReqDto)JSON.parseObject((String)re, SimplePayReqDto.class);
        WeChatPayReqDto weChatPayReqDto = (WeChatPayReqDto)JSON.parseObject((String)re, WeChatPayReqDto.class);
        simplePayReqDto.setWeChatPayReqDto(weChatPayReqDto);
        return simplePayReqDto;
    }

    @Override
    public void buildOrderRecord(SimplePayReqDto simplePayReqDto, AddPayRecordReqDto addPayRecordReqDto) {
        WeChatPayReqDto weChatPayReqDto = simplePayReqDto.getWeChatPayReqDto();
        addPayRecordReqDto.setOpenId(weChatPayReqDto.getOpenId());
    }

    @Override
    public void errorCallBack(SimplePayReqDto request) {
    }

    @Override
    public void successCallBackDefine(SimplePayReqDto simplePayReqDto) {
        this.addOrderPayRecord(simplePayReqDto);
    }

    @Override
    public boolean allowSubmitOrder(SimplePayReqDto request) {
        return false;
    }

    @Override
    public boolean isPrePayed(SimplePayReqDto simplePayReqDto) {
        return false;
    }

    @Override
    public void customerConfirmRefund(SimplePayReqDto simplePayReqDto) {
        RefundRequest payRequest = new RefundRequest();
        WeChatPayReqDto weChatPayReqDto = simplePayReqDto.getWeChatPayReqDto();
        try {
            payRequest.setStoreId(this.payConfig.getStoreId());
            payRequest.setAppId(this.payConfig.getAppId());
            payRequest.setAppName(this.payConfig.getAppName());
            payRequest.setStoreRefundId(simplePayReqDto.getOrderNo());
            payRequest.setTradeId(weChatPayReqDto.getExtlPaySerial());
            payRequest.setStoreOrderId(weChatPayReqDto.getPayNo());
            payRequest.setNotifyUrl(this.payConfig.getRefundNotifyUrl() + simplePayReqDto.getOrderNo() + "/" + this.iContext.instanceId() + "/" + simplePayReqDto.getRefundNo());
            payRequest.setUserId(this.iContext.userId() + "");
            payRequest.setRefundAmt(simplePayReqDto.getRefundAmount().setScale(2, 1));
            String apiSecret = this.apiSecret;
            if (StringUtils.isBlank((CharSequence)apiSecret)) {
                apiSecret = this.payConfig.getApiSecret();
            }
            try {
                payRequest.doEncrypt(this.payConfig.getApiSecret());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            RefundResponse response = null;
            this.logger.info("\u5fae\u4fe1\u9000\u6b3esendpay params:{}", (Object)JSON.toJSONString((Object)payRequest));
            response = this.createTradeService.createRefundOrder(payRequest);
            this.logger.info("\u5fae\u4fe1\u9000\u6b3esendpay resp:{}", (Object)JSON.toJSONString((Object)response));
            try {
                response.verifySign(apiSecret);
            }
            catch (Exception e) {
                response.verifyGlobalSign(apiSecret);
            }
        }
        catch (VerifyException e) {
            this.logger.error("\u53d1\u8d77\u9000\u6b3e\u5f02\u5e38", (Throwable)e);
            throw new BizException(e.getMessage());
        }
    }
}

