/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.biz.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerRelationQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesApi;
import com.dtyunxi.yundt.cube.center.trade.api.IAfterSalesTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.constants.DeliveryCancelTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.OptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.RefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.OptBizTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.ReturnOrderCreateModeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ReturnReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.FinReviewToBReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.OptLogReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.RefundDetailTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.RefundTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnModTobReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.ReturnDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IAfterSalesQueryTobApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderDeliveryQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.IRefundQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.IOptLogApi;
import com.dtyunxi.yundt.cube.center.trade.api.tob.query.IAttachementQueryApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.trade.api.IOrderAfterSalesExt;
import com.dtyunxi.yundt.module.trade.api.IOrderService;
import com.dtyunxi.yundt.module.trade.api.IinventoryService;
import com.dtyunxi.yundt.module.trade.api.constant.TradeConstant;
import com.dtyunxi.yundt.module.trade.api.dto.OrderItemExtDto;
import com.dtyunxi.yundt.module.trade.api.dto.TcbjMessageVo;
import com.dtyunxi.yundt.module.trade.api.dto.request.AfterSalesApplyItemReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.ApplyReturnItemBatchDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AfterSalesUpdateExtReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderAuditToBReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.OrderListQueryReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderItemSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveExtReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.SettlementInfoRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ItemRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.OrderListRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.DeliveryStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.OrderReturnBizTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.OrderTradeStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PayMethodEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PayStatusEnum;
import com.dtyunxi.yundt.module.trade.api.enums.PlaceTypeEnum;
import com.dtyunxi.yundt.module.trade.api.enums.ReturnStatusToBEnum;
import com.dtyunxi.yundt.module.trade.api.enums.TradeModuleExcpCode;
import com.dtyunxi.yundt.module.trade.biz.ICommonService;
import com.dtyunxi.yundt.module.trade.biz.config.TcbjMessageCommonConfig;
import com.dtyunxi.yundt.module.trade.biz.service.OrderInformMqService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaAccountRespDto;
import com.yx.tcbj.center.rebate.api.query.IReturnsQuotaAccountQueryApi;
import com.yx.tcbj.center.trade.api.dto.response.RefundDisposeConfigRespDto;
import com.yx.tcbj.center.trade.api.query.IRefundDisposeConfigQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class OrderAfterSalesExtImpl
implements IOrderAfterSalesExt {
    private static final Logger logger = LoggerFactory.getLogger(OrderAfterSalesExtImpl.class);
    @Resource
    private IContext context;
    @Resource
    private IOrderQueryApi iOrderQueryApi;
    @Autowired
    private IAfterSalesQueryApi afterSalesQueryApi;
    @Resource
    private IOrderService orderService;
    @Resource
    private IUnitQueryApi unitQueryApi;
    @Resource
    private IAttachementQueryApi attachementQueryApi;
    @Resource
    private IAfterSalesApi afterSalesApi;
    @Resource
    private IOrderDeliveryQueryApi orderDeliveryQueryApi;
    @Resource
    private IRefundQueryApi refundQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IAfterSalesTobApi afterSalesTobApi;
    @Resource
    private IAfterSalesQueryTobApi afterSalesQueryTobApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ICommonService commonService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IOptLogApi optLogApi;
    @Autowired
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IOrderDeliveryQueryApi orderDeliveryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${order.after.sales.to.tcbj.topic:ORDER_AFTER_SALES_TO_TCBJ_TOPIC}")
    private String ORDER_AFTER_SALES_TO_TCBJ_TOPIC;
    @Value(value="${order.after.sales.to.tcbj.tag:ORDER_AFTER_SALES_TO_TCBJ_TAG}")
    private String ORDER_AFTER_SALES_TO_TCBJ_TAG;
    @Value(value="${order.after.sales.check:false}")
    private boolean checkImarketingCloud;
    @Autowired
    private TcbjMessageCommonConfig tcbjMessageCommonConfig;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private OrderInformMqService orderInformMqService;
    @Resource
    private IRefundDisposeConfigQueryApi refundDisposeConfigQueryApi;
    @Resource
    private IReturnsQuotaAccountQueryApi returnsQuotaAccountQueryApi;
    @Resource
    private IinventoryService iinventoryService;
    private String CACHE_SET = "SET";
    @Resource
    private ICustomerRelationQueryApi customerRelationQueryApi;

    public BigDecimal queryReturnQuotaByCust(Long customerId) {
        BigDecimal leftReturnQuota = BigDecimal.ZERO;
        org.springframework.util.Assert.notNull((Object)customerId, (String)"\u5ba2\u6237\u53c2\u6570\u9519\u8bef");
        RestResponse restResponse = this.returnsQuotaAccountQueryApi.queryByCustomerId(customerId);
        ReturnsQuotaAccountRespDto quotaAccountRespDto = (ReturnsQuotaAccountRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (quotaAccountRespDto != null) {
            BigDecimal generalReturnsQuota = quotaAccountRespDto.getGeneralReturnsQuota() == null ? BigDecimal.ZERO : quotaAccountRespDto.getGeneralReturnsQuota();
            BigDecimal advanceQuota = quotaAccountRespDto.getAdvanceQuota() == null ? BigDecimal.ZERO : quotaAccountRespDto.getAdvanceQuota();
            leftReturnQuota = generalReturnsQuota.add(advanceQuota);
        }
        return leftReturnQuota;
    }

    public BigDecimal queryReturnQuotaBySeller(Long sellerId) {
        BigDecimal leftReturnQuota = BigDecimal.ZERO;
        Long customerId = null;
        ServiceContext serviceContext = ServiceContext.getContext();
        String CUSTOMERID_HEAD = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        customerId = StringUtils.isNotEmpty((CharSequence)CUSTOMERID_HEAD) ? Long.valueOf(CUSTOMERID_HEAD) : this.commonService.getCustomerIdByUserIdAndSellerId(this.context.userId(), sellerId);
        org.springframework.util.Assert.notNull((Object)customerId, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        RestResponse restResponse = this.returnsQuotaAccountQueryApi.queryByCustomerId(customerId);
        ReturnsQuotaAccountRespDto quotaAccountRespDto = (ReturnsQuotaAccountRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (quotaAccountRespDto != null) {
            BigDecimal generalReturnsQuota = quotaAccountRespDto.getGeneralReturnsQuota() == null ? BigDecimal.ZERO : quotaAccountRespDto.getGeneralReturnsQuota();
            BigDecimal advanceQuota = quotaAccountRespDto.getAdvanceQuota() == null ? BigDecimal.ZERO : quotaAccountRespDto.getAdvanceQuota();
            leftReturnQuota = generalReturnsQuota.add(advanceQuota);
        }
        return leftReturnQuota;
    }

    public String addAfterSalesByOrder(ReturnOrderSaveExtReqDto reqDto) {
        ReturnReqDto returnReqDto = new ReturnReqDto();
        this.initAndValidOrderParams(reqDto);
        String customerId = null;
        ServiceContext serviceContext = ServiceContext.getContext();
        String CUSTOMERID_HEAD = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNotEmpty((CharSequence)CUSTOMERID_HEAD)) {
            customerId = CUSTOMERID_HEAD;
            returnReqDto.setDeviceType("SALESMAN");
            org.springframework.util.Assert.isTrue((boolean)customerId.equals(reqDto.getCustomerId()), (String)"\u8ba2\u8d27\u5355\u7684\u5ba2\u6237\u548c\u9009\u62e9\u7684\u5ba2\u6237\u4e0d\u4e00\u81f4");
        } else {
            returnReqDto.setDeviceType("APP");
            customerId = returnReqDto.getCustomerId();
        }
        this.verifyOrderAfterSale(Long.valueOf(customerId));
        List<ReturnOrderItemSaveReqDto> itemList = reqDto.getItemList().stream().filter(e -> e.getNum() != null && e.getNum() > 0).collect(Collectors.toList());
        if (itemList.isEmpty()) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u7533\u8bf7\u552e\u540e\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long applyReturnQty = itemList.stream().mapToLong(e -> e.getNum().intValue()).sum();
        reqDto.setApplyReturnQty(applyReturnQty);
        this.setItemSubType(itemList);
        List supplierReturnList = itemList.stream().map(e -> this.convertReturnItem((ReturnOrderItemSaveReqDto)e, ReturnOrderCreateModeEnum.FROM_ORDER.getType())).collect(Collectors.toList());
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
        returnReqDto.setOrderTradeNo(reqDto.getOrderNo());
        returnReqDto.setTradeNo(reqDto.getOrderNo());
        returnReqDto.setReturnType(StringUtils.isBlank((CharSequence)reqDto.getOrderReturnBizType()) ? OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode() : reqDto.getOrderReturnBizType());
        returnReqDto.setRefundAmount(reqDto.getRefundAmount());
        returnReqDto.setReqReason(reqDto.getReqReason());
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("refundStatus", RefundStatusEnum.INIT.getName());
        addrExtFields.put("totalAmount", reqDto.getRefundAmount());
        addrExtFields.put("placeUserId", this.context.userId());
        addrExtFields.put("placeTime", reqDto.getPlaceTime() == null ? new Date() : reqDto.getPlaceTime());
        addrExtFields.put("remark", reqDto.getRemark());
        addrExtFields.put("customerId", Long.valueOf(reqDto.getCustomerId()));
        addrExtFields.put("attachements", reqDto.getAttachmentList());
        addrExtFields.put("buyerAddrInfo", JSON.toJSONString((Object)reqDto.getBuyerAddress()));
        addrExtFields.put("applyReturnQty", reqDto.getApplyReturnQty());
        addrExtFields.put("shopId", reqDto.getShopId());
        addrExtFields.put("sellerId", reqDto.getSellerId());
        addrExtFields.put("createMode", ReturnOrderCreateModeEnum.FROM_ORDER.getType());
        addrExtFields.put("returnReason", reqDto.getReqReason());
        returnReqDto.setExtFields(addrExtFields);
        returnReqDto.setCustomerId(customerId);
        RestResponse mapRestResponse = this.afterSalesApi.addAfterSaleApply(returnReqDto);
        Map result = (Map)RestResponseHelper.extractData((RestResponse)mapRestResponse);
        String returnNo = (String)result.get("returnNo");
        logger.info("\u751f\u6210\u9000\u8d27\u5355\u54cd\u5e94\u4fe1\u606f\uff1a{},\u6821\u9a8c\u662f\u5426\u540c\u6b65\u8425\u9500\u4e91", (Object)JSON.toJSONString((Object)result));
        if ("TRUE".equals(result.get("autoCSAudit"))) {
            this.sendOrderAfterSalesMessageToTcbj(returnNo);
        }
        return (String)result.get("returnNo");
    }

    private void setItemSubType(List<ReturnOrderItemSaveReqDto> itemList) {
        Set itemIdSet = itemList.stream().filter(e -> e.getItemId() != null).map(e -> e.getItemId()).collect(Collectors.toSet());
        List itemRespDtoList = (List)this.itemQueryApi.queryByItemIds(StringUtils.join(itemIdSet, (String)",")).getData();
        Map<Long, Integer> itemSubTypeMaps = itemRespDtoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getSubType(), (key1, key2) -> key2));
        itemList.forEach(e -> {
            Integer subType = (Integer)itemSubTypeMaps.get(e.getItemId());
            e.setSubType(subType);
        });
    }

    private AfterSalesItemReqDto convertReturnItem(ReturnOrderItemSaveReqDto returnOrderItemDto, String createMode) {
        AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
        if (ReturnOrderCreateModeEnum.FROM_MANUAL_SKU.getType().equals(createMode)) {
            returnOrderItemDto.setReturnedNum(Integer.valueOf(0));
        }
        if (returnOrderItemDto.getItemPrice() == null) {
            returnOrderItemDto.setItemPrice(BigDecimal.ZERO);
        }
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("returnedNum", returnOrderItemDto.getReturnedNum());
        extFields.put("returnNum", returnOrderItemDto.getNum());
        extFields.put("unit", returnOrderItemDto.getUnit());
        extFields.put("itemAmount", returnOrderItemDto.getItemPrice());
        extFields.put("remark", returnOrderItemDto.getRemark());
        extFields.put("brandCode", returnOrderItemDto.getBrandCode());
        extFields.put("brandId", returnOrderItemDto.getBrandId());
        extFields.put("shopId", returnOrderItemDto.getShopId());
        extFields.put("itemName", returnOrderItemDto.getItemName());
        extFields.put("skuCode", returnOrderItemDto.getSkuCode());
        extFields.put("skuDesc", returnOrderItemDto.getSkuDesc());
        extFields.put("cargoSerial", returnOrderItemDto.getCargoSerial());
        extFields.put("refundAmount", BigDecimal.valueOf(returnOrderItemDto.getNum().intValue()).multiply(returnOrderItemDto.getItemPrice()) + "");
        afterSalesItemReqDto.setItemPrice(returnOrderItemDto.getItemPrice());
        afterSalesItemReqDto.setId(returnOrderItemDto.getId());
        afterSalesItemReqDto.setTradeItemNo(returnOrderItemDto.getTradeItemNo());
        afterSalesItemReqDto.setExtFields(extFields);
        afterSalesItemReqDto.setSkuSerial(Objects.nonNull(returnOrderItemDto.getSkuId()) ? returnOrderItemDto.getSkuId().toString() : null);
        afterSalesItemReqDto.setItemCode(returnOrderItemDto.getItemCode());
        afterSalesItemReqDto.setItemSerial(Objects.nonNull(returnOrderItemDto.getItemId()) ? returnOrderItemDto.getItemId().toString() : null);
        afterSalesItemReqDto.setGift(returnOrderItemDto.getGift());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(StringUtils.isNotEmpty((CharSequence)returnOrderItemDto.getPath()) ? returnOrderItemDto.getPath() : returnOrderItemDto.getImgPath());
        orderItemExtDto.setShelfType(returnOrderItemDto.getShelfType());
        orderItemExtDto.setSubType(returnOrderItemDto.getSubType());
        afterSalesItemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
        afterSalesItemReqDto.setIfExchange(returnOrderItemDto.getIfExchange());
        afterSalesItemReqDto.setIsCombinedPackage(returnOrderItemDto.getIsCombinedPackage());
        afterSalesItemReqDto.setCombinedPackageActivityId(returnOrderItemDto.getCombinedPackageActivityId());
        if (CollectionUtils.isNotEmpty((Collection)returnOrderItemDto.getApplyBatchNo())) {
            StringBuilder sb = new StringBuilder(50);
            for (ApplyReturnItemBatchDto applyReturnItemBatchDto : returnOrderItemDto.getApplyBatchNo()) {
                sb.append(applyReturnItemBatchDto.getBatchNo()).append("#").append(applyReturnItemBatchDto.getNum()).append(",");
            }
            String batchNo = sb.substring(0, sb.length() - 1);
            afterSalesItemReqDto.setBatchNo(batchNo);
        }
        if (StringUtils.isBlank((CharSequence)returnOrderItemDto.getCargoSerial())) {
            afterSalesItemReqDto.setCargoSerial(returnOrderItemDto.getSkuCode());
        }
        return afterSalesItemReqDto;
    }

    private void initAndValidOrderParams(ReturnOrderSaveExtReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getOrderNo())) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqDto.getItemList())) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u552e\u540e\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList inValidItem = Lists.newArrayList();
        for (ReturnOrderItemSaveReqDto returnOrderItemSaveReqDto : reqDto.getItemList()) {
            if (returnOrderItemSaveReqDto.getNum() <= returnOrderItemSaveReqDto.getItemNum()) continue;
            inValidItem.add(returnOrderItemSaveReqDto.getItemName());
        }
        if (CollectionUtils.isNotEmpty((Collection)inValidItem)) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u5546\u54c1[" + StringUtils.join((Iterable)inValidItem, (String)",") + "]\u7533\u8bf7\u552e\u540e\u6570\u91cf\u5927\u4e8e\u8d2d\u4e70\u6570");
        }
        OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)this.iOrderQueryApi.getOrderDetail(reqDto.getOrderNo()).getData();
        reqDto.setSellerId(Long.valueOf(orderDetailRespDto.getSellerId()));
        reqDto.setShopId(Long.valueOf(orderDetailRespDto.getShopId()));
        reqDto.setCustomerId(orderDetailRespDto.getCustomerId());
    }

    public String addAfterSalesManual(ReturnOrderSaveExtReqDto reqDto) {
        this.validateManualParams(reqDto);
        ReturnReqDto returnReqDto = new ReturnReqDto();
        Long customerId = StringUtils.isNumeric((CharSequence)reqDto.getCustomerId()) ? Long.valueOf(reqDto.getCustomerId()) : null;
        ServiceContext serviceContext = ServiceContext.getContext();
        String CUSTOMERID_HEAD = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
        if (customerId == null && StringUtils.isNotEmpty((CharSequence)CUSTOMERID_HEAD)) {
            customerId = Long.valueOf(CUSTOMERID_HEAD);
            reqDto.setSrcType(PlaceTypeEnum.SALESMAN.getCode());
            returnReqDto.setDeviceType("SALESMAN");
        } else if (customerId == null) {
            customerId = this.commonService.getCustomerIdByUserIdAndSellerId(this.context.userId(), reqDto.getSellerId());
            returnReqDto.setDeviceType("APP");
        }
        if (customerId == null) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u4e0d\u662f\u5546\u5bb6\u5ba2\u6237");
        }
        this.verifyOrderAfterSale(customerId);
        List itemList = reqDto.getItemList().stream().filter(e -> e.getNum() != null && e.getNum() > 0).collect(Collectors.toList());
        List supplierReturnList = itemList.stream().map(e -> this.convertReturnItem((ReturnOrderItemSaveReqDto)e, ReturnOrderCreateModeEnum.FROM_MANUAL_SKU.getType())).collect(Collectors.toList());
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setCancelType(DeliveryCancelTypeEnum.NOT_CANCLE.getType());
        returnReqDto.setOrderTradeNo(null);
        returnReqDto.setTradeNo(null);
        reqDto.setRefundAmount(BigDecimal.ZERO);
        returnReqDto.setReturnType(StringUtils.isBlank((CharSequence)reqDto.getOrderReturnBizType()) ? OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode() : reqDto.getOrderReturnBizType());
        returnReqDto.setReqReason(reqDto.getReqReason());
        returnReqDto.setRefundAmount(reqDto.getRefundAmount());
        returnReqDto.setCustomerId(String.valueOf(customerId));
        HashMap<String, Object> addrExtFields = new HashMap<String, Object>();
        addrExtFields.put("refundStatus", RefundStatusEnum.INIT.getName());
        addrExtFields.put("totalAmount", reqDto.getRefundAmount());
        addrExtFields.put("placeUserId", this.context.userId());
        addrExtFields.put("placeTime", reqDto.getPlaceTime() == null ? new Date() : reqDto.getPlaceTime());
        addrExtFields.put("remark", reqDto.getRemark());
        addrExtFields.put("customerId", customerId);
        addrExtFields.put("attachements", reqDto.getAttachmentList());
        addrExtFields.put("buyerAddrInfo", JSON.toJSONString((Object)reqDto.getBuyerAddress()));
        addrExtFields.put("applyReturnQty", reqDto.getApplyReturnQty());
        addrExtFields.put("shopId", reqDto.getShopId());
        addrExtFields.put("sellerId", reqDto.getSellerId());
        addrExtFields.put("createMode", ReturnOrderCreateModeEnum.FROM_MANUAL_SKU.getType());
        addrExtFields.put("returnReason", reqDto.getReqReason());
        returnReqDto.setExtFields(addrExtFields);
        RestResponse mapRestResponse = this.afterSalesApi.addAfterSaleApply(returnReqDto);
        Map result = (Map)RestResponseHelper.extractData((RestResponse)mapRestResponse);
        String returnNo = (String)result.get("returnNo");
        logger.info("\u751f\u6210\u9000\u8d27\u5355\u54cd\u5e94\u4fe1\u606f\uff1a{}\uff0c\u6821\u9a8c\u662f\u5426\u540c\u6b65\u8425\u9500\u4e91", (Object)JSON.toJSONString((Object)result));
        if ("TRUE".equals(result.get("autoCSAudit"))) {
            this.sendOrderAfterSalesMessageToTcbj(returnNo);
        }
        return returnNo;
    }

    private void verifyOrderAfterSale(Long customerId) {
        CustomerRelationRespDto customerRelationRespDto = (CustomerRelationRespDto)RestResponseHelper.extractData((RestResponse)this.customerRelationQueryApi.queryByCustomer(customerId));
        org.springframework.util.Assert.isTrue((boolean)ObjectUtils.isEmpty((Object)customerRelationRespDto), (String)"\u8bf7\u524d\u5f80\u7ecf\u9500\u5546\u8fdb\u9500\u5b58\u7ba1\u7406-\u4e8c\u7ea7\u9000\u8d27\uff0c\u53d1\u8d77\u9000\u8d27");
    }

    private void validateManualParams(ReturnOrderSaveExtReqDto reqDto) {
        BigDecimal itemQty;
        if (CollectionUtils.isEmpty((Collection)reqDto.getItemList()) && CollectionUtils.isEmpty((Collection)reqDto.getAttachmentList())) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u552e\u540e\u5546\u54c1\u6e05\u5355\u6216\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getSellerId() == null || reqDto.getShopId() == null) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u8bf7\u9009\u62e9\u5e97\u94fa");
        }
        Long applyQty = reqDto.getApplyReturnQty();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemList()) && (itemQty = reqDto.getItemList().stream().filter(e -> e.getNum() != null && e.getNum() > 0).map(e -> BigDecimal.valueOf(e.getNum().intValue())).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.valueOf(applyQty)) != 0) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u7533\u8bf7\u6570\u91cf\u548c\u5b9e\u9645\u5546\u54c1\u603b\u6570\u4e0d\u4e00\u81f4");
        }
    }

    public void updateAfterSales(AfterSalesUpdateExtReqDto reqDto) {
        ServiceContext serviceContext;
        String CUSTOMERID_HEAD;
        Long customerId;
        if (!ReturnStatusToBEnum.WAIT_AUDIT.getCode().equals(reqDto.getOrderTradeStatus())) {
            BizExceptionHelper.throwBizException((IExceptionCode)TradeModuleExcpCode.RETURN_NOT_ALLOW_MODIFY);
        }
        ReturnOrderCreateModeEnum createModeEnum = ReturnOrderCreateModeEnum.fromType((String)reqDto.getCreateMode());
        Long l = customerId = StringUtils.isNumeric((CharSequence)reqDto.getCustomerId()) ? Long.valueOf(reqDto.getCustomerId()) : null;
        if (ReturnOrderCreateModeEnum.FROM_MANUAL_SKU.getType().equals(createModeEnum.getType()) && customerId == null && StringUtils.isNotEmpty((CharSequence)(CUSTOMERID_HEAD = (serviceContext = ServiceContext.getContext()).getAttachment("yes.req.cus.b2b.customerid")))) {
            customerId = Long.valueOf(CUSTOMERID_HEAD);
        }
        switch (createModeEnum) {
            case FROM_ORDER: {
                this.validOrderUpdateParams(reqDto);
                OrderDetailRespDto orderDetailRespDto = (OrderDetailRespDto)this.iOrderQueryApi.getOrderDetail(reqDto.getOrderNo()).getData();
                reqDto.setSellerId(Long.valueOf(orderDetailRespDto.getSellerId()));
                reqDto.setShopId(Long.valueOf(orderDetailRespDto.getShopId()));
                reqDto.setCustomerId(orderDetailRespDto.getCustomerId());
                this.setApplyItemSubType(reqDto.getItemList());
                break;
            }
            case FROM_MANUAL_SKU: {
                this.validateManualUpdateParams(reqDto);
                if (customerId == null) {
                    customerId = this.commonService.getCustomerIdByUserIdAndSellerId(this.context.userId(), reqDto.getSellerId());
                }
                reqDto.setCustomerId(String.valueOf(customerId));
                break;
            }
        }
        if (reqDto.getCustomerId() == null) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u7528\u6237\u4e0d\u662f\u5546\u5bb6\u5ba2\u6237");
        }
        List itemList = reqDto.getItemList().stream().filter(e -> e.getNum() != null && e.getNum() > 0).collect(Collectors.toList());
        List supplierReturnList = itemList.stream().map(e -> this.buildSupplierAfterSalesItem((AfterSalesApplyItemReqDto)e, reqDto.getCreateMode())).collect(Collectors.toList());
        if (ReturnOrderCreateModeEnum.FROM_ORDER.getType().equals(reqDto.getCreateMode())) {
            reqDto.setApplyReturnQty(Long.valueOf(itemList.stream().mapToLong(e -> e.getNum().intValue()).sum()));
            BigDecimal applyAmt = itemList.stream().map(e -> BigDecimal.valueOf(e.getNum().intValue()).multiply(e.getItemPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            reqDto.setApplyAmount(applyAmt);
        }
        ReturnModTobReqDto returnReqDto = new ReturnModTobReqDto();
        returnReqDto.setAfterSalesItems(supplierReturnList);
        returnReqDto.setRefundAmount(reqDto.getApplyAmount());
        returnReqDto.setReturnType(StringUtils.isBlank((CharSequence)reqDto.getBizType()) ? OrderReturnBizTypeEnum.REFUND_AND_RETURN.getCode() : reqDto.getBizType());
        returnReqDto.setReturnNo(reqDto.getReturnNo());
        returnReqDto.setRemark(reqDto.getRemark());
        returnReqDto.setAttachements(reqDto.getAttachmentList());
        returnReqDto.setShopId(reqDto.getShopId());
        returnReqDto.setSellerId(reqDto.getSellerId());
        returnReqDto.setCustomerId(reqDto.getCustomerId());
        returnReqDto.setApplyReturnQty(reqDto.getApplyReturnQty());
        returnReqDto.setBuyerAddrInfo(JSON.toJSONString((Object)reqDto.getBuyerAddress()));
        returnReqDto.setOrderTradeNo(reqDto.getOrderNo());
        returnReqDto.setCreateMode(reqDto.getCreateMode());
        returnReqDto.setReqReason(reqDto.getReqReason());
        returnReqDto.setUpdateFlag(TradeConstant.YES);
        RestResponse voidRestResponse = this.afterSalesTobApi.modifyUncertainItemReturnInfo(returnReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)voidRestResponse);
    }

    private void setApplyItemSubType(List<AfterSalesApplyItemReqDto> itemList) {
        Set itemIdSet = itemList.stream().filter(e -> e.getItemId() != null).map(e -> e.getItemId()).collect(Collectors.toSet());
        List itemRespDtoList = (List)this.itemQueryApi.queryByItemIds(StringUtils.join(itemIdSet, (String)",")).getData();
        Map<Long, Integer> itemSubTypeMaps = itemRespDtoList.stream().collect(Collectors.toMap(e -> e.getItemId(), e -> e.getSubType(), (key1, key2) -> key2));
        itemList.forEach(e -> {
            Integer subType = (Integer)itemSubTypeMaps.get(e.getItemId());
            e.setSubType(subType);
        });
    }

    private void validOrderUpdateParams(AfterSalesUpdateExtReqDto reqDto) {
        if (StringUtils.isEmpty((CharSequence)reqDto.getOrderNo())) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqDto.getItemList())) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u552e\u540e\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList inValidItem = Lists.newArrayList();
        for (AfterSalesApplyItemReqDto applyItemReqDto : reqDto.getItemList()) {
            if (applyItemReqDto.getNum() <= applyItemReqDto.getItemNum()) continue;
            inValidItem.add(applyItemReqDto.getItemName());
        }
        if (CollectionUtils.isNotEmpty((Collection)inValidItem)) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u5546\u54c1[" + StringUtils.join((Iterable)inValidItem, (String)",") + "]\u7533\u8bf7\u552e\u540e\u6570\u91cf\u5927\u4e8e\u8d2d\u4e70\u6570");
        }
    }

    private void validateManualUpdateParams(AfterSalesUpdateExtReqDto reqDto) {
        BigDecimal itemQty;
        if (CollectionUtils.isEmpty((Collection)reqDto.getItemList()) && CollectionUtils.isEmpty((Collection)reqDto.getAttachmentList())) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u552e\u540e\u5546\u54c1\u6e05\u5355\u6216\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqDto.getSellerId() == null || reqDto.getShopId() == null) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u8bf7\u9009\u62e9\u5e97\u94fa");
        }
        Long applyQty = reqDto.getApplyReturnQty();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemList()) && (itemQty = reqDto.getItemList().stream().filter(e -> e.getNum() != null && e.getNum() > 0).map(e -> BigDecimal.valueOf(e.getNum().intValue())).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.valueOf(applyQty)) != 0) {
            throw new BizException(TradeModuleExcpCode.INVALID_PARAM.getCode(), "\u7533\u8bf7\u6570\u91cf\u548c\u5b9e\u9645\u5546\u54c1\u603b\u6570\u4e0d\u4e00\u81f4");
        }
    }

    private AfterSalesItemReqDto buildSupplierAfterSalesItem(AfterSalesApplyItemReqDto itemAppDto, String createMode) {
        AfterSalesItemReqDto afterSalesItemReqDto = new AfterSalesItemReqDto();
        if (ReturnOrderCreateModeEnum.FROM_MANUAL_SKU.getType().equals(createMode)) {
            itemAppDto.setReturnedNum(Integer.valueOf(0));
        }
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        extFields.put("returnedNum", itemAppDto.getReturnedNum());
        extFields.put("returnNum", itemAppDto.getNum());
        extFields.put("originNum", itemAppDto.getThisStorageNum());
        extFields.put("unit", itemAppDto.getUnit());
        extFields.put("itemAmount", itemAppDto.getItemPrice());
        extFields.put("remark", itemAppDto.getRemark());
        extFields.put("itemName", itemAppDto.getItemName());
        extFields.put("brandId", itemAppDto.getBrandId());
        extFields.put("skuCode", itemAppDto.getSkuCode());
        extFields.put("skuDesc", itemAppDto.getSkuDesc());
        extFields.put("cargoSerial", itemAppDto.getCargoSerial());
        extFields.put("refundAmount", BigDecimal.valueOf(itemAppDto.getNum().intValue()).multiply(itemAppDto.getItemPrice()) + "");
        afterSalesItemReqDto.setItemPrice(itemAppDto.getItemPrice());
        afterSalesItemReqDto.setId(itemAppDto.getId());
        afterSalesItemReqDto.setTradeItemNo(itemAppDto.getTradeItemNo());
        afterSalesItemReqDto.setExtFields(extFields);
        afterSalesItemReqDto.setSkuSerial(Objects.nonNull(itemAppDto.getSkuId()) ? itemAppDto.getSkuId().toString() : itemAppDto.getSkuSerial());
        afterSalesItemReqDto.setItemCode(itemAppDto.getItemCode());
        afterSalesItemReqDto.setGift(itemAppDto.getGift());
        OrderItemExtDto orderItemExtDto = new OrderItemExtDto();
        orderItemExtDto.setImgPath(StringUtils.isNotEmpty((CharSequence)itemAppDto.getPath()) ? itemAppDto.getPath() : itemAppDto.getImgPath());
        orderItemExtDto.setShelfType(itemAppDto.getShelfType());
        orderItemExtDto.setSubType(itemAppDto.getSubType());
        afterSalesItemReqDto.setExtension(JSONObject.toJSONString((Object)orderItemExtDto));
        afterSalesItemReqDto.setItemSerial(Objects.nonNull(itemAppDto.getItemId()) ? itemAppDto.getItemId().toString() : null);
        afterSalesItemReqDto.setTradeItemId(itemAppDto.getTradeItemId());
        if (CollectionUtils.isNotEmpty((Collection)itemAppDto.getApplyBatchNo())) {
            StringBuilder sb = new StringBuilder(50);
            for (ApplyReturnItemBatchDto applyReturnItemBatchDto : itemAppDto.getApplyBatchNo()) {
                sb.append(applyReturnItemBatchDto.getBatchNo()).append("#").append(applyReturnItemBatchDto.getNum()).append(",");
            }
            String batchNo = sb.substring(0, sb.length() - 1);
            afterSalesItemReqDto.setBatchNo(batchNo);
        }
        return afterSalesItemReqDto;
    }

    public void auditOrder(OrderAuditToBReqDto orderAuditToBReqDto) {
        this.orderService.limitOrderAudit(orderAuditToBReqDto, null);
        ReturnAuditReqDto returnAuditReqDto = new ReturnAuditReqDto();
        returnAuditReqDto.setAuditDesc(orderAuditToBReqDto.getAuditDesc());
        returnAuditReqDto.setAuditor(this.context.userName());
        returnAuditReqDto.setAuditStatus(1 == orderAuditToBReqDto.getAuditResult() ? "pass" : "reject");
        returnAuditReqDto.setAuditTime(new Date());
        returnAuditReqDto.setAuditType(orderAuditToBReqDto.getAuditType() + "");
        returnAuditReqDto.setReturnNo(orderAuditToBReqDto.getReturnNo());
        RestResponse stringRestResponse = this.afterSalesTobApi.auditReturnRefactor(orderAuditToBReqDto.getReturnNo(), returnAuditReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
        logger.info("auditOrder:auditReturnRefactor\u5ba1\u6838\u5b8c\u6210");
        OptLogReqDto optLogDto = new OptLogReqDto();
        optLogDto.setBizType(OptBizTypeEnum.RETURN.getType());
        optLogDto.setBizNo(returnAuditReqDto.getReturnNo());
        optLogDto.setOptTime(new Date());
        optLogDto.setOptPerson(this.context.userName());
        optLogDto.setOptType(OptTypeEnum.RETURN_AUDIT.getType());
        StringBuilder description = new StringBuilder();
        if ("3".equals(returnAuditReqDto.getAuditType())) {
            if ("reject".equals(returnAuditReqDto.getAuditStatus())) {
                description.append("\u552e\u540e\u7533\u8bf7\u5ba1\u6838\u4e0d\u901a\u8fc7");
                description.append("\uff0c\u539f\u56e0\uff1a");
                description.append(returnAuditReqDto.getAuditDesc());
            } else {
                description.append("\u552e\u540e\u7533\u8bf7\u5ba1\u6838\u901a\u8fc7");
            }
        }
        optLogDto.setDescription(description.toString());
        RestResponse response = this.optLogApi.addBoOptLog(optLogDto);
        RestResponseHelper.extractData((RestResponse)response);
        logger.info("auditOrder:optLogApi\u65e5\u5fd7\u4fdd\u5b58");
        if ("pass".equals(returnAuditReqDto.getAuditStatus())) {
            this.orderInformMqService.sendReciptInform(orderAuditToBReqDto.getReturnNo());
        } else {
            this.orderInformMqService.subTenantrejectRetrun(orderAuditToBReqDto);
        }
        logger.info("auditOrder:mq\u5ba1\u6838\u5b8c\u6210");
        this.orderService.limitOrderAudit(orderAuditToBReqDto, this.CACHE_SET);
    }

    private void sendOrderAfterSalesMessageToTcbj(String returnNo) {
        TcbjMessageVo tcbjMessageVo = new TcbjMessageVo();
        HashMap map = Maps.newHashMap();
        map.put("no", returnNo);
        tcbjMessageVo.setContent(JSON.toJSONString((Object)map));
        tcbjMessageVo.setMethod(this.tcbjMessageCommonConfig.getMethod());
        tcbjMessageVo.setOrigin(this.tcbjMessageCommonConfig.isOrigin());
        tcbjMessageVo.setSrcSystem(this.tcbjMessageCommonConfig.getSrcSystem());
        tcbjMessageVo.setMessageKey(this.tcbjMessageCommonConfig.getMessageKey());
        this.commonsMqService.sendSingleMessage(this.ORDER_AFTER_SALES_TO_TCBJ_TOPIC, this.ORDER_AFTER_SALES_TO_TCBJ_TAG, (Object)tcbjMessageVo);
    }

    public void finReviewOrder(FinReviewToBReqDto finReviewToBReqDto) {
        finReviewToBReqDto.setAuditor(this.context.userName());
        RestResponse returnDetailRespDtoRestResponse = this.afterSalesQueryApi.queryReturnDetail(finReviewToBReqDto.getReturnNo(), "{}");
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)returnDetailRespDtoRestResponse);
        BigDecimal refundTotalAmount = this.calcRefundTotalAmount(finReviewToBReqDto.getReturnNo());
        finReviewToBReqDto.setRefundTotalAmount(refundTotalAmount);
        finReviewToBReqDto.setPayMethod(PayMethodEnum.REBATE_ACCOUNT.getCode());
        RefundTobReqDto refundTobReqDto = new RefundTobReqDto();
        refundTobReqDto.setRefundPerson(this.context.userName());
        refundTobReqDto.setReturnNo(finReviewToBReqDto.getReturnNo());
        refundTobReqDto.setRefundTotalAmount(refundTotalAmount);
        ArrayList refundDetailList = Lists.newArrayList();
        RefundDetailTobReqDto refundDetailReqDto = new RefundDetailTobReqDto();
        refundDetailReqDto.setRefundAmount(refundTotalAmount);
        refundDetailReqDto.setPayMethod(PayMethodEnum.REBATE_ACCOUNT.getCode());
        refundDetailList.add(refundDetailReqDto);
        refundTobReqDto.setRefundDetails((List)refundDetailList);
        finReviewToBReqDto.setRefundTobReqDto(refundTobReqDto);
        RestResponse stringRestResponse = this.afterSalesTobApi.finReviewOrder(finReviewToBReqDto.getReturnNo(), finReviewToBReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
    }

    private BigDecimal calcRefundTotalAmount(String returnNo) {
        BigDecimal refundTotalAmt = BigDecimal.ZERO;
        RestResponse restResponse = this.refundDisposeConfigQueryApi.queryByNo(returnNo);
        RefundDisposeConfigRespDto returnDetailRespDto = (RefundDisposeConfigRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        BigDecimal realRefoundAmt = returnDetailRespDto.getRealRefundAmount() == null ? BigDecimal.ZERO : returnDetailRespDto.getRealRefundAmount();
        return realRefoundAmt;
    }

    public void rejectAuditOrder(OrderAuditToBReqDto orderAuditToBReqDto) {
        this.orderService.limitOrderAudit(orderAuditToBReqDto, null);
        ReturnAuditReqDto returnAuditReqDto = new ReturnAuditReqDto();
        returnAuditReqDto.setAuditDesc(orderAuditToBReqDto.getAuditDesc());
        returnAuditReqDto.setAuditor(this.context.userName());
        returnAuditReqDto.setAuditStatus("reject");
        returnAuditReqDto.setAuditTime(new Date());
        returnAuditReqDto.setAuditType(orderAuditToBReqDto.getAuditType() + "");
        returnAuditReqDto.setReturnNo(orderAuditToBReqDto.getReturnNo());
        ReturnDetailRespDto returnDetailRespDto = (ReturnDetailRespDto)RestResponseHelper.extractData((RestResponse)this.afterSalesQueryApi.queryReturnDetail(orderAuditToBReqDto.getReturnNo(), "{}"));
        Assert.isTrue((returnDetailRespDto != null ? 1 : 0) != 0, (String)"10900", (String)"\u9000\u8d27\u5355\u4e0d\u5b58\u5728");
        if (this.checkImarketingCloud) {
            this.iinventoryService.checkAllowReject(Integer.valueOf(2), orderAuditToBReqDto.getReturnNo(), returnDetailRespDto.getOrganizationId());
        }
        RestResponse stringRestResponse = this.afterSalesTobApi.rejectAuditOrder(orderAuditToBReqDto.getReturnNo(), returnAuditReqDto);
        RestResponseHelper.extractData((RestResponse)stringRestResponse);
        this.orderService.limitOrderAudit(orderAuditToBReqDto, this.CACHE_SET);
    }

    @Deprecated
    public PageInfo<OrderListRespDto> getCustomerOrderPage(OrderListQueryReqDto orderListQueryReqDto, Integer pageNum, Integer pageSize) {
        OrderQueryReqDto reqParm = new OrderQueryReqDto();
        ArrayList sqlFilterList = Lists.newArrayList();
        reqParm.setInstanceId(this.context.instanceId());
        reqParm.setTenantId(this.context.tenantId());
        Long userId = this.context.userId();
        Long sellerId = orderListQueryReqDto.getSellerId();
        Long shopId = orderListQueryReqDto.getShopId();
        org.springframework.util.Assert.notNull((Object)sellerId, (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5e97\u94fa");
        org.springframework.util.Assert.notNull((Object)shopId, (String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5e97\u94fa");
        Long custId = this.commonService.getCustomerIdByUserIdAndSellerId(userId, sellerId);
        reqParm.setCustomerId(String.valueOf(custId));
        reqParm.setShopId(String.valueOf(shopId));
        reqParm.setOrderTradeStatus(OrderTradeStatusEnum.CONFIRM.getCode());
        reqParm.setPlaceStartTime(orderListQueryReqDto.getPlaceTimeUp());
        reqParm.setPayEndTime(orderListQueryReqDto.getPlaceTimeEnd());
        reqParm.setSqlFilterList((List)sqlFilterList);
        RestResponse restResponse = this.orderBizQueryApi.queryByPage(JSON.toJSONString((Object)reqParm), pageNum, pageSize);
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)restResponse);
        List orderBizDtoList = ((PageInfo)restResponse.getData()).getList();
        ArrayList<OrderListRespDto> resultList = new ArrayList<OrderListRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)orderBizDtoList)) {
            List<String> orderNoList = orderBizDtoList.stream().map(OrderRespDto::getOrderNo).collect(Collectors.toList());
            PageInfo<OrderDeliveryRespDto> deliveryPageInfo = this.queryDeliveryPageInfo(orderNoList, DeliveryStatusToBEnum.WAIT_DELIVERY.getCode());
            Map<Object, Object> deliveredMap = new HashMap();
            Map<Object, Object> signedMap = new HashMap();
            if (Objects.nonNull(deliveryPageInfo) && CollectionUtils.isNotEmpty((Collection)deliveryPageInfo.getList())) {
                deliveredMap = deliveryPageInfo.getList().stream().filter(dto -> DeliveryStatusToBEnum.DELIVERED.getCode().equals(dto.getDeliveryStatus())).collect(Collectors.groupingBy(OrderDeliveryRespDto::getOrderNo));
                signedMap = deliveryPageInfo.getList().stream().filter(dto -> DeliveryStatusToBEnum.SIGNED.getCode().equals(dto.getDeliveryStatus())).collect(Collectors.groupingBy(OrderDeliveryRespDto::getOrderNo));
            }
            OrderListRespDto resultDto = null;
            for (OrderBizRespDto orderBizDto : orderBizDtoList) {
                resultDto = new OrderListRespDto();
                Map extFields = orderBizDto.getExtFields();
                String placeType = extFields.get("placeType") + "";
                String customerId = extFields.get("customerId") + "";
                if (PlaceTypeEnum.CUSTOMER.getCode().toString().equals(placeType)) {
                    resultDto.setValetFlag(TradeConstant.NO);
                } else {
                    resultDto.setValetFlag(TradeConstant.YES);
                }
                resultDto.setCustomerId(Long.valueOf(customerId));
                resultDto.setId(orderBizDto.getId());
                resultDto.setOrderNo(orderBizDto.getOrderNo());
                resultDto.setPlaceTime(orderBizDto.getPlaceTime());
                resultDto.setShopId(StringUtils.isNotBlank((CharSequence)orderBizDto.getShopId()) ? Long.valueOf(orderBizDto.getShopId()) : null);
                if (OrderTradeStatusEnum.WAIT_OUT_STORAGE.getCode().equals(orderBizDto.getOrderTradeStatus()) || OrderTradeStatusEnum.PART_OUT_STORAGE.getCode().equals(orderBizDto.getOrderTradeStatus()) || OrderTradeStatusEnum.ALL_OUT_STORAGE.getCode().equals(orderBizDto.getOrderTradeStatus()) || OrderTradeStatusEnum.PART_DELIVERY.getCode().equals(orderBizDto.getOrderTradeStatus()) || OrderTradeStatusEnum.ALL_DELIVERY.getCode().equals(orderBizDto.getOrderTradeStatus()) || OrderTradeStatusEnum.PART_CONFIRM.getCode().equals(orderBizDto.getOrderTradeStatus())) {
                    resultDto.setOrderTradeStatus(OrderTradeStatusEnum.WAIT_RECEIVE.getCode());
                    resultDto.setOrderTradeStatusName(OrderTradeStatusEnum.WAIT_RECEIVE.getName());
                } else {
                    resultDto.setOrderTradeStatus(orderBizDto.getOrderTradeStatus());
                    resultDto.setOrderTradeStatusName(OrderTradeStatusEnum.toName((String)orderBizDto.getOrderTradeStatus()));
                }
                resultDto.setPayStatus(orderBizDto.getExtFields().get("payStatus") + "");
                resultDto.setPayStatusName(PayStatusEnum.toName((String)(orderBizDto.getExtFields().get("payStatus") + "")));
                resultDto.setBizType(orderBizDto.getBizType());
                if (StringUtils.isNotEmpty((CharSequence)orderBizDto.getExtension())) {
                    resultDto.setSettlementInfo((SettlementInfoRespDto)JSON.parseObject((String)orderBizDto.getExtension(), SettlementInfoRespDto.class));
                }
                if (StringUtils.isNotBlank((CharSequence)orderBizDto.getDeliveryAddress())) {
                    JSONObject jsonObject = JSONObject.parseObject((String)orderBizDto.getDeliveryAddress());
                    resultDto.setContactPerson(jsonObject.getString("deliveryName"));
                    resultDto.setDetailAddr(StringUtils.isNotBlank((CharSequence)jsonObject.getString("address")) ? jsonObject.getString("address") : jsonObject.getString("provinceName") + jsonObject.getString("cityName") + jsonObject.getString("areaName") + jsonObject.getString("detailed"));
                    resultDto.setPhone(jsonObject.getString("deliveryMobile"));
                }
                resultDto.setFreightAmount(orderBizDto.getFreightAmount());
                if (CollectionUtils.isNotEmpty((Collection)orderBizDto.getOrderItems())) {
                    BigDecimal itemOrigAmount = BigDecimal.ZERO;
                    ItemRespDto itemDto = null;
                    ArrayList<ItemRespDto> itemList = new ArrayList<ItemRespDto>();
                    ArrayList<ItemRespDto> giftItems = new ArrayList<ItemRespDto>();
                    Integer totalItemNum = 0;
                    for (TradeItemRespDto tradeItemDto : orderBizDto.getOrderItems()) {
                        itemDto = new ItemRespDto();
                        itemDto.setItemId(Long.valueOf(tradeItemDto.getItemSerial()));
                        itemDto.setShopId(tradeItemDto.getShopId());
                        this.parseExtInfo(itemDto, tradeItemDto);
                        itemDto.setItemName(tradeItemDto.getItemName());
                        itemDto.setSkuName(tradeItemDto.getSkuDesc());
                        itemDto.setItemNum(tradeItemDto.getItemNum());
                        itemDto.setItemOrigPrice(tradeItemDto.getItemOrigPrice());
                        itemDto.setItemPrice(tradeItemDto.getItemPrice());
                        itemDto.setGift(tradeItemDto.getGift());
                        itemDto.setItemOrigPrice(tradeItemDto.getItemOrigPrice());
                        itemDto.setPayAmount(tradeItemDto.getPayTotalAmount());
                        itemDto.setItemType(tradeItemDto.getItemType());
                        totalItemNum = totalItemNum + tradeItemDto.getItemNum();
                        if (itemDto.getGift() == 1) {
                            giftItems.add(itemDto);
                            continue;
                        }
                        itemList.add(itemDto);
                        itemOrigAmount = itemOrigAmount.add(tradeItemDto.getItemOrigPrice().multiply(new BigDecimal(tradeItemDto.getItemNum())));
                    }
                    resultDto.setItemList(itemList);
                    resultDto.setGiftItems(giftItems);
                    resultDto.setItemType(orderBizDto.getItemType());
                    resultDto.setItemOrigAmount(itemOrigAmount);
                    resultDto.setTotalAmount(itemOrigAmount.add(orderBizDto.getFreightAmount()));
                    resultDto.setPayAmount(orderBizDto.getPayAmount());
                    resultDto.setTotalIntegral(Long.valueOf(orderBizDto.getIntegral().intValue()));
                    resultDto.setTotalItemNum(totalItemNum);
                }
                resultList.add(resultDto);
            }
        }
        pageInfo.setList(resultList);
        return pageInfo;
    }

    private PageInfo<OrderDeliveryRespDto> queryDeliveryPageInfo(List<String> orderNoList, String code) {
        JSONObject json = new JSONObject();
        json.put("instanceId", (Object)this.context.instanceId());
        json.put("tenantId", (Object)this.context.tenantId());
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"orderNo", orderNoList));
        sqlFilters.add(SqlFilter.ne((String)"deliveryStatus", (Object)code));
        json.put("sqlFilters", (Object)sqlFilters);
        RestResponse restResp = this.orderDeliveryApi.queryByPage(json.toJSONString(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo deliveryPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)restResp);
        return deliveryPageInfo;
    }

    private void parseExtInfo(ItemRespDto itemRespDto, TradeItemRespDto tradeItem) {
        if (StringUtils.isNotBlank((CharSequence)tradeItem.getExtension())) {
            OrderItemExtDto jsonObject = (OrderItemExtDto)JSONObject.parseObject((String)tradeItem.getExtension(), OrderItemExtDto.class);
            itemRespDto.setPath(jsonObject.getImgPath());
            itemRespDto.setShelfType(jsonObject.getShelfType());
        }
    }
}

