/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.trade.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.tob.ReturnCountTobRespDto;
import com.dtyunxi.yundt.module.trade.api.IOrderAfterSales;
import com.dtyunxi.yundt.module.trade.api.dto.AfterSalesItemsDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.AfterSalesUpdateReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.CancelAfterSalesReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnLogisticsAddReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderPageSearchReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.request.order.ReturnOrderSaveReqDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReFundOrderDetailRespDto;
import com.dtyunxi.yundt.module.trade.api.dto.response.order.ReturnOrderRespDto;
import com.dtyunxi.yundt.module.trade.api.enums.PlaceTypeEnum;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea4\u6613\u7ec4\u4ef6\uff1a\u552e\u540e\u670d\u52a1"})
@RestController
@RequestMapping(value={"/v1/trade/after-sales"})
public class AfterSalesRest {
    @Resource
    private IOrderAfterSales afterSales;

    @GetMapping(value={"/wait-service/list"})
    @ApiOperation(value="\u67e5\u8be2\u5f85\u552e\u540e\u6e05\u5355\u5bf9\u8c61")
    @ApiImplicitParams(value={@ApiImplicitParam(name="deliveryNo", paramType="query", dataType="String", value="\u53d1\u8d27\u5355\u53f7"), @ApiImplicitParam(name="srcType", dataType="Int", paramType="query", value="\u6765\u6e90\u7c7b\u578b\uff081:\u7ecf\u9500\u5546\u5c0f\u7a0b\u5e8f\u7aef\uff0c2:PC\u7ba1\u7406\u7aef\uff0c3:\u4e1a\u52a1\u5458\u5c0f\u7a0b\u5e8f\u7aef\uff09"), @ApiImplicitParam(name="customerId", dataType="Long", paramType="query", value="\u5ba2\u6237ID")})
    public RestResponse<AfterSalesItemsDto> getWaitServiceList(@RequestParam(name="deliveryNo", required=false) String deliveryNo, @RequestParam(value="srcType", required=false) Integer srcType, @RequestParam(value="customerId", required=false) Long customerId) {
        Integer refundType = PlaceTypeEnum.CUSTOMER.getCode();
        if (PlaceTypeEnum.SALESMAN.getCode().equals(srcType)) {
            refundType = srcType;
        }
        return new RestResponse((Object)this.afterSales.getWaitServiceListWithGift(deliveryNo, refundType, customerId));
    }

    @RequestMapping(value={"/add"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u552e\u540e\u5355", notes="\u65b0\u589e\u552e\u540e\u5355\uff1a\u9488\u5bf9\u5df2\u6536\u8d27\u7684\u53d1\u8d27\u5355\uff0c\u53ef\u652f\u6301\u552e\u540e\u5355")
    RestResponse<Void> add(@Valid @RequestBody ReturnOrderSaveReqDto reqDto) {
        this.afterSales.addAfterSales(reqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u552e\u540e\u5355", notes="\u5206\u9875\u67e5\u8be2\u552e\u540e\u5355")
    public RestResponse<PageInfo<ReturnOrderRespDto>> queryAfterSalesByPage(@Valid ReturnOrderPageSearchReqDto addressQueryReqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        PageInfo pageInfo = this.afterSales.queryAfterSalesByPage(addressQueryReqDto, pageNum, pageSize);
        return new RestResponse((Object)pageInfo);
    }

    @GetMapping(value={"/{returnNo}"})
    @ApiOperation(value="\u552e\u540e\u5355\u8be6\u60c5", notes="\u6839\u636e[returnNo]\u67e5\u8be2\u552e\u540e\u5355\u8be6\u60c5")
    RestResponse<ReFundOrderDetailRespDto> getAfterSalesDetail(@PathVariable(value="returnNo") @NotNull String returnNo) {
        ReFundOrderDetailRespDto detailRespDto = this.afterSales.getAfterSalesDetail(returnNo);
        return new RestResponse((Object)detailRespDto);
    }

    @RequestMapping(value={"/update"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ApiOperation(value="\u7f16\u8f91\u552e\u540e\u5355", notes="\u7f16\u8f91\u552e\u540e\u5355")
    RestResponse<Void> update(@Valid @RequestBody AfterSalesUpdateReqDto reqDto) {
        this.afterSales.updateAfterSales(reqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/cancel"})
    @ApiOperation(value="\u53d6\u6d88\u552e\u540e\u5355", notes="\u53d6\u6d88\u552e\u540e\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="CancelAfterSalesReqDto", value="\u53d6\u6d88\u552e\u540e\u5355", dataType="CancelAfterSalesReqDto", paramType="body", required=true)})
    public RestResponse<Void> cancelAfterSales(@Valid @RequestBody CancelAfterSalesReqDto reqDto) {
        this.afterSales.cancelAfterSales(reqDto);
        return RestResponse.VOID;
    }

    @RequestMapping(value={"/add-logistics"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="\u6dfb\u52a0\u7269\u6d41\u4fe1\u606f", notes="\u6dfb\u52a0\u7269\u6d41\u4fe1\u606f\uff1a\u9488\u5bf9\u552e\u540e\u5355")
    RestResponse<Void> addLogistics(@Valid @RequestBody ReturnLogisticsAddReqDto reqDto) {
        this.afterSales.addLogistics(reqDto);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/status/num"})
    @ApiOperation(value="\u67e5\u8be2\u552e\u540e\u5355\u72b6\u6001\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="srcType", dataType="Int", paramType="query", value="\u6765\u6e90\u7c7b\u578b\uff081:\u7ecf\u9500\u5546\u5c0f\u7a0b\u5e8f\u7aef\uff0c2:PC\u7ba1\u7406\u7aef\uff0c3:\u4e1a\u52a1\u5458\u5c0f\u7a0b\u5e8f\u7aef\uff09")})
    public RestResponse<ReturnCountTobRespDto> queryAfterSalesCount(@RequestParam(value="srcType", required=false) Integer srcType) {
        return new RestResponse((Object)this.afterSales.queryAfterSalesCount(srcType));
    }
}

