/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.module.biz.impl;

import com.dtyunxi.cube.starter.extension.BizIdContext;
import com.dtyunxi.cube.starter.extension.reader.ConfReader;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.module.bo.ConfigGroup;
import com.dtyunxi.module.bo.ConfigItem;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.request.ConfigQueryReq;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizExtImplQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.BizParamQueryResp;
import com.dtyunxi.yundt.cube.center.data.api.query.IBizConfQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;

public abstract class AbstractMpcConfigImpl
implements IConfig {
    static final Logger logger = LoggerFactory.getLogger(AbstractMpcConfigImpl.class);
    IContext context;
    @Resource
    ConfReader confReader;
    @Resource
    private IBizConfQueryApi bizConfQueryApi;

    public AbstractMpcConfigImpl(IContext context) {
        this.context = context;
    }

    public List<ConfigGroup> groups() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<ConfigGroup> groupsWithConstrains() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void modifyGroups(List<ConfigGroup> groups) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<ConfigItem> fetchConfigItems(String groupName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ConfigItem fetchOne(String groupName, String key) {
        BizIdContext bizIdContext = this.assembleBizIdContext();
        ConfigQueryReq queryReq = new ConfigQueryReq();
        queryReq.setBizIdContext(bizIdContext);
        queryReq.setCode(key);
        BizParamQueryResp bizParamQueryResp = (BizParamQueryResp)this.bizConfQueryApi.queryRuntimeValueByCode(queryReq).getData();
        ConfigItem configItem = null;
        if (null != bizParamQueryResp) {
            configItem = new ConfigItem();
            configItem.setKey(key);
            if (CollectionUtils.isNotEmpty((Collection)bizParamQueryResp.getSpaceValues())) {
                configItem.setValue((String)bizParamQueryResp.getSpaceValues().get(0));
            } else {
                configItem.setValue(bizParamQueryResp.getValue());
            }
        }
        return configItem;
    }

    public <T> T fetchOneExtension(Class<T> clazz) {
        BizIdContext bizIdContext = this.assembleBizIdContext();
        ConfigQueryReq queryReq = new ConfigQueryReq();
        queryReq.setBizIdContext(bizIdContext);
        queryReq.setCode(clazz.getCanonicalName());
        BizExtImplQueryResp bizExtImpl = (BizExtImplQueryResp)this.bizConfQueryApi.queryRuntimeImplByCode(queryReq).getData();
        T result = null;
        if (null != bizExtImpl && CollectionUtils.isNotEmpty((Collection)bizExtImpl.getValue())) {
            String implClass = (String)bizExtImpl.getValue().get(0);
            Map beans = SpringBeanUtil.getApplicationContext().getBeansOfType(clazz);
            for (Object value : beans.values()) {
                if (!AopProxyUtils.ultimateTargetClass(value).getCanonicalName().equals(implClass)) continue;
                result = (T)value;
                break;
            }
            if (result == null) {
                logger.warn("applicationContext\u6839\u636e\u7c7b\u578b{}\u627e\u4e0d\u5230\u5b9e\u73b0Bean[{}]", clazz, (Object)implClass);
            }
        }
        return result;
    }

    public <T> List<T> fetchListExtension(Class<T> clazz) {
        BizIdContext bizIdContext = this.assembleBizIdContext();
        ConfigQueryReq queryReq = new ConfigQueryReq();
        queryReq.setBizIdContext(bizIdContext);
        queryReq.setCode(clazz.getCanonicalName());
        BizExtImplQueryResp bizExtImpl = (BizExtImplQueryResp)this.bizConfQueryApi.queryRuntimeImplByCode(queryReq).getData();
        ArrayList extImpls = Lists.newArrayList();
        if (null != bizExtImpl && CollectionUtils.isNotEmpty((Collection)bizExtImpl.getValue())) {
            Map beans = SpringBeanUtil.getApplicationContext().getBeansOfType(clazz);
            Iterator iterator = beans.values().iterator();
            block0: for (String implClass : bizExtImpl.getValue()) {
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    if (!AopProxyUtils.ultimateTargetClass(value).getCanonicalName().equals(implClass)) continue;
                    extImpls.add(value);
                    continue block0;
                }
            }
        }
        return extImpls;
    }

    public void modifyConfigItems(String groupName, List<ConfigItem> items) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void saveGroups(List<ConfigGroup> groups) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void saveGroup(ConfigGroup configGroup) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private BizIdContext assembleBizIdContext() {
        BizIdContext bizIdContext = new BizIdContext();
        bizIdContext.setReqInstanceId(this.context.instanceId());
        bizIdContext.setReqTenantId(this.context.tenantId());
        return bizIdContext;
    }
}

