/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.module.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.module.api.IConfig;
import com.dtyunxi.module.bo.ConfigItem;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.dtyunxi.yundt.module.domain.constant.UserConstant;
import com.dtyunxi.yundt.module.item.api.constants.ItemConstant;
import com.dtyunxi.yundt.module.item.api.enums.ItemModuleExceptionCode;
import com.dtyunxi.yundt.module.item.biz.extension.itempublishchannel.IItemPublishChannel;
import com.dtyunxi.yundt.module.item.biz.extension.itempublishchannel.ItemPublishH5Channel;
import com.dtyunxi.yundt.module.item.biz.service.IItemCommonService;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemCommonServiceImpl
implements IItemCommonService {
    private static final Logger logger = LoggerFactory.getLogger(ItemCommonServiceImpl.class);
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource(name="yundt.module.item")
    private IConfig config;

    @Override
    public Long getSellerId() {
        SellerQueryReqDto reqExam = new SellerQueryReqDto();
        SellerRespDto result = null;
        Integer roleType = this.getRoleType();
        Long userId = this.context.userId();
        if (UserConstant.OPERATOR.equals(roleType)) {
            reqExam.setGroupId(ItemConstant.SELF_MERCHANT_FLAG);
        } else if (UserConstant.MERCHANT.equals(roleType)) {
            reqExam.setOwnerId(userId);
        }
        reqExam.setInstanceId(this.context.instanceId());
        RestResponse restResponse = this.sellerQueryApi.queryList(reqExam);
        logger.debug("\u67e5\u8be2\u7ed3\u679c\u4e3a\uff0c{}", (Object)JSON.toJSONString((Object)restResponse));
        List list = (List)restResponse.getData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = (SellerRespDto)list.get(0);
        } else {
            UserDto userDto = (UserDto)this.userQueryApi.queryById(userId, null).getData();
            if (userDto != null && StringUtils.isNotBlank((String)userDto.getExtension())) {
                result = (SellerRespDto)this.sellerQueryApi.queryById(Long.valueOf(userDto.getExtension())).getData();
            }
        }
        if (result == null) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.SELLER_NOT_EXIST);
        }
        logger.info("\u5f53\u524d\u7528\u6237sellerId:{}", (Object)result.getId());
        return result.getId();
    }

    @Override
    @Nullable
    public Long getSellerIdNoEx() {
        SellerQueryReqDto reqExam = new SellerQueryReqDto();
        SellerRespDto seller = null;
        Integer roleType = this.getRoleType();
        Long userId = this.context.userId();
        if (UserConstant.OPERATOR.equals(roleType)) {
            reqExam.setGroupId(ItemConstant.SELF_MERCHANT_FLAG);
        } else if (UserConstant.MERCHANT.equals(roleType)) {
            reqExam.setOwnerId(userId);
        }
        reqExam.setInstanceId(this.context.instanceId());
        List list = (List)this.sellerQueryApi.queryList(reqExam).getData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            seller = (SellerRespDto)list.get(0);
        } else {
            UserDto userDto = (UserDto)this.userQueryApi.queryById(userId, null).getData();
            if (userDto != null && StringUtils.isNotBlank((String)userDto.getExtension())) {
                seller = (SellerRespDto)this.sellerQueryApi.queryById(Long.valueOf(userDto.getExtension())).getData();
            }
        }
        if (null == seller) {
            logger.info("\u6839\u636e\u5f53\u524d\u7528\u6237\u67e5\u8be2\u4e0d\u5230\u5546\u6237\u4fe1\u606f, userId={}", (Object)userId);
            return null;
        }
        logger.info("\u5f53\u524d\u7528\u6237sellerId:{}", (Object)seller.getId());
        return seller.getId();
    }

    @Override
    public Integer getRoleType() {
        Integer roleType = UserConstant.CONSUME;
        String[] res = new String[]{"role"};
        Long userId = this.context.userId();
        UserVo userVo = (UserVo)this.userQueryApi.queryByIdAndResource(userId, res, "{}").getData();
        if (null == userVo || CollectionUtils.isEmpty((Collection)userVo.getRoleSet())) {
            return roleType;
        }
        for (RoleDto roleDto : userVo.getRoleSet()) {
            if ("platMgmt".equals(roleDto.getCode()) || "platMgmtChild".equals(roleDto.getCode())) {
                roleType = UserConstant.OPERATOR;
                break;
            }
            if (!"merchant".equals(roleDto.getCode()) && !"merchantChild".equals(roleDto.getCode())) continue;
            roleType = UserConstant.MERCHANT;
            break;
        }
        logger.info("\u5f53\u524d\u7528\u6237roleType:{}", (Object)roleType);
        return roleType;
    }

    @Override
    public Boolean needAudit() {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne(this.config.nameSpace(), "com.dtyunxi.yundt.item.itemAuditReqDto");
        }
        catch (Exception e) {
            logger.error("needAudit.error...", (Throwable)e);
        }
        if (null == configItem || null == configItem.getValue()) {
            logger.info("\u3010\u5546\u54c1\u53d1\u5e03\u662f\u5426\u9700\u8981\u5ba1\u6838\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba4true\u3011");
            configItem = new ConfigItem();
            configItem.setValue("true");
        }
        return Boolean.valueOf(configItem.getValue());
    }

    @Override
    public IItemPublishChannel getItemPublishChannel(String publishChannel) {
        List iItemPublishChannelList = null;
        try {
            iItemPublishChannelList = this.config.fetchListExtension(IItemPublishChannel.class);
        }
        catch (Exception e2) {
            logger.error("getItemPublishChannel.error...", (Throwable)e2);
        }
        if (CollectionUtils.isNotEmpty((Collection)iItemPublishChannelList)) {
            return iItemPublishChannelList.stream().filter(e -> e.getPublishChannelCode().equals(publishChannel)).findFirst().orElse(null);
        }
        return new ItemPublishH5Channel();
    }

    @Override
    public Integer getDirMaxLevel(String key) {
        ConfigItem configItem = null;
        try {
            configItem = this.config.fetchOne("item", key);
        }
        catch (Exception e) {
            logger.error("getDirMaxLevel.error...", (Throwable)e);
        }
        if (null == configItem || configItem.getValue() == null) {
            logger.info("\u3010\u7c7b\u76ee\u6700\u5927\u5c42\u7ea7\u672a\u914d\u7f6e\uff0c\u9ed8\u8ba43\u7ea7\u3011");
            configItem = new ConfigItem();
            configItem.setValue("3");
        }
        return Integer.valueOf(configItem.getValue());
    }

    @Override
    public ShopDto getShopIdByContext() {
        Long sellerId = this.getSellerId();
        PageInfo pageInfo = (PageInfo)this.shopQueryApi.queryBySellerId(sellerId.longValue(), 1, 1).getData();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            BizExceptionHelper.throwBizException((IExceptionCode)ItemModuleExceptionCode.SELLER_NOT_EXIST);
        }
        return (ShopDto)pageInfo.getList().get(0);
    }
}

