/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils.poi;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ExcelWriteMapUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelWriteMapUtils.class);

    public static void write(OutputStream outputStream, String[] sheetNames, List<Map<String, Object>> ... dataList) {
        SXSSFWorkbook workbook = ExcelWriteMapUtils.createWorkBook();
        try {
            for (int i = 0; i < dataList.length; ++i) {
                String sheetName = ExcelWriteMapUtils.getSheetName(sheetNames, workbook, i);
                Sheet sheet = ExcelWriteMapUtils.createSheet((Workbook)workbook, sheetName, i);
                ExcelWriteMapUtils.createTableHead(sheet, dataList[i].get(0));
                List<Map<String, Object>> mapList = dataList[i];
                int writeRowIndex = 1;
                if (mapList == null || mapList.size() <= 0) continue;
                int pageSize = mapList.size() < 2000 ? mapList.size() : 2000;
                int size = mapList.size();
                int part = size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
                logger.info("\u5171\u6709 \uff1a{}\u6761\u6570\u636e\uff0c\u5206\u4e3a \uff1a{}\u6279", (Object)size, (Object)part);
                for (int j = 0; j < part; ++j) {
                    ArrayList<Map<String, Object>> listPage = new ArrayList();
                    if (j == part - 1) {
                        writeRowIndex = ExcelWriteMapUtils.write(sheet, mapList, writeRowIndex);
                        mapList.clear();
                        continue;
                    }
                    listPage = mapList.subList(0, pageSize);
                    writeRowIndex = ExcelWriteMapUtils.write(sheet, listPage, writeRowIndex);
                    mapList.subList(0, pageSize).clear();
                }
            }
            workbook.write(outputStream);
            outputStream.flush();
            logger.info("\u751f\u6210Excle\u6587\u4ef6\u6210\u529f~");
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excle\u6587\u4ef6\u65f6\u5f02\u5e38~", (Throwable)e);
            throw new RuntimeException("\u751f\u6210Excle\u6587\u4ef6\u65f6\u5f02\u5e38~", e);
        }
        finally {
            workbook.dispose();
        }
    }

    public static void write(OutputStream outputStream, List<Map<String, Object>> ... dataList) {
        ExcelWriteMapUtils.write(outputStream, null, dataList);
    }

    private static String getSheetName(String[] sheetNames, SXSSFWorkbook workbook, int i) {
        return sheetNames != null ? sheetNames[i] : null;
    }

    private static Sheet createSheet(Workbook workbook, String sheetName, Integer sheetIndex) {
        Sheet sheet = null;
        if (StringUtils.isEmpty((Object)sheetName)) {
            sheet = workbook.createSheet();
            workbook.setSheetOrder(sheet.getSheetName(), sheetIndex.intValue());
        } else {
            sheet = workbook.createSheet(sheetName);
            workbook.setSheetOrder(sheetName, sheetIndex.intValue());
        }
        return sheet;
    }

    private static int write(Sheet sheet, List<Map<String, Object>> listPage, int writeRowIndex) throws Exception {
        for (Map<String, Object> map : listPage) {
            Row row = sheet.createRow(writeRowIndex);
            int i = 0;
            for (Map.Entry<String, Object> m : map.entrySet()) {
                Cell cell = row.createCell(i);
                sheet.setColumnWidth(i, 3600);
                cell.setCellValue(StringUtils.isEmpty((Object)m.getValue()) ? "" : m.getValue().toString());
                ++i;
            }
            ++writeRowIndex;
        }
        return writeRowIndex;
    }

    private static SXSSFWorkbook createWorkBook() {
        return new SXSSFWorkbook(500);
    }

    private static void createTableHead(Sheet sheet, Map<String, Object> headerMap) {
        Row headRow = sheet.createRow(0);
        sheet.setColumnWidth(2, 5120);
        headRow.setHeightInPoints(20.0f);
        int i = 0;
        for (Map.Entry<String, Object> map : headerMap.entrySet()) {
            Cell cell = headRow.createCell(i);
            cell.setCellValue(map.getKey());
            ++i;
        }
    }
}

