/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.convert;

import com.dtyunxi.tcbj.api.dto.response.DeliveryInformationRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DeliveryInfoDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.TransferOrderDetailDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.TransferOrderDto;
import com.dtyunxi.util.ParamConverter;
import com.dtyunxi.yundt.cube.center.inventory.constant.ConsignmentConstant;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.Mapper;
import org.springframework.beans.BeanUtils;

@Mapper(componentModel="spring")
public interface TransferOrderConvert {
    default public TransferOrderDto convert(CsTransferOrderRespDto csTransferOrderRespDto, List<CsTransferOrderDetailRespDto> csTransferOrderDetailRespDtoList, List<DeliveryInformationRespDto> deliveryInformationRespDtos) {
        TransferOrderDto dto = new TransferOrderDto();
        BeanUtils.copyProperties((Object)csTransferOrderRespDto, (Object)dto);
        dto.setBussinessOrderNo(csTransferOrderRespDto.getTransferOrderNo());
        dto.setBussinessOrderType(csTransferOrderRespDto.getType());
        dto.setBussinessOrderStatus(csTransferOrderRespDto.getOrderStatus());
        dto.setInCargoRightName(csTransferOrderRespDto.getInOrganization());
        dto.setInCargoRightId(ParamConverter.convertToString((Object)csTransferOrderRespDto.getInOrganizationId()));
        dto.setOutCargoRightName(csTransferOrderRespDto.getOutOrganization());
        dto.setOutCargoRightId(ParamConverter.convertToString((Object)csTransferOrderRespDto.getOutOrganizationId()));
        dto.setInLogicalWarehouseCode(csTransferOrderRespDto.getInLogicWarehouseCode());
        dto.setInLogicalWarehouseName(csTransferOrderRespDto.getInLogicWarehouseName());
        dto.setOutLogicalWarehouseCode(csTransferOrderRespDto.getOutLogicWarehouseCode());
        dto.setOutLogicalWarehouseName(csTransferOrderRespDto.getOutLogicWarehouseName());
        dto.setExternalOrderNo(csTransferOrderRespDto.getPreOrderNo());
        dto.setAddress(Optional.ofNullable(csTransferOrderRespDto.getProvince()).orElse("") + Optional.ofNullable(csTransferOrderRespDto.getCity()).orElse("") + Optional.ofNullable(csTransferOrderRespDto.getArea()).orElse("") + Optional.ofNullable(csTransferOrderRespDto.getAddress()).orElse(""));
        dto.setOrderSrcName("OCS");
        if (StringUtils.isNotBlank((CharSequence)dto.getOrderSrc())) {
            if (StringUtils.equals((CharSequence)dto.getOrderSrc(), (CharSequence)"EAS")) {
                dto.setOrderSrcName("EAS");
            } else if (StringUtils.equals((CharSequence)dto.getOrderSrc(), (CharSequence)"PLAN")) {
                dto.setOrderSrcName("\u8c03\u62e8\u8ba1\u5212");
            }
        }
        List transferOrderDetailDtos = csTransferOrderDetailRespDtoList.stream().map(it -> {
            TransferOrderDetailDto transferOrderDetailDto = new TransferOrderDetailDto();
            BeanUtils.copyProperties((Object)it, (Object)transferOrderDetailDto);
            return transferOrderDetailDto;
        }).collect(Collectors.toList());
        List deliveryInfoDtos = deliveryInformationRespDtos.stream().map(o -> {
            DeliveryInfoDto deliveryInfoDto = new DeliveryInfoDto();
            BeanUtils.copyProperties((Object)o, (Object)deliveryInfoDto);
            if (o.getConsignmentType() != null) {
                deliveryInfoDto.setConsignmentTypeName((String)ConsignmentConstant.CONSIGNMENT_TYPE.valueMap.get(o.getConsignmentType()));
            }
            return deliveryInfoDto;
        }).collect(Collectors.toList());
        dto.setTransferOrderDetailDtoList(transferOrderDetailDtos);
        dto.setDeliveryInfoList(deliveryInfoDtos);
        return dto;
    }
}

