/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.payment.constant.enums.status.OrderStatus;
import com.dtyunxi.yundt.cube.center.payment.dto.exception.ApiException;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.DefaultGatewayService;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.CheckResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.check.CheckOrderService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.CscanBPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.query.CscanbPayQueryGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.trade.CscanbPayOrderCreateGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.trade.CscanbPayOrderRefundGatewayServiceImpl;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.CscanbPayQueryResponse;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.PayOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.EnterpriseOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PartnerConfigEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.PayOrderEo;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanBPayGatewayService")
public class CscanBPayGatewayServiceImpl
extends DefaultGatewayService
implements CscanBPayGatewayService<PayOrderEo, RefundOrderEo, EnterpriseOrderEo> {
    private static final Logger log = LoggerFactory.getLogger(CscanBPayGatewayServiceImpl.class);
    private final String APPLICATION_NAME = "tcbj-center-payment";
    private final String UNION_PAY_KEY = "UNION-PAY";
    @Resource
    private ILockService lockService;
    @Resource
    private CheckOrderService checkPayOrderService;
    @Resource
    private PayOrderDas payOrderDas;
    @Resource
    private CscanbPayOrderCreateGatewayServiceImpl cscanbPayOrderCreateGatewayServiceImpl;
    @Resource
    private CscanbPayOrderRefundGatewayServiceImpl cscanbPayOrderRefundGatewayServiceImpl;
    @Resource
    private CscanbPayQueryGatewayServiceImpl cscanbPayQueryGatewayServiceImpl;

    public BaseGatewayResult closePayTrade(PayOrderEo order) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseGatewayResult createPayTrade(PayOrderEo order) {
        BaseGatewayResult baseGatewayResult = null;
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock("tcbj-center-payment", order.getAppCode() + "UNION-PAY" + order.getStoreOrderId(), 3, 20, TimeUnit.SECONDS);
            if (null == order.getParentTradeId()) {
                PayOrderEo filter = new PayOrderEo();
                filter.setAppCode(order.getAppCode());
                filter.setStoreOrderId(order.getStoreOrderId());
                filter.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"status", Arrays.asList(OrderStatus.ACCEPT.getStatus(), OrderStatus.SUCCESS.getStatus()))));
                List orderEos = this.payOrderDas.select((BaseEo)filter);
                for (PayOrderEo payOrderEo : orderEos) {
                    CheckResult checkResult = this.checkPayOrderService.checkOrder(payOrderEo.getTradeId());
                    if (checkResult.getResult() == 1) {
                        log.info("\u94f6\u8054C\u626bB\u652f\u4ed8\u6210\u529f,\u4e0d\u5141\u8bb8\u5728\u53d1\u8d77\u652f\u4ed8: {}", (Object)payOrderEo.getTradeId());
                        throw new ApiException(String.format("\u94f6\u8054C\u626bB\u652f\u4ed8\u6210\u529f, \u4e0d\u5141\u8bb8\u518d\u6b21\u652f\u4ed8\uff01\u4e2d\u53f0\u652f\u4ed8\u6d41\u6c34\u53f7: %s", payOrderEo.getTradeId()));
                    }
                    if (checkResult.getResult() != 3) continue;
                    log.info("\u94f6\u8054C\u626bB\u652f\u4ed8\u53d7\u7406\u6210\u529f, \u5c1a\u672a\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u652f\u4ed8\uff01\u4e2d\u53f0\u652f\u4ed8\u6d41\u6c34\u53f7: {}", (Object)payOrderEo.getTradeId());
                    throw new ApiException(String.format("\u94f6\u8054C\u626bB\u652f\u4ed8\u53d7\u7406\u6210\u529f, \u8bf7\u5c3d\u5feb\u652f\u4ed8\uff01\u4e2d\u53f0\u652f\u4ed8\u6d41\u6c34\u53f7: %s", payOrderEo.getTradeId()));
                }
            }
            baseGatewayResult = this.cscanbPayOrderCreateGatewayServiceImpl.execute(order);
            if (null == mutex) return baseGatewayResult;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ApiException(e.getMessage());
            }
            catch (Throwable throwable) {
                if (null == mutex) throw throwable;
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
        return baseGatewayResult;
    }

    public BaseGatewayResult createRefundTrade(RefundOrderEo order) {
        return this.cscanbPayOrderRefundGatewayServiceImpl.execute(order);
    }

    public BaseGatewayResult createEnterpriseTransferOrder(EnterpriseOrderEo order) {
        return null;
    }

    public BaseGatewayResult createEnterOrder(EnterpriseOrderEo order) {
        return null;
    }

    public BaseGatewayResult handleNotify(Map<String, String> notify, String ntfyTradeId) throws Exception {
        return null;
    }

    public CheckResult checkOrder(String tradeId) {
        CheckResult result = new CheckResult();
        try {
            PayOrderEo payOrderEo = (PayOrderEo)this.payOrderDas.selectByLogicKey((Object)tradeId);
            CscanbPayQueryResponse response = this.cscanbPayQueryGatewayServiceImpl._execute(payOrderEo);
            return (CheckResult)this.cscanbPayQueryGatewayServiceImpl.rechargeResult(payOrderEo, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public BaseGatewayResult downloadTradeOrder(PartnerConfigEo partnerConfig) {
        return null;
    }
}

