/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.notify;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.notify.BillPaymentDto;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanbRefundNotifyGatewayServiceImpl")
public class CscanbRefundNotifyGatewayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(CscanbRefundNotifyGatewayServiceImpl.class);
    @Resource
    protected OrderProcessorService<RefundOrderEo, Object> payRefundOrderProcessorService;

    public String _execute(Map<String, String> map) throws Exception {
        String refundOrderId = map.get("refundOrderId");
        if (StringUtils.isBlank((CharSequence)refundOrderId)) {
            log.error("\u6e20\u9053\u901a\u77e5\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\u3002");
            return "FAILED";
        }
        BillPaymentDto billPaymentDto = (BillPaymentDto)JSON.parseObject((String)map.get("billPayment"), BillPaymentDto.class);
        log.info("billPaymentDto:{}", (Object)JSON.toJSONString((Object)billPaymentDto));
        if ("TRADE_REFUND".equals(billPaymentDto.getStatus())) {
            String refundPayTime = map.get("refundPayTime");
            RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundOrderId, (Date)DateUtil.parseDate((String)refundPayTime, (String)"yyyy-MM-dd HH:mm:ss"));
            String refundAmount = map.get("refundAmount");
            BigDecimal amount = new BigDecimal(refundAmount).divide(new BigDecimal("100"), 2, 1);
            partnerOrder.setAmount(amount);
            partnerOrder.setRemark1(map.get("refundExtOrderId"));
            partnerOrder.setRemark2(map.get("seqId"));
            partnerOrder.setRemark3(map.get("notifyId"));
            partnerOrder.setRemark4(map.get("refundOrderId"));
            partnerOrder.setRemark5(billPaymentDto.getMerOrderId());
            this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
            return "SUCCESS";
        }
        if ("UNKNOWN".equals(billPaymentDto.getStatus())) {
            return "SUCCESS";
        }
        if ("TRADE_CLOSED".equals(billPaymentDto.getStatus())) {
            RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundOrderId, (Date)new Date());
            partnerOrder.setErrorCode("CLOSED");
            partnerOrder.setErrorMsg("\u8d26\u5355\u5173\u95ed");
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
            return "SUCCESS";
        }
        return "SUCCESS";
    }
}

