/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.impl.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.BaseGatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.gateway.bean.GatewayResult;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.config.UnionPayConfig;
import com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.cscanb.AbstractCscanBPayGatewayService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.UnionPayPartnerService;
import com.dtyunxi.yundt.cube.center.payment.unionpay.partner.domain.response.UnionRefundResponse;
import com.dtyunxi.yundt.cube.center.payment.unionpay.util.UnionPayUtil;
import com.dtyunxi.yundt.cube.center.settlement.dao.das.RefundOrderDas;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="cscanbPayOrderRefundGatewayService")
public class CscanbPayOrderRefundGatewayServiceImpl
extends AbstractCscanBPayGatewayService<RefundOrderEo, UnionRefundResponse> {
    private static final String instId = "QRPAYDEFAULT";
    @Resource
    private UnionPayConfig unionPayConfig;
    @Resource
    protected UnionPayPartnerService unionPayPartnerService;
    @Resource
    private RefundOrderDas refundOrderDas;
    @Resource
    protected OrderProcessorService<RefundOrderEo, Object> payRefundOrderProcessorService;

    public BaseGatewayResult rechargeResult(RefundOrderEo order, UnionRefundResponse response) throws Exception {
        GatewayResult gatewayResult = this.parseBaseResponse(response, order.getTradeId());
        RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)order.getRefundId());
        if ("SUCCESS".equals(response.getErrCode()) && "SUCCESS".equals(response.getRefundStatus())) {
            HashMap<String, String> attach = new HashMap<String, String>();
            attach.put("refundId", order.getRefundId());
            attach.put("tradeId", order.getTradeId());
            gatewayResult.setData(attach);
            partnerOrder.setPartnerOrderId(response.getRefundTargetOrderId());
            this.payRefundOrderProcessorService.handleAcceptOrder((Object)partnerOrder);
            this.mqMessageService.sendDelaySingleMessageAsync("YX_PAY_ORDER_CHECK", (Object)order.getRefundId(), DEFAULT_QUERY_DELAY_TIME);
        } else {
            partnerOrder.setErrorMsg(response.getErrMsg());
            partnerOrder.setErrorCode(response.getErrCode());
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
        }
        this.logger.info("gatewayResult:{}", (Object)JSON.toJSONString((Object)gatewayResult));
        return gatewayResult;
    }

    private GatewayResult parseBaseResponse(UnionRefundResponse response, String tradeId) {
        GatewayResult result = new GatewayResult();
        result.setNotifyTradeId(tradeId);
        result.setDoneSucc(false);
        if ("SUCCESS".equals(response.getErrCode())) {
            result.setDoneSucc(true);
        } else {
            result.setErrorCode(response.getErrCode());
            result.setErrorMsg(response.getErrMsg());
        }
        return result;
    }

    public UnionRefundResponse _execute(RefundOrderEo refundOrderEo) throws Exception {
        String day;
        this.logger.info("unionPayConfig:{}", (Object)this.unionPayConfig);
        RefundBody reqBody = new RefundBody();
        Date date = new Date();
        reqBody.requestTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        reqBody.mid = this.unionPayConfig.getMid();
        reqBody.tid = this.unionPayConfig.getTid();
        reqBody.instMid = instId;
        reqBody.billDate = day = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String outRefundNo = UnionPayUtil.getNewTradeId(refundOrderEo.getRefundId());
        this.updateRefundNo(refundOrderEo, outRefundNo);
        refundOrderEo.setRefundId(outRefundNo);
        reqBody.billNo = refundOrderEo.getTradeId();
        reqBody.refundOrderId = refundOrderEo.getRefundId();
        reqBody.refundAmount = refundOrderEo.getAmount().multiply(new BigDecimal("100")).intValue();
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        String authorization = CscanbPayOrderRefundGatewayServiceImpl.getAuthorization(this.unionPayConfig.getAppId(), this.unionPayConfig.getAppKey(), time, nonce, reqBody.toString());
        this.logger.info("authorization:{}", (Object)authorization);
        this.logger.info("reqBody:{}", (Object)reqBody.toString());
        String result = CscanbPayOrderRefundGatewayServiceImpl.request(this.unionPayConfig.getCscanbRefundUrl(), authorization, reqBody.toString());
        this.logger.info("result:{}", (Object)result);
        UnionRefundResponse response = (UnionRefundResponse)((Object)JSON.parseObject((String)result, UnionRefundResponse.class));
        this.logger.info("response:{}", (Object)response);
        if (!"SUCCESS".equals(response.getErrCode())) {
            response.setErrCode("-1");
            response.setErrMsg("\u8bf7\u6c42\u5f02\u5e38");
        }
        return response;
    }

    private void updateRefundNo(RefundOrderEo refundOrderEo, String outRefundNo) {
        RefundOrderEo updateEo = new RefundOrderEo();
        updateEo.setId(refundOrderEo.getId());
        updateEo.setRefundId(outRefundNo);
        this.refundOrderDas.updateSelective((BaseEo)updateEo);
    }

    public void validate(RefundOrderEo refundOrderEo, UnionRefundResponse unionRefundResponse) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String request(String url, String authorization, String reqBody) {
        String response = "";
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            HttpURLConnection httpUrlConnection = (HttpURLConnection)conn;
            httpUrlConnection.setRequestProperty("Content-Type", "application/json");
            httpUrlConnection.setRequestProperty("authorization", authorization);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setDoInput(true);
            out = new PrintWriter(httpUrlConnection.getOutputStream());
            out.write(reqBody);
            out.flush();
            httpUrlConnection.connect();
            in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
            while ((line = in.readLine()) != null) {
                response = response + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return response;
    }

    static String getAuthorization(String appid, String appkey, String timestamp, String nonce, String body) throws Exception {
        byte[] data = body.getBytes("utf-8");
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        String testSH = DigestUtils.sha256Hex((InputStream)is);
        String s1 = appid + timestamp + nonce + testSH;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(appkey.getBytes("utf-8"), "HmacSHA256"));
        byte[] localSignature = mac.doFinal(s1.getBytes("utf-8"));
        String localSignatureStr = Base64.encodeBase64String((byte[])localSignature);
        return "OPEN-BODY-SIG AppId=\"" + appid + "\", Timestamp=\"" + timestamp + "\", Nonce=\"" + nonce + "\", Signature=\"" + localSignatureStr + "\"";
    }

    static class RefundBody {
        String msgId;
        String requestTimestamp;
        String srcReserve;
        String mid;
        String tid;
        String instMid;
        String billNo;
        String billDate;
        String refundOrderId;
        int refundAmount;
        int platformAmount;
        List<SubOrderItem> subOrders;
        String refundDesc;

        RefundBody() {
        }

        String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.msgId != null) {
                sb.append("\"msgId\":\"" + this.msgId + "\",");
            }
            if (this.requestTimestamp != null) {
                sb.append("\"requestTimestamp\":\"" + this.requestTimestamp + "\",");
            }
            if (this.srcReserve != null) {
                sb.append("\"srcReserve\":\"" + this.srcReserve + "\",");
            }
            if (this.mid != null) {
                sb.append("\"mid\":\"" + this.mid + "\",");
            }
            if (this.tid != null) {
                sb.append("\"tid\":\"" + this.tid + "\",");
            }
            if (this.instMid != null) {
                sb.append("\"instMid\":\"" + this.instMid + "\",");
            }
            if (this.billNo != null) {
                sb.append("\"billNo\":\"" + this.billNo + "\",");
            }
            if (this.billDate != null) {
                sb.append("\"billDate\":\"" + this.billDate + "\",");
            }
            if (this.refundOrderId != null) {
                sb.append("\"refundOrderId\":\"" + this.refundOrderId + "\",");
            }
            if (this.refundAmount != 0) {
                sb.append("\"refundAmount\":\"" + this.refundAmount + "\",");
            }
            if (this.platformAmount != 0) {
                sb.append("\"platformAmount\":\"" + this.platformAmount + "\",");
            }
            if (this.subOrders != null && this.subOrders.size() > 0) {
                sb.append("\"subOrders\":[");
                for (int i = 0; i < this.subOrders.size(); ++i) {
                    sb.append(this.subOrders.get(i));
                    sb.append(",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("],");
            }
            if (this.refundDesc != null) {
                sb.append("\"refundDesc\":\"" + this.refundDesc + "\",");
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("}");
            return sb.toString();
        }

        public String toString() {
            return this.toJson();
        }

        static class SubOrderItem {
            String mid;
            int totalAmount;

            SubOrderItem() {
            }

            String toJson() {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                if (this.mid != null) {
                    sb.append("\"mid\":\"" + this.mid + "\",");
                }
                if (this.totalAmount != 0) {
                    sb.append("\"totalAmount\":\"" + this.totalAmount + "\",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("}");
                return sb.toString();
            }

            public String toString() {
                return this.toJson();
            }
        }
    }
}

