/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.payment.unionpay.gateway.webpay.impl.notify;

import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.payment.service.trade.helper.OrderAssistant;
import com.dtyunxi.yundt.cube.center.payment.service.trade.processor.OrderProcessorService;
import com.dtyunxi.yundt.cube.center.settlement.dao.eo.RefundOrderEo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service(value="webPayRefundNotifyGatewayServiceImpl")
public class WebPayRefundNotifyGatewayServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WebPayRefundNotifyGatewayServiceImpl.class);
    @Resource
    protected OrderProcessorService<RefundOrderEo, Object> payRefundOrderProcessorService;

    public String _execute(Map<String, String> map) throws Exception {
        String refundOrderId = map.get("refundOrderId");
        if (StringUtils.isBlank((CharSequence)refundOrderId)) {
            log.error("\u6e20\u9053\u901a\u77e5\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\u3002");
            return "FAILED";
        }
        if ("TRADE_REFUND".equals(map.get("status"))) {
            String refundPayTime = map.get("refundPayTime");
            RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundOrderId, (Date)DateUtil.parseDate((String)refundPayTime, (String)"yyyy-MM-dd HH:mm:ss"));
            String refundAmount = map.get("refundAmount");
            BigDecimal amount = new BigDecimal(refundAmount).divide(new BigDecimal("100"), 2, 1);
            partnerOrder.setAmount(amount);
            partnerOrder.setRemark2(map.get("seqId"));
            partnerOrder.setRemark1(map.get("refundExtOrderId"));
            partnerOrder.setRemark3(map.get("notifyId"));
            partnerOrder.setRemark4(map.get("refundOrderId"));
            partnerOrder.setRemark5(map.get("merOrderId"));
            this.payRefundOrderProcessorService.handleSuccOrder((Object)partnerOrder);
            return "SUCCESS";
        }
        if ("FAIL".equals(map.get("status"))) {
            RefundOrderEo partnerOrder = OrderAssistant.createRefundOrder((String)refundOrderId);
            partnerOrder.setErrorCode("FAIL");
            partnerOrder.setErrorMsg("\u9000\u6b3e\u5931\u8d25");
            this.payRefundOrderProcessorService.handleFailOrder((Object)partnerOrder);
            return "FAILED";
        }
        return "SUCCESS";
    }
}

