/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.build;

import com.dtyunxi.cube.center.track.api.constant.TransactionControlTypeEnum;
import com.dtyunxi.cube.center.track.api.constant.TransactionStatusEnum;
import com.dtyunxi.cube.component.track.client.aspect.annotation.TransactionAction;
import com.dtyunxi.cube.component.track.client.utils.PointUtils;
import com.dtyunxi.cube.component.track.client.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.client.vo.TransactionVo;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionVoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionVoBuilder.class);

    public TransactionVo build(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        TransactionAction transactionAction = ms.getClass().getAnnotation(TransactionAction.class);
        TransactionAction methodTransactionAction = this.getMethodTransactionAction(point, ms);
        TransactionVo transactionVo = new TransactionVo();
        TransactionVo overallTransaction = ServerContextUtils.loadTransactionVoByContext("transaction.overall", "transaction.overall.json");
        TransactionVo processTransaction = ServerContextUtils.loadTransactionVoByContext("transaction.process", "transaction.process.json");
        transactionVo.setEnv(System.getProperty("spring.profiles.active", "dev"));
        transactionVo.setParentTransactionId(processTransaction != null ? processTransaction.getId() : (overallTransaction != null ? overallTransaction.getId() : 0L));
        transactionVo.setOverTransactionId(overallTransaction != null ? overallTransaction.getId() : null);
        transactionVo.setRequestId(ServerContextUtils.getReqId());
        transactionVo.setTransactionSort(processTransaction != null ? processTransaction.getTransactionSort() + 1L : (overallTransaction != null ? overallTransaction.getTransactionSort() + 1L : 1L));
        transactionVo.setTransactionStatus(TransactionStatusEnum.T_ACCEPT.code);
        transactionVo.setAccessTime(new Date());
        if (transactionAction == null && methodTransactionAction == null) {
            this.repackageByAnnotation(transactionVo, ms);
        } else if (methodTransactionAction == null) {
            this.repackageByAnnotation(transactionVo, transactionAction, ms);
        } else {
            this.repackageByAnnotation(transactionVo, methodTransactionAction, ms);
        }
        return transactionVo;
    }

    public void repackageByAnnotation(TransactionVo transactionVo, MethodSignature ms) {
        transactionVo.setTransactionName(PointUtils.getPointName(ms));
        transactionVo.setTransactionGroup(PointUtils.getPointGroup(ms));
        transactionVo.setTransactionCode(PointUtils.getPointCode(ms));
        transactionVo.setTransactionControlType(TransactionControlTypeEnum.T_OPEN.getCode());
    }

    public void repackageByAnnotation(TransactionVo transactionVo, TransactionAction transactionAction, MethodSignature ms) {
        transactionVo.setTransactionName(this.compareAndGet(transactionAction.name(), e -> PointUtils.getPointName(ms)));
        transactionVo.setTransactionGroup(this.compareAndGet(transactionAction.group(), e -> PointUtils.getPointGroup(ms)));
        transactionVo.setTransactionCode(this.compareAndGet(transactionAction.code(), e -> PointUtils.getPointCode(ms)));
        transactionVo.setTransactionControlType(transactionAction.controlType());
    }

    public String compareAndGet(String a, Function<String, String> b) {
        return StringUtils.isNotBlank((CharSequence)a) ? a : b.apply(null);
    }

    public TransactionAction getMethodTransactionAction(ProceedingJoinPoint point, MethodSignature ms) {
        try {
            Method method = point.getTarget().getClass().getDeclaredMethod(ms.getName(), ms.getParameterTypes());
            return method.getAnnotation(TransactionAction.class);
        }
        catch (NoSuchMethodException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

