/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.collector;

import com.dtyunxi.cube.component.track.client.config.TransactionTrackConfigVo;
import com.dtyunxi.cube.component.track.client.executor.constant.FeatureExecutorMethodType;
import com.dtyunxi.cube.component.track.client.executor.vo.TrackFeatureResultVo;
import com.dtyunxi.cube.component.track.client.vo.TransactionBaseVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class TrackDataCollector {
    private static Logger logger = LoggerFactory.getLogger(TrackDataCollector.class);
    private static Map<FeatureExecutorMethodType, Queue<TransactionBaseVo>> DATA_COLLECT_MAP = new ConcurrentHashMap<FeatureExecutorMethodType, Queue<TransactionBaseVo>>();
    @Resource
    private TransactionTrackConfigVo transactionTrackConfigVo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public <T extends TransactionBaseVo> Future<TrackFeatureResultVo> featureCollect(T data) {
        if (data.getFeatureExecutorMethodType() == null) {
            logger.debug("featureCollect\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
            return null;
        }
        TrackFeatureResultVo<T> trackFeatureResultVo = new TrackFeatureResultVo<T>();
        Queue transactionBaseVos = DATA_COLLECT_MAP.get((Object)data.getFeatureExecutorMethodType());
        if (transactionBaseVos == null) {
            TrackDataCollector trackDataCollector = this;
            synchronized (trackDataCollector) {
                transactionBaseVos = DATA_COLLECT_MAP.computeIfAbsent(data.getFeatureExecutorMethodType(), k -> new LinkedBlockingDeque(this.transactionTrackConfigVo.getTrackAsyncMaxCollectCount()));
            }
        }
        trackFeatureResultVo.setData(data);
        transactionBaseVos.add(data);
        return new AsyncResult(trackFeatureResultVo);
    }

    public List<TransactionBaseVo> pollTransactionBaseVo(FeatureExecutorMethodType featureExecutorMethodType, int pollNum) {
        TransactionBaseVo transactionBaseVo;
        Queue<TransactionBaseVo> transactionBaseVos = DATA_COLLECT_MAP.get((Object)featureExecutorMethodType);
        if (CollectionUtils.isEmpty(transactionBaseVos)) {
            return null;
        }
        ArrayList transactionBaseVoList = Lists.newArrayList();
        for (int i = 0; i < pollNum && (transactionBaseVo = transactionBaseVos.poll()) != null; ++i) {
            transactionBaseVoList.add(transactionBaseVo);
        }
        return transactionBaseVoList;
    }
}

