/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.executor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.track.api.constant.TransactionNodeStatusEnum;
import com.dtyunxi.cube.center.track.api.constant.TransactionNodeTypeEnum;
import com.dtyunxi.cube.component.track.client.build.TransactionNodeVoBuilder;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackNodeExecutor;
import com.dtyunxi.cube.component.track.client.service.ITransactionNodeRecordOptService;
import com.dtyunxi.cube.component.track.client.service.ITransactionNodeRegisterService;
import com.dtyunxi.cube.component.track.client.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.client.vo.CommonUtils;
import com.dtyunxi.cube.component.track.client.vo.TransactionNodeRecordVo;
import com.dtyunxi.cube.component.track.client.vo.TransactionNodeVo;
import com.dtyunxi.cube.component.track.client.vo.TransactionTrackNodeResult;
import com.dtyunxi.cube.component.track.client.vo.TransactionVo;
import com.dtyunxi.cube.component.track.client.zipkin.api.ZipkinApi;
import com.dtyunxi.cube.component.track.client.zipkin.module.Endpoint;
import com.dtyunxi.cube.component.track.client.zipkin.module.Span;
import com.dtyunxi.rest.RestResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefaultTransactionTrackNodeExecutor
implements TransactionTrackNodeExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTransactionTrackNodeExecutor.class);
    @Resource
    private ITransactionNodeRegisterService transactionNodeRegisterService;
    @Resource
    private ITransactionNodeRecordOptService transactionNodeRecordService;
    @Resource
    private ZipkinApi zipkinApi;
    @Value(value="${dtyunxi.env.module:myapp-name}")
    private String appName;
    @Value(value="${cube.global.profile:dev}")
    private String env;

    @Override
    public Object transactionNodeActionAround(ProceedingJoinPoint point, TransactionNodeTypeEnum transactionNodeTypeEnum) throws Throwable {
        logger.debug("\u3010transactionNodeActionAop.around\u3011class={}\uff0cmethod={}", (Object)point.getSignature().getDeclaringTypeName(), (Object)point.getSignature().getName());
        TransactionTrackNodeResult transactionTrackNodeResult = this.transactionNodeAction(point, transactionNodeTypeEnum);
        if (transactionTrackNodeResult == null) {
            return point.proceed();
        }
        logger.debug(">>>>>>>>>>>>>>after.transactionNodeAction:{}", (Object)JSON.toJSONString(ServerContextUtils.getKeys()));
        Object obj = null;
        Throwable exception = null;
        try {
            obj = point.proceed();
        }
        catch (Throwable throwable) {
            exception = throwable;
            throw throwable;
        }
        finally {
            this.transactionNodeEnd(point, transactionTrackNodeResult, obj, exception);
            logger.debug(">>>>>>>>>>>>>>after.transactionNodeEnd:{}", (Object)JSON.toJSONString(ServerContextUtils.getKeys()));
        }
        return obj;
    }

    @Override
    public TransactionTrackNodeResult transactionNodeAction(ProceedingJoinPoint point, TransactionNodeTypeEnum transactionNodeTypeEnum) {
        logger.debug("\u3010TransactionTrackNodeExecutor.transactionNodeAction\u3011class.method={}.{}", (Object)point.getSignature().getDeclaringTypeName(), (Object)point.getSignature().getName());
        TransactionTrackNodeResult trackNodeResult = null;
        try {
            TransactionNodeVoBuilder builder = new TransactionNodeVoBuilder();
            TransactionVo overallTransaction = ServerContextUtils.loadTransactionVoByContext("transaction.overall", "transaction.overall.json");
            TransactionVo processTransaction = ServerContextUtils.loadTransactionVoByContext("transaction.process", "transaction.process.json");
            if (overallTransaction == null || processTransaction == null) {
                logger.debug("\u7f3a\u5c11\u5fc5\u8981\u4e0a\u4e0b\u6587\u6570\u636e\uff0c\u7ed3\u675f\u8ddf\u8e2a\u8fc7\u7a0b");
                return null;
            }
            TransactionNodeVo transactionNodeVo = builder.build(point, overallTransaction, processTransaction, transactionNodeTypeEnum, this.env, this.appName);
            logger.debug("\u3010TransactionTrackExecutor.builder.vo\u3011vo={}", (Object)JSON.toJSONString((Object)((Object)transactionNodeVo)));
            transactionNodeVo = this.transactionNodeRegisterService.asyncRegisterTransactionNode(transactionNodeVo);
            trackNodeResult = this.buildTransactionTrackNodeResultAndResetContext(transactionNodeVo, overallTransaction, processTransaction);
            this.saveTransactionNodeRecord(point, trackNodeResult);
        }
        catch (Throwable e) {
            logger.debug(e.getMessage(), e);
        }
        return trackNodeResult;
    }

    private void saveTransactionNodeRecord(ProceedingJoinPoint point, TransactionTrackNodeResult trackNodeResult) {
        TransactionNodeRecordVo transactionNodeRecordVo = this.buildTransactionNodeRecordVo(point, trackNodeResult);
        Long recordId = this.transactionNodeRecordService.asyncSaveTransactionNodeRecord(transactionNodeRecordVo);
        transactionNodeRecordVo.setId(recordId);
        trackNodeResult.setTransactionNodeRecordVo(transactionNodeRecordVo);
    }

    private TransactionTrackNodeResult buildTransactionTrackNodeResultAndResetContext(TransactionNodeVo transactionNodeVo, TransactionVo overallTransaction, TransactionVo processTransaction) {
        TransactionTrackNodeResult trackNodeResult = new TransactionTrackNodeResult();
        trackNodeResult.setTransactionNodeVo(transactionNodeVo);
        trackNodeResult.setOverallTransaction(overallTransaction);
        trackNodeResult.setProcessTransaction(processTransaction);
        return trackNodeResult;
    }

    @Override
    public void transactionNodeEnd(ProceedingJoinPoint point, TransactionTrackNodeResult result, Object obj, Throwable throwable) {
        try {
            logger.debug("\u3010TransactionTrackNodeExecutor.transactionNodeEnd\u3011result={}\uff0cobj={}, isThrowable={}", new Object[]{JSON.toJSONString((Object)result), JSON.toJSONString((Object)obj), throwable != null});
            if (throwable != null) {
                logger.debug("\u3010TransactionTrackNodeExecutor.transactionNodeEnd\u3011throwable:" + throwable.getMessage(), throwable);
            }
            Long curTime = new Date().getTime() - result.getTransactionNodeVo().getAccessTime().getTime();
            TransactionNodeVo updateTransactionNodeVo = this.buildUpdateTransactionNodeVo(result.getTransactionNodeVo(), obj, throwable);
            this.transactionNodeRegisterService.asyncModifyTransactionNode(updateTransactionNodeVo);
            this.modifyTransactionNodeExecuteRecord(updateTransactionNodeVo, point, result, obj, throwable, curTime);
        }
        catch (Throwable t1) {
            logger.debug(t1.getMessage(), t1);
        }
    }

    private void modifyTransactionNodeExecuteRecord(TransactionNodeVo updateTransactionNodeVo, ProceedingJoinPoint point, TransactionTrackNodeResult result, Object obj, Throwable throwable, Long curTime) throws IOException, NoSuchFieldException, IllegalAccessException {
        TransactionNodeRecordVo updateTransactionNodeRecordVo = new TransactionNodeRecordVo();
        updateTransactionNodeRecordVo.setId(result.getTransactionNodeRecordVo().getId());
        updateTransactionNodeRecordVo.setNodeStatus(updateTransactionNodeVo.getNodeStatus());
        try {
            updateTransactionNodeRecordVo.setNodeApiResponse(JSON.toJSONString((Object)obj));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            updateTransactionNodeRecordVo.setNodeApiResponse(Objects.toString(obj));
        }
        this.transactionNodeRecordService.asyncModifyTransactionNodeRecord(updateTransactionNodeRecordVo);
        Span span = this.exchangeTransactionNodeToSpan(updateTransactionNodeRecordVo, point, result, obj, throwable, curTime);
        this.zipkinApi.asyncSpansPost(Collections.singletonList(span));
    }

    private TransactionNodeRecordVo buildTransactionNodeRecordVo(ProceedingJoinPoint point, TransactionTrackNodeResult result) {
        TransactionNodeRecordVo transactionNodeRecordVo = new TransactionNodeRecordVo();
        transactionNodeRecordVo.setNodeStatus(TransactionNodeStatusEnum.N_ACCEPT.getCode());
        transactionNodeRecordVo.setNodeId(result.getTransactionNodeVo().getId());
        transactionNodeRecordVo.setNodeCode(result.getTransactionNodeVo().getNodeCode());
        transactionNodeRecordVo.setAccessTime(result.getTransactionNodeVo().getAccessTime());
        transactionNodeRecordVo.setEnv(result.getTransactionNodeVo().getEnv());
        try {
            transactionNodeRecordVo.setNodeApiMethodParams(JSON.toJSONString((Object)point.getArgs()));
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
            transactionNodeRecordVo.setNodeApiMethodParams(Objects.toString(point.getArgs()));
        }
        return transactionNodeRecordVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Span exchangeTransactionNodeToSpan(TransactionNodeRecordVo TransactionNodeRecordVo2, ProceedingJoinPoint point, TransactionTrackNodeResult result, Object obj, Throwable throwable, Long curTime) throws IOException, NoSuchFieldException, IllegalAccessException {
        TransactionNodeVo transactionNodeVo = result.getTransactionNodeVo();
        Span span = new Span();
        span.setDuration(curTime);
        span.setId(Long.toHexString(transactionNodeVo.getId()));
        span.setDebug(true);
        span.setName(transactionNodeVo.getNodeApiClass() + "." + transactionNodeVo.getNodeApiMethod());
        span.setParentId(Long.toHexString(transactionNodeVo.getTransactionId()));
        span.setShared(true);
        span.setTimestamp(transactionNodeVo.getAccessTime().getTime() * 1000L);
        span.setTraceId(Long.toHexString(transactionNodeVo.getOverTransactionId()));
        span.setKind(TransactionNodeTypeEnum.forCode((int)transactionNodeVo.getNodeType()) == TransactionNodeTypeEnum.N_GATE ? Span.KindEnum.SERVER : Span.KindEnum.CLIENT);
        span.setLocalEndpoint(this.buildLocalEndpoint(transactionNodeVo));
        if (span.getKind() == Span.KindEnum.CLIENT) {
            span.setRemoteEndpoint(this.buildRemoteEndpoint(point, transactionNodeVo));
            span.getLocalEndpoint().serviceName(this.appName);
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("request_body", result.getTransactionNodeRecordVo().getNodeApiMethodParams());
        tags.put("response_body", TransactionNodeRecordVo2.getNodeApiResponse());
        tags.put("track_vo", JSON.toJSONString((Object)((Object)transactionNodeVo)));
        tags.put("request_id", result.getProcessTransaction().getRequestId());
        tags.put("execute_point", transactionNodeVo.getNodeCode());
        if (throwable != null) {
            tags.put("x_exception_message", throwable.getMessage());
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                throwable.printStackTrace(new PrintStream(out));
                tags.put("x_exception_stack", out.toString());
            }
        }
        span.setTags(tags);
        return span;
    }

    private Endpoint buildLocalEndpoint(TransactionNodeVo transactionNodeVo) throws UnknownHostException {
        return new Endpoint().ipv4(StringUtils.isBlank((CharSequence)MDC.get((String)"yes.server.localHost")) ? InetAddress.getLocalHost().getHostAddress() : MDC.get((String)"yes.server.localHost")).port(Integer.valueOf(StringUtils.isBlank((CharSequence)MDC.get((String)"yes.req.localPort")) ? "8080" : MDC.get((String)"yes.req.localPort"))).serviceName(transactionNodeVo.getNodeApiApplication());
    }

    private Endpoint buildRemoteEndpoint(ProceedingJoinPoint point, TransactionNodeVo transactionNodeVo) throws UnknownHostException, NoSuchFieldException, IllegalAccessException {
        if (StringUtils.isNotBlank((CharSequence)transactionNodeVo.getServerAddress())) {
            Pattern p = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)\\:(\\d+)");
            Matcher m = p.matcher(transactionNodeVo.getServerAddress());
            String ip = null;
            Integer port = null;
            while (m.find()) {
                ip = m.group(1);
                port = m.group(2) == null ? null : Integer.valueOf(m.group(2));
            }
            return new Endpoint().serviceName(transactionNodeVo.getNodeApiApplication()).ipv4(ip).port(port);
        }
        return new Endpoint().serviceName(transactionNodeVo.getNodeApiApplication());
    }

    private TransactionNodeVo buildUpdateTransactionNodeVo(TransactionNodeVo transactionNodeVo, Object obj, Throwable throwable) {
        TransactionNodeVo updateTransactionVo = new TransactionNodeVo();
        updateTransactionVo.setId(transactionNodeVo.getId());
        if (throwable != null) {
            updateTransactionVo.setNodeStatus(TransactionNodeStatusEnum.N_ERROR.getCode());
        } else if (obj instanceof RestResponse) {
            if (CommonUtils.isSuccess((RestResponse)obj)) {
                updateTransactionVo.setNodeStatus(TransactionNodeStatusEnum.N_SUCCESS.getCode());
            } else {
                updateTransactionVo.setNodeStatus(TransactionNodeStatusEnum.N_FAIL.getCode());
            }
        } else {
            updateTransactionVo.setNodeStatus(TransactionNodeStatusEnum.N_SUCCESS.getCode());
        }
        return updateTransactionVo;
    }
}

