/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.scheduled;

import com.dtyunxi.cube.component.track.client.collector.TrackDataCollector;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackConfigVo;
import com.dtyunxi.cube.component.track.client.executor.constant.FeatureExecutorMethodType;
import com.dtyunxi.cube.component.track.client.service.ITransactionNodeRecordOptService;
import com.dtyunxi.cube.component.track.client.service.ITransactionNodeRegisterService;
import com.dtyunxi.cube.component.track.client.service.ITransactionRegisterService;
import com.dtyunxi.cube.component.track.client.vo.TransactionBaseVo;
import com.dtyunxi.cube.component.track.client.vo.TransactionNodeRecordVo;
import com.dtyunxi.cube.component.track.client.vo.TransactionNodeVo;
import com.dtyunxi.cube.component.track.client.vo.TransactionVo;
import com.dtyunxi.cube.component.track.client.vo.ZipKinSpanVo;
import com.dtyunxi.cube.component.track.client.zipkin.api.ZipkinApi;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TrackDataCollectorScheduled {
    private static Logger logger = LoggerFactory.getLogger(TrackDataCollectorScheduled.class);
    private static List<TransactionBaseVo> FAIL_LIST = new LinkedList<TransactionBaseVo>();
    private static List<TransactionBaseVo> TMP_FAIL_LIST = new LinkedList<TransactionBaseVo>();
    @Resource
    private TransactionTrackConfigVo transactionTrackConfigVo;
    @Resource
    private TrackDataCollector trackDataCollector;
    @Resource
    private ITransactionRegisterService transactionRegisterService;
    @Resource
    private ITransactionNodeRegisterService transactionNodeRegisterService;
    @Resource
    private ITransactionNodeRecordOptService transactionNodeRecordOptService;
    @Resource
    private ZipkinApi zipkinApi;
    private ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0/10 * * * * ?")
    public void transferTrackDataSchedule() {
        logger.debug("\u3010transferTrackDataSchedule\u3011\u5f00\u59cb\u6536\u96c6\u4e8b\u52a1\u8ddf\u8e2a\u94fe\u8def\u6570\u636e");
        boolean lockFlag = false;
        try {
            if (!this.lock.tryLock()) {
                logger.debug("\u3010transferTrackDataSchedule\u3011\u6709\u4efb\u52a1\u6267\u884c\u4e2d\uff0c\u6682\u4e0d\u5904\u7406");
                return;
            }
            lockFlag = true;
            List<TransactionBaseVo> baseVos = this.collectData();
            try {
                if (CollectionUtils.isNotEmpty(FAIL_LIST)) {
                    for (TransactionBaseVo baseVo : FAIL_LIST) {
                        try {
                            this.executeTransferData(baseVo);
                        }
                        catch (Throwable e) {
                            logger.debug(e.getMessage(), e);
                            TMP_FAIL_LIST.add(baseVo);
                        }
                    }
                    FAIL_LIST.clear();
                }
                while (CollectionUtils.isNotEmpty(baseVos)) {
                    for (TransactionBaseVo baseVo : baseVos) {
                        try {
                            this.executeTransferData(baseVo);
                        }
                        catch (Throwable e) {
                            logger.debug(e.getMessage(), e);
                            TMP_FAIL_LIST.add(baseVo);
                        }
                    }
                    baseVos.clear();
                    baseVos = this.collectData();
                }
            }
            finally {
                if (TMP_FAIL_LIST.size() > 0) {
                    FAIL_LIST.addAll(TMP_FAIL_LIST);
                    TMP_FAIL_LIST.clear();
                }
            }
        }
        catch (Throwable e) {
            logger.debug(e.getMessage(), e);
        }
        finally {
            if (lockFlag) {
                this.lock.unlock();
            }
            logger.debug("\u3010transferTrackDataSchedule\u3011\u4e8b\u52a1\u8ddf\u8e2a\u94fe\u8def\u6570\u636e\u4efb\u52a1\u7ed3\u675f");
        }
    }

    private void executeTransferData(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo == null) {
            logger.debug("executeTransferData\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
            return;
        }
        switch (transactionBaseVo.getFeatureExecutorMethodType()) {
            case TT_SAVE_API: {
                this.registerTransaction(transactionBaseVo);
                break;
            }
            case TT_MODIFY_API: {
                this.modifyTransaction(transactionBaseVo);
                break;
            }
            case TN_SAVE_API: {
                this.registerTransactionNode(transactionBaseVo);
                break;
            }
            case TN_MODIFY_API: {
                this.modifyTransactionNode(transactionBaseVo);
                break;
            }
            case TNR_SAVE_API: {
                this.saveTransactionNodeRecord(transactionBaseVo);
                break;
            }
            case TNR_MODIFY_API: {
                this.modifyTransactionNodeRecord(transactionBaseVo);
                break;
            }
            case ZIPKIN_POST_API: {
                this.spansPost(transactionBaseVo);
                break;
            }
            default: {
                logger.error("executeTransferData\u65e0\u6548\u5f02\u6b65\u6267\u884c\u65b9\u6cd5\u7c7b\u578b");
            }
        }
    }

    public List<TransactionBaseVo> collectData() {
        LinkedList transactionBaseVos = Lists.newLinkedList();
        Arrays.stream(FeatureExecutorMethodType.values()).sorted(Comparator.comparingInt(o -> o.code)).forEach(featureExecutorMethodType -> {
            List<TransactionBaseVo> baseVos = this.trackDataCollector.pollTransactionBaseVo((FeatureExecutorMethodType)((Object)featureExecutorMethodType), this.transactionTrackConfigVo.getTrackAsyncTransferCount());
            if (CollectionUtils.isNotEmpty(baseVos)) {
                transactionBaseVos.addAll(baseVos);
            }
        });
        return transactionBaseVos;
    }

    private void registerTransaction(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof TransactionVo) {
            this.transactionRegisterService.registerTransaction((TransactionVo)transactionBaseVo);
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), TransactionVo.class);
        }
    }

    private void modifyTransaction(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof TransactionVo) {
            this.transactionRegisterService.modifyTransaction((TransactionVo)transactionBaseVo);
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), TransactionVo.class);
        }
    }

    private void modifyTransactionNode(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof TransactionNodeVo) {
            this.transactionNodeRegisterService.modifyTransactionNode((TransactionNodeVo)transactionBaseVo);
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), TransactionNodeVo.class);
        }
    }

    private void registerTransactionNode(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof TransactionNodeVo) {
            this.transactionNodeRegisterService.registerTransactionNode((TransactionNodeVo)transactionBaseVo);
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), TransactionNodeVo.class);
        }
    }

    private void modifyTransactionNodeRecord(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof TransactionNodeRecordVo) {
            this.transactionNodeRecordOptService.modifyTransactionNodeRecord((TransactionNodeRecordVo)transactionBaseVo);
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), TransactionNodeRecordVo.class);
        }
    }

    private void saveTransactionNodeRecord(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof TransactionNodeRecordVo) {
            this.transactionNodeRecordOptService.saveTransactionNodeRecord((TransactionNodeRecordVo)transactionBaseVo);
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), TransactionNodeRecordVo.class);
        }
    }

    private void spansPost(TransactionBaseVo transactionBaseVo) {
        if (transactionBaseVo instanceof ZipKinSpanVo) {
            this.zipkinApi.spansPost(((ZipKinSpanVo)transactionBaseVo).getSpans());
        } else {
            logger.debug("transactionBaseVo\u7c7b\u578b\u8f6c\u6362\u9519\u8bef{} to {}", ((Object)((Object)transactionBaseVo)).getClass(), ZipKinSpanVo.class);
        }
    }
}

