/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.service.impl;

import com.dtyunxi.cube.center.track.api.ITransactionNodeApi;
import com.dtyunxi.cube.center.track.api.dto.request.TransactionNodeReqDto;
import com.dtyunxi.cube.component.track.client.collector.TrackDataCollector;
import com.dtyunxi.cube.component.track.client.exception.TransactionException;
import com.dtyunxi.cube.component.track.client.exception.TransactionExceptionCode;
import com.dtyunxi.cube.component.track.client.executor.constant.FeatureExecutorMethodType;
import com.dtyunxi.cube.component.track.client.service.ITransactionNodeRegisterService;
import com.dtyunxi.cube.component.track.client.vo.CommonUtils;
import com.dtyunxi.cube.component.track.client.vo.TransactionNodeVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TransactionNodeRegisterServiceImpl
implements ITransactionNodeRegisterService {
    @Resource
    private ITransactionNodeApi transactionNodeApi;
    @Resource
    private TrackDataCollector trackDataCollector;

    @Override
    public TransactionNodeVo registerTransactionNode(TransactionNodeVo transactionNodeVo) {
        TransactionNodeReqDto reqDto = new TransactionNodeReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)((Object)transactionNodeVo), (String[])new String[0]);
        Long registerId = (Long)CommonUtils.checkResponse(this.transactionNodeApi.addTransactionNode(reqDto));
        if (registerId == null) {
            throw new TransactionException(TransactionExceptionCode.REGISTER_RESULT_NULL);
        }
        transactionNodeVo.setId(registerId);
        return transactionNodeVo;
    }

    @Override
    public void modifyTransactionNode(TransactionNodeVo transactionNodeVo) {
        TransactionNodeReqDto reqDto = new TransactionNodeReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)((Object)transactionNodeVo), (String[])new String[0]);
        CommonUtils.checkResponse(this.transactionNodeApi.modifyTransactionNode(reqDto));
    }

    @Override
    public TransactionNodeVo asyncRegisterTransactionNode(TransactionNodeVo transactionNodeVo) {
        if (transactionNodeVo.getId() == null) {
            transactionNodeVo.setId(transactionNodeVo.idGenerator());
        }
        transactionNodeVo.setFeatureExecutorMethodType(FeatureExecutorMethodType.TN_SAVE_API);
        this.trackDataCollector.featureCollect(transactionNodeVo);
        return transactionNodeVo;
    }

    @Override
    public void asyncModifyTransactionNode(TransactionNodeVo transactionNodeVo) {
        transactionNodeVo.setFeatureExecutorMethodType(FeatureExecutorMethodType.TN_MODIFY_API);
        this.trackDataCollector.featureCollect(transactionNodeVo);
    }
}

