/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.service.impl;

import com.dtyunxi.cube.center.track.api.ITransactionApi;
import com.dtyunxi.cube.center.track.api.dto.request.TransactionReqDto;
import com.dtyunxi.cube.component.track.client.collector.TrackDataCollector;
import com.dtyunxi.cube.component.track.client.exception.TransactionException;
import com.dtyunxi.cube.component.track.client.exception.TransactionExceptionCode;
import com.dtyunxi.cube.component.track.client.executor.constant.FeatureExecutorMethodType;
import com.dtyunxi.cube.component.track.client.service.ITransactionRegisterService;
import com.dtyunxi.cube.component.track.client.vo.CommonUtils;
import com.dtyunxi.cube.component.track.client.vo.TransactionVo;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TransactionRegisterServiceImpl
implements ITransactionRegisterService {
    @Resource
    private ITransactionApi transactionApi;
    @Resource
    private TrackDataCollector trackDataCollector;

    @Override
    public TransactionVo registerTransaction(TransactionVo transactionVo) {
        TransactionReqDto reqDto = new TransactionReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)((Object)transactionVo), (String[])new String[0]);
        Long registerId = (Long)CommonUtils.checkResponse(this.transactionApi.addTransaction(reqDto));
        if (registerId == null) {
            throw new TransactionException(TransactionExceptionCode.REGISTER_RESULT_NULL);
        }
        transactionVo.setId(registerId);
        return transactionVo;
    }

    @Override
    public void modifyTransaction(TransactionVo transactionVo) {
        TransactionReqDto reqDto = new TransactionReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)((Object)transactionVo), (String[])new String[0]);
        CommonUtils.checkResponse(this.transactionApi.modifyTransaction(reqDto));
    }

    @Override
    public TransactionVo asyncRegisterTransaction(TransactionVo transactionVo) {
        if (transactionVo.getOverTransactionId() == null) {
            Long id = transactionVo.idGenerator();
            transactionVo.setId(id);
            transactionVo.setOverTransactionId(id);
        }
        transactionVo.setFeatureExecutorMethodType(FeatureExecutorMethodType.TT_SAVE_API);
        this.trackDataCollector.featureCollect(transactionVo);
        return transactionVo;
    }

    @Override
    public void asyncModifyTransaction(TransactionVo transactionVo) {
        transactionVo.setFeatureExecutorMethodType(FeatureExecutorMethodType.TT_MODIFY_API);
        this.trackDataCollector.featureCollect(transactionVo);
    }
}

