/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.zipkin.api;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.collector.TrackDataCollector;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackConfigVo;
import com.dtyunxi.cube.component.track.client.executor.constant.FeatureExecutorMethodType;
import com.dtyunxi.cube.component.track.client.utils.HttpUtil;
import com.dtyunxi.cube.component.track.client.vo.ZipKinSpanVo;
import com.dtyunxi.cube.component.track.client.zipkin.module.Span;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZipkinApi {
    private static final Logger logger = LoggerFactory.getLogger(ZipkinApi.class);
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    @Resource
    private TransactionTrackConfigVo transactionTrackConfigVo;
    @Resource
    private TrackDataCollector trackDataCollector;

    public void spansPost(List<Span> spans) {
        String url = this.transactionTrackConfigVo.getZipkinHost() + "/api/v2/spans";
        try {
            String body = JSON.toJSONString(spans);
            logger.debug("\u6267\u884cspansPost,url={},body={}", (Object)url, (Object)body);
            String spanResult = HttpUtil.post(url, body, DEFAULT_HEADERS);
            logger.debug("\u6267\u884cspansPost\u7ed3\u679c={}", (Object)spanResult);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSpansPost(List<Span> spans) {
        try {
            ZipKinSpanVo zipKinSpanVo = new ZipKinSpanVo();
            zipKinSpanVo.setFeatureExecutorMethodType(FeatureExecutorMethodType.ZIPKIN_POST_API);
            zipKinSpanVo.setSpans(spans);
            this.trackDataCollector.featureCollect(zipKinSpanVo);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    static {
        DEFAULT_HEADERS.put("Content-Type", "application/json");
    }
}

