/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.zipkin.module;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Associates an event that explains latency with a timestamp. Unlike log statements, annotations are often codes. Ex. \"ws\" for WireSend  Zipkin v1 core annotations such as \"cs\" and \"sr\" have been replaced with Span.Kind, which interprets timestamp and duration. ")
@JsonPropertyOrder(value={"timestamp", "value"})
public class Annotation {
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Integer timestamp;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public Annotation timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="Epoch **microseconds** of this event.  For example, 1502787600000000 corresponds to 2017-08-15 09:00 UTC  This value should be set directly by instrumentation, using the most precise value possible. For example, gettimeofday or multiplying epoch millis by 1000. ")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public Annotation value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(required=true, value="Usually a short tag indicating an event, like \"error\"  While possible to add larger data, such as garbage collection details, low cardinality event names both keep the size of spans down and also are easy to search against. ")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation annotation = (Annotation)o;
        return Objects.equals(this.timestamp, annotation.timestamp) && Objects.equals(this.value, annotation.value);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Annotation {\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

