/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.zipkin.module;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The count of traced calls between services, or between a service and a broker.  The direction of the link is parent to child, and can be one of:  * client to server  * producer to broker  * broker to consumer  Note: This is related to span ID count between a sender and receiver, but there is nuance that makes it more difficult than counting unique span IDs. Ex. the parent or child might be uninstrumented: detected via the remote endpoint. There can also be scenarios where both sides are instrumented. Please use existing tools such as zipkin-dependencies to derive links as they avoid under or over counting. ")
@JsonPropertyOrder(value={"parent", "child", "callCount", "errorCount"})
public class DependencyLink {
    public static final String JSON_PROPERTY_PARENT = "parent";
    private String parent;
    public static final String JSON_PROPERTY_CHILD = "child";
    private String child;
    public static final String JSON_PROPERTY_CALL_COUNT = "callCount";
    private Integer callCount;
    public static final String JSON_PROPERTY_ERROR_COUNT = "errorCount";
    private Integer errorCount;

    public DependencyLink parent(String parent) {
        this.parent = parent;
        return this;
    }

    @ApiModelProperty(required=true, value="The service name of the caller: client or message producer or broker.")
    @JsonProperty(value="parent")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public DependencyLink child(String child) {
        this.child = child;
        return this;
    }

    @ApiModelProperty(required=true, value="The service name of the callee: server or message consumer or broker.")
    @JsonProperty(value="child")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getChild() {
        return this.child;
    }

    public void setChild(String child) {
        this.child = child;
    }

    public DependencyLink callCount(Integer callCount) {
        this.callCount = callCount;
        return this;
    }

    @ApiModelProperty(required=true, value="Total traced calls made from the parent to the child.")
    @JsonProperty(value="callCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getCallCount() {
        return this.callCount;
    }

    public void setCallCount(Integer callCount) {
        this.callCount = callCount;
    }

    public DependencyLink errorCount(Integer errorCount) {
        this.errorCount = errorCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Total traced calls made from the parent to the child known to be in error.")
    @JsonProperty(value="errorCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(Integer errorCount) {
        this.errorCount = errorCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyLink dependencyLink = (DependencyLink)o;
        return Objects.equals(this.parent, dependencyLink.parent) && Objects.equals(this.child, dependencyLink.child) && Objects.equals(this.callCount, dependencyLink.callCount) && Objects.equals(this.errorCount, dependencyLink.errorCount);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.child, this.callCount, this.errorCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DependencyLink {\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    child: ").append(this.toIndentedString(this.child)).append("\n");
        sb.append("    callCount: ").append(this.toIndentedString(this.callCount)).append("\n");
        sb.append("    errorCount: ").append(this.toIndentedString(this.errorCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

