/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.CreditRepayApplyImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.credit.api.account.ICreditRepayPlanImportApi;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayApplyReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditRepayPlansReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.response.CreditRepayPlanRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.CreditRepayPlanStatusEnum;
import com.dtyunxi.yundt.cube.center.credit.api.credit.query.ICreditRepayPlanQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="creditRepayApplyImportService")
public class CreditRepayApplyImportService
extends ImportService {
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICreditRepayPlanQueryApi creditRepayPlanQueryApi;
    @Resource
    private ICreditRepayPlanImportApi creditRepayPlanImportApi;

    @Override
    public void definedImport(Long organizationId, Object list, List<BaseImportInfoReqDto> errorList, Set<String> importDataUniquekeySet) {
        List creditEntityImportReqDtos = (List)list;
        ArrayList customerCodes = Lists.newArrayList();
        ArrayList repayPlanNos = Lists.newArrayList();
        for (CreditRepayApplyImportReqDto creditEntityImportReqDto : creditEntityImportReqDtos) {
            Optional.ofNullable(creditEntityImportReqDto.getCustomerCode()).ifPresent(customerCodes::add);
            Optional.ofNullable(creditEntityImportReqDto.getRepayPlanNo()).ifPresent(repayPlanNos::add);
        }
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes((List)customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
        }
        Map<Object, Object> planRespDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)repayPlanNos)) {
            List creditRepayPlanRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.creditRepayPlanQueryApi.queryByPlanNos((List)repayPlanNos));
            planRespDtoMap = creditRepayPlanRespDtos.stream().collect(Collectors.toMap(CreditRepayPlanRespDto::getRepayPlanNo, Function.identity(), (e1, e2) -> e1));
        }
        ArrayList creditRepayApplyReqDtos = Lists.newArrayList();
        for (CreditRepayApplyImportReqDto repayApplyImportReqDto : creditEntityImportReqDtos) {
            CreditRepayPlanRespDto creditRepayPlanRespDto;
            StringBuilder sb = new StringBuilder(80);
            if (StringUtil.isEmpty((String)repayApplyImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if (StringUtil.isEmpty((String)repayApplyImportReqDto.getRepayPlanNo())) {
                sb.append("\u8d26\u5355\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if (!importDataUniquekeySet.add(repayApplyImportReqDto.getRepayPlanNo())) {
                sb.append("\u5bfc\u5165\u8d26\u5355\u7f16\u53f7\u91cd\u590d\uff1b");
            }
            BigDecimal refundAmount = super.tryConverBigDecimalAndCheckScale(sb, repayApplyImportReqDto.getRefundAmount(), "\u8fd8\u6b3e\u91d1\u989d", DEF_SCALE, false, false);
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(repayApplyImportReqDto.getCustomerCode());
            if (customerRespDto == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if ((creditRepayPlanRespDto = (CreditRepayPlanRespDto)planRespDtoMap.get(repayApplyImportReqDto.getRepayPlanNo())) == null) {
                sb.append("\u8d26\u5355\u4e0d\u5b58\u5728");
            } else {
                BigDecimal receivedAmount;
                BigDecimal paidAmount;
                BigDecimal waitRefundAmount;
                if (!"NONE".equals(creditRepayPlanRespDto.getAuditStatus())) {
                    sb.append("\u8d26\u5355\u5df2\u5b58\u5728\u5ba1\u6838\u4e2d\u8fd8\u6b3e\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u63d0\u4ea4\u8fd8\u6b3e\u7533\u8bf7\uff1b");
                }
                if (!CreditRepayPlanStatusEnum.NOT_RECEIVABLE.getCode().equals(creditRepayPlanRespDto.getCreditRepayPlanStatus()) && !CreditRepayPlanStatusEnum.PART_RECEIVABLE.getCode().equals(creditRepayPlanRespDto.getCreditRepayPlanStatus())) {
                    sb.append("\u672a\u56de\u6b3e\u3001\u90e8\u4efd\u5df2\u56de\u6b3e\u72b6\u6001\u8d26\u5355\u624d\u5141\u8bb8\u64cd\u4f5c\u63d0\u4ea4\u8fd8\u6b3e\u7533\u8bf7\uff1b");
                }
                if (refundAmount != null && refundAmount.compareTo(waitRefundAmount = (paidAmount = Optional.ofNullable(creditRepayPlanRespDto.getPaidAmount()).orElse(BigDecimal.ZERO)).subtract(receivedAmount = Optional.ofNullable(creditRepayPlanRespDto.getReceivedAmount()).orElse(BigDecimal.ZERO))) > 0) {
                    sb.append("\u8fd8\u6b3e\u91d1\u989d\u8d85\u51fa\u5f85\u8fd8\u6b3e\u91d1\u989d\uff1b");
                }
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                CreditRepayApplyReqDto creditRepayApplyReqDto = new CreditRepayApplyReqDto();
                creditRepayApplyReqDto.setName(customerRespDto.getName());
                creditRepayApplyReqDto.setOrganizationId(organizationId);
                creditRepayApplyReqDto.setEntityId(customerRespDto.getId());
                creditRepayApplyReqDto.setRefundAmount(refundAmount);
                creditRepayApplyReqDto.setApplyPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)""));
                creditRepayApplyReqDto.setAuditStatus("WAIT_AUDIT");
                CreditRepayPlansReqDto creditRepayPlansReqDto = new CreditRepayPlansReqDto();
                creditRepayPlansReqDto.setId(creditRepayPlanRespDto.getId());
                creditRepayPlansReqDto.setThisRefundAmount(refundAmount);
                creditRepayApplyReqDto.setCreditRepayPlans((List)Lists.newArrayList((Object[])new CreditRepayPlansReqDto[]{creditRepayPlansReqDto}));
                creditRepayApplyReqDtos.add(creditRepayApplyReqDto);
                continue;
            }
            repayApplyImportReqDto.setErrorMsg(sb.toString());
            errorList.add(repayApplyImportReqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)creditRepayApplyReqDtos)) {
            RestResponseHelper.extractData((RestResponse)this.creditRepayPlanImportApi.batchImportRepayApplys((List)creditRepayApplyReqDtos));
        }
    }
}

