/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.export.biz.impl.operation;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportInfoReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.BaseImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeAccountDefinedParamDto;
import com.dtyunxi.tcbj.module.export.biz.dto.request.ExchangeAccountImportReqDto;
import com.dtyunxi.tcbj.module.export.biz.impl.ImportService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.demo.center.promotion.api.IActivityImportApi;
import com.yx.demo.center.promotion.api.dto.request.ExchangeAccountImportInfoReqDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="exchangeActivityAccountService")
public class ExchangeActivityAccountService
extends ImportService {
    private static final String ACTIVITY_ID = "activityId";
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IActivityImportApi activityImportApi;

    @Override
    public void definedImport(BaseDefinedParamDto baseDefinedParamDto, Object list, List<BaseImportInfoReqDto> errorList, Set<String> singleCustomerCodes) {
        ExchangeAccountDefinedParamDto paramDto = (ExchangeAccountDefinedParamDto)baseDefinedParamDto;
        Long organizationId = paramDto.getOrganizationId();
        Long activityId = paramDto.getActivityId();
        ActivityRespDto activityRespDto = (ActivityRespDto)RestResponseHelper.extractData((RestResponse)this.activityQueryApi.queryActivityDetail(activityId.longValue()));
        if (activityRespDto == null) {
            throw new BizException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        List exchangeAccountImportReqDtos = (List)list;
        List customerCodes = exchangeAccountImportReqDtos.stream().map(ExchangeAccountImportReqDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodes)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(customerCodes));
            customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
        }
        ArrayList balanceAccountReqDtos = Lists.newArrayList();
        for (ExchangeAccountImportReqDto exchangeAccountImportReqDto : exchangeAccountImportReqDtos) {
            StringBuilder sb = new StringBuilder(80);
            if (StringUtils.isEmpty((CharSequence)exchangeAccountImportReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if (!singleCustomerCodes.add(exchangeAccountImportReqDto.getCustomerCode())) {
                sb.append("\u5bfc\u5165\u5ba2\u6237\u7f16\u53f7\u91cd\u590d\uff1b");
            }
            BigDecimal avaBalance = super.tryConverBigDecimalAndCheckScale(sb, exchangeAccountImportReqDto.getAvailableBalance(), "\u5269\u4f59\u989d\u5ea6", DEF_SCALE, true, false);
            BigDecimal usedBalance = super.tryConverBigDecimalAndCheckScale(sb, exchangeAccountImportReqDto.getUsedBalance(), "\u5df2\u7528\u989d\u5ea6", DEF_SCALE, true, false);
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(exchangeAccountImportReqDto.getCustomerCode());
            if (customerRespDto == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtils.isBlank((CharSequence)sb.toString())) {
                ExchangeBalanceAccountReqDto balanceAccountReqDto = new ExchangeBalanceAccountReqDto();
                balanceAccountReqDto.setActivityId(activityId);
                balanceAccountReqDto.setCustomerId(customerRespDto.getId());
                balanceAccountReqDto.setCustomerCode(customerRespDto.getCode());
                balanceAccountReqDto.setCustomerName(customerRespDto.getName());
                balanceAccountReqDto.setAvailableBalance(avaBalance);
                balanceAccountReqDto.setUsedBalance(usedBalance);
                balanceAccountReqDto.setOrganizationId(organizationId);
                balanceAccountReqDtos.add(balanceAccountReqDto);
                continue;
            }
            exchangeAccountImportReqDto.setErrorMsg(sb.toString());
            errorList.add(exchangeAccountImportReqDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)balanceAccountReqDtos)) {
            ExchangeAccountImportInfoReqDto exchangeAccountImportInfoReqDto = new ExchangeAccountImportInfoReqDto();
            exchangeAccountImportInfoReqDto.setActivityId(activityId);
            exchangeAccountImportInfoReqDto.setBalanceAccountReqDtos((List)balanceAccountReqDtos);
            RestResponseHelper.extractData((RestResponse)this.activityImportApi.batchImportExchangeAccount(exchangeAccountImportInfoReqDto));
        }
    }

    @Override
    protected BaseDefinedParamDto converParamDto(BaseImportReqDto baseImportReqDto) {
        ExchangeAccountDefinedParamDto baseDefinedParamDto = new ExchangeAccountDefinedParamDto();
        baseDefinedParamDto.setOrganizationId(baseImportReqDto.getOrganizationId());
        Map<String, Object> businessDefineParam = baseImportReqDto.getBusinessDefineParam();
        Object obj = businessDefineParam.get(ACTIVITY_ID);
        if (obj == null || !StringUtils.isNumeric((CharSequence)obj.toString())) {
            throw new BizException("\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u521d\u59cb\u5316\u5bfc\u5165\uff0c\u6d3b\u52a8id\u5165\u53c2\u9519\u8bef");
        }
        baseDefinedParamDto.setActivityId(Long.valueOf(obj.toString()));
        return baseDefinedParamDto;
    }
}

