/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.module.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.mj.biz.commons.utils.EasyPoiExportUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.settlement.api.ISettlementAccountApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettleAccBindCardStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.DepositBalanceReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountBindCardReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountFlowParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRegisterRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlementAccountBindCardQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlementAccountFlowQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.query.ISettlementAccountQueryApi;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.AccountFlowParamReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.BizWithdrawReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.SettlementAccountFlowPageRespDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.SettlementBalanceExportReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.dto.request.SettlementRouteBalanceExportReqDto;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountRegisterRelationService;
import com.dtyunxi.tcbj.module.settlement.biz.service.SettlementAccountService;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class SettlementAccountServiceImpl
implements SettlementAccountService {
    private static final Logger logger = LoggerFactory.getLogger(SettlementAccountServiceImpl.class);
    @Resource
    private SettlementAccountRegisterRelationService accountRegisterRelationService;
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ISettlementAccountQueryApi settlementAccountQueryApi;
    @Resource
    private ISettlementAccountFlowQueryApi settlementAccountFlowQueryApi;
    @Resource
    private ISettlementAccountBindCardQueryApi settlementAccountBindCardQueryApi;
    @Resource
    private ISettlementAccountApi accountApi;

    @Override
    public RestResponse<SettlementAccountRespDto> queryCurrent(String cusId, String orgId) {
        SettlementAccountRegisterRespDto accountRegisterRespDto = null;
        accountRegisterRespDto = ObjectUtils.isNotEmpty((Object)cusId) || ObjectUtils.isNotEmpty((Object)orgId) ? (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.accountRegisterRelationService.queryRegiAccForSwitch(cusId, orgId)) : (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.accountRegisterRelationService.queryRegiAccByCusIdOrOrgId());
        if (ObjectUtils.isEmpty((Object)accountRegisterRespDto) || StringUtils.isEmpty((CharSequence)accountRegisterRespDto.getAccountNo())) {
            return new RestResponse(null);
        }
        RestResponse accountResponse = this.settlementAccountQueryApi.queryByAccountNo(accountRegisterRespDto.getAccountNo());
        SettlementAccountBindCardReqDto reqDto = new SettlementAccountBindCardReqDto();
        reqDto.setAccountNo(((SettlementAccountRespDto)accountResponse.getData()).getAccountNo());
        reqDto.setBindStatus(SettleAccBindCardStatusEnum.SUCCESS.getCode());
        List bindCardList = (List)RestResponseHelper.extractData((RestResponse)this.settlementAccountBindCardQueryApi.queryListByAccount(reqDto));
        ((SettlementAccountRespDto)accountResponse.getData()).setBindCardList(bindCardList);
        return accountResponse;
    }

    @Override
    public RestResponse<SettlementAccountFlowPageRespDto> queryPageRecord(AccountFlowParamReqDto dto) {
        SettlementAccountRegisterRespDto currentAccountRegister = null;
        currentAccountRegister = dto.getRelationId() != null ? (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.accountRegisterRelationService.queryById(dto.getRelationId())) : (ObjectUtils.isNotEmpty((Object)dto.getCusId()) || ObjectUtils.isNotEmpty((Object)dto.getOrgId()) ? (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.accountRegisterRelationService.queryRegiAccForSwitch(dto.getCusId(), dto.getOrgId())) : (SettlementAccountRegisterRespDto)RestResponseHelper.extractData(this.accountRegisterRelationService.queryRegiAccByCusIdOrOrgId()));
        if (ObjectUtils.isEmpty((Object)currentAccountRegister) || StringUtils.isEmpty((CharSequence)currentAccountRegister.getAccountNo())) {
            return new RestResponse(null);
        }
        SettlementAccountFlowParamReqDto paramReqDto = new SettlementAccountFlowParamReqDto();
        CubeBeanUtils.copyProperties((Object)paramReqDto, (Object)((Object)dto), (String[])new String[0]);
        paramReqDto.setAccountNo(currentAccountRegister.getAccountNo());
        RestResponse pageInfoRestResponse = this.settlementAccountFlowQueryApi.queryPageByAccount(paramReqDto);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        resMap.put("pageInfo", pageInfoRestResponse.getData());
        SettlementAccountFlowPageRespDto respDto = new SettlementAccountFlowPageRespDto();
        respDto.setPageInfo((PageInfo<SettlementAccountFlowRespDto>)((PageInfo)pageInfoRestResponse.getData()));
        BigDecimal incomeAmount = BigDecimal.ZERO;
        BigDecimal expendAmount = BigDecimal.ZERO;
        if (ObjectUtils.isNotEmpty((Object)pageInfoRestResponse.getData()) && CollectionUtil.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
            for (SettlementAccountFlowRespDto flow : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                if (flow.getChangeType().equals(SettlementAccountFlowChangeTypeEnum.INCOME.getCode())) {
                    incomeAmount = incomeAmount.add(flow.getChangeBalance());
                }
                if (flow.getChangeType().equals(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode())) {
                    expendAmount = expendAmount.add(flow.getChangeBalance());
                }
                if (flow.getChangeBalanceType().equals(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode())) {
                    if (flow.getChangeType().equals(SettlementAccountFlowChangeTypeEnum.INCOME.getCode())) {
                        flow.setBeforeBalance(flow.getAfterBalance().subtract(flow.getChangeBalance()));
                    } else {
                        flow.setBeforeBalance(flow.getAfterBalance().add(flow.getChangeBalance()));
                    }
                    flow.setBeforeRouteBalance(flow.getAfterRouteBalance());
                    continue;
                }
                if (flow.getChangeType().equals(SettlementAccountFlowChangeTypeEnum.INCOME.getCode())) {
                    flow.setBeforeRouteBalance(flow.getAfterRouteBalance().subtract(flow.getChangeBalance()));
                } else {
                    flow.setBeforeRouteBalance(flow.getAfterRouteBalance().add(flow.getChangeBalance()));
                }
                flow.setBeforeBalance(flow.getAfterBalance());
            }
        }
        respDto.setIncomeAmount(incomeAmount);
        respDto.setExpendAmount(expendAmount);
        return new RestResponse((Object)respDto);
    }

    @Override
    public RestResponse<Object> exportRecord(AccountFlowParamReqDto dto) {
        String exportUrl;
        dto.setPageSize(200000);
        SettlementAccountFlowPageRespDto settlementAccountFlowPageRespDto = (SettlementAccountFlowPageRespDto)RestResponseHelper.extractData(this.queryPageRecord(dto));
        List list = Optional.ofNullable(settlementAccountFlowPageRespDto).orElse(new SettlementAccountFlowPageRespDto()).getPageInfo().getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new RestResponse("-1", "\u5bfc\u51fa\u7ed3\u7b97\u8d26\u6237\u4f59\u989d\u53d8\u66f4\u6d41\u6c34,\u6570\u636e\u4e3a\u7a7a", null);
        }
        String excelName = "cube/\u7ed3\u7b97\u8d26\u6237\u4f59\u989d\u53d8\u66f4\u6d41\u6c34_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        try {
            if (SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode().equals(dto.getChangeBalanceType())) {
                List settlementBalanceExportReqDtos = list.parallelStream().map(settlementAccountFlowRespDto -> {
                    SettlementBalanceExportReqDto settlementBalanceExportReqDto = new SettlementBalanceExportReqDto();
                    settlementBalanceExportReqDto.setAfterBalance(settlementAccountFlowRespDto.getAfterBalance());
                    settlementBalanceExportReqDto.setBeforeBalance(settlementAccountFlowRespDto.getBeforeBalance());
                    settlementBalanceExportReqDto.setOptTradeNo(settlementAccountFlowRespDto.getOptTradeNo());
                    settlementBalanceExportReqDto.setChangeBalance(settlementAccountFlowRespDto.getChangeBalance());
                    settlementBalanceExportReqDto.setAccountFlowNo(settlementAccountFlowRespDto.getAccountFlowNo());
                    settlementBalanceExportReqDto.setAccountFlowType(settlementAccountFlowRespDto.getAccountFlowTypeStr());
                    String changeTime = DateUtil.getDateFormat((Date)settlementAccountFlowRespDto.getChangeTime(), (String)"yyyy-MM-dd HH:mm:ss");
                    settlementBalanceExportReqDto.setChangeTime(changeTime);
                    settlementBalanceExportReqDto.setChangeTypeStr(settlementAccountFlowRespDto.getChangeTypeStr());
                    return settlementBalanceExportReqDto;
                }).collect(Collectors.toList());
                exportUrl = EasyPoiExportUtil.getExportUrl(settlementBalanceExportReqDtos, SettlementBalanceExportReqDto.class, null, (String)excelName, (String)"xls");
            } else {
                List settlementRouteBalanceExportReqDtos = list.parallelStream().map(settlementAccountFlowRespDto -> {
                    SettlementRouteBalanceExportReqDto settlementRouteBalanceExportReqDto = new SettlementRouteBalanceExportReqDto();
                    settlementRouteBalanceExportReqDto.setOptTradeNo(settlementAccountFlowRespDto.getOptTradeNo());
                    settlementRouteBalanceExportReqDto.setBeforeRouteBalance(settlementAccountFlowRespDto.getBeforeRouteBalance());
                    settlementRouteBalanceExportReqDto.setAfterRouteBalance(settlementAccountFlowRespDto.getAfterRouteBalance());
                    settlementRouteBalanceExportReqDto.setChangeBalance(settlementAccountFlowRespDto.getChangeBalance());
                    settlementRouteBalanceExportReqDto.setAccountFlowNo(settlementAccountFlowRespDto.getAccountFlowNo());
                    settlementRouteBalanceExportReqDto.setAccountFlowType(settlementAccountFlowRespDto.getAccountFlowTypeStr());
                    String changeTime = DateUtil.getDateFormat((Date)settlementAccountFlowRespDto.getChangeTime(), (String)"yyyy-MM-dd HH:mm:ss");
                    settlementRouteBalanceExportReqDto.setChangeTime(changeTime);
                    settlementRouteBalanceExportReqDto.setChangeTypeStr(settlementAccountFlowRespDto.getChangeTypeStr());
                    return settlementRouteBalanceExportReqDto;
                }).collect(Collectors.toList());
                exportUrl = EasyPoiExportUtil.getExportUrl(settlementRouteBalanceExportReqDtos, SettlementRouteBalanceExportReqDto.class, null, (String)excelName, (String)"xls");
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u7ed3\u7b97\u8d26\u6237\u4f59\u989d\u53d8\u66f4\u6d41\u6c34-\u9519\u8bef", (Throwable)e);
            throw e;
        }
        return new RestResponse("0", "\u5bfc\u51fa\u7ed3\u7b97\u8d26\u6237\u4f59\u989d\u53d8\u66f4\u6d41\u6c34\u6210\u529f", (Object)exportUrl);
    }

    @Override
    public RestResponse<String> depositBalance(@RequestBody BizWithdrawReqDto withdrawReqDto) {
        RestResponse currentUserOrgIdResp = this.customerExtQueryApi.queryCurrentUserOrgId();
        logger.info("\u3010\u63d0\u73b0\u3011\u63d0\u73b0\u8d26\u53f7\u4e3a\uff1a{},\u63d0\u73b0\u91d1\u989d\u4e3a\uff1a{}", (Object)withdrawReqDto.getAccountNo(), (Object)withdrawReqDto.getBalance());
        DepositBalanceReqDto reqDto = new DepositBalanceReqDto();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)currentUserOrgIdResp);
        reqDto.setOrgId(orgId);
        reqDto.setBindCardId(withdrawReqDto.getBindCardId());
        reqDto.setUserPassword(withdrawReqDto.getUserPassword());
        reqDto.setBalance(withdrawReqDto.getBalance());
        reqDto.setAccountNo(withdrawReqDto.getAccountNo());
        return this.accountApi.depositBalance(reqDto);
    }

    @Override
    public RestResponse<SettlementAccountFlowRespDto> queryDetail(Long id) {
        SettlementAccountFlowReqDto param = new SettlementAccountFlowReqDto();
        param.setId(id);
        return this.settlementAccountFlowQueryApi.queryDetail(param);
    }

    @Override
    public RestResponse<Void> modifyPoundageAgency(Long id, Integer poundageAgency) {
        return this.accountApi.modifyPoundageAgency(id, poundageAgency);
    }
}

