package com.dtyunxi.cube.biz.commons.constants;

/**
 * MQ常量类
 * @author diyun
 * @since 1.0.0
 */
public interface MqConstants {

    /**
     * 交易同步主题
     */
    String IMK_TRADE_SYNC_TOPIC = "IMK_TRADE_SYNC";

    /**
     * 交易同步消息
     */
    String IMK_TRADE_SYNC_TAG = "IMK_TRADE_SYNC_TAG";


    /**
     * 促销活动启用消息
     */
    String ACTIVITY_SYNC_ENABLE_TAG = "ACTIVITY_SYNC_ENABLE_TAG";


    /**
     * 促销活动禁用消息
     */
    String ACTIVITY_SYNC_DISABLE_TAG = "ACTIVITY_SYNC_DISABLE_TAG";

    /**
     * 外围接口会员等级变更
     */
    String BESTORE_MEMBER_LEVEL_UPDATE = "BESTORE_MEMBER_LEVEL_UPDATE_SYNC_TAG";

    /**
     * 外围接口积分变更
     */
    String BESTORE_MEMBER_POINT_UPDATE = "BESTORE_MEMBER_POINT_UPDATE_SYNC_TAG";

    /**
     * 外围接口余额变更
     */
    String BESTORE_MEMBER_BALANCE_UPDATE = "BESTORE_MEMBER_BALANCE_UPDATE_SYNC_TAG";

    /**
     * 推送消息（积分变动、充值提醒、消费提醒、入会通知）到支付宝服务窗
     */
    String MEMBER_ALIPAY_LIVE_UPDATE = "MEMBER_ALIPAY_LIVE_UPDATE_SYNC_TAG";

    /**
     * 等级营销
     */
    String MARKETING_LEVEL_TAG = "marketing_level_tag";


    /**
     * 京东微信等级变更TOPIC
     */
    String JD_WECHAT_LEVEL_UPDATE_SYNC_TOPIC = "JD_WECHAT_LEVEL_UPDATE_SYNC_TOPIC ";

    /**
     * 京东微信等级变更TAG
     */
    String JD_WECHAT_LEVEL_UPDATE_SYNC_TAG= "JD_WECHAT_LEVEL_UPDATE_SYNC_TAG";

    /**
     * 初始化新礼品卡帐户Tag
     */
    String GIFT_CARD_INIT_NEW_ACCOUNT_TAG = "GIFT_CARD_INIT_NEW_ACCOUNT_TAG";

    /**
     * 重新计算礼品卡帐户Tag
     */
    String GIFT_CARD_RECALCULATE_ACCOUNT_TAG = "GIFT_CARD_RECALCULATE_ACCOUNT_TAG";

    /**
     * 推送消息（注册）到OneId
     */
    String MEMBER_ONEID_REGISTER = "MEMBER_REGISTER_ONEID_TAG";

    /**
     * 推送消息（会员手机修改）到用户中心
     */
    String MEMBER_PHONE_TAG = "MEMBER_PHONE_TAG";

    String MEMBER_ONEID_CANCEL = "MEMBER_CANCEL_ONEID_TAG";

    /**
     * 等级初始化触发TAG
     */
    String LEVEL_INIT_TRIGGER_TAG = "LEVEL_INIT_TRIGGER_TAG";

    /**
     * 等级初始化触发TOPIC
     */
    String LEVEL_INIT_TRIGGER_TOPIC = "LEVEL_INIT_TRIGGER_TOPIC";

    /***
     * 等级初始化插入表记录tag
     */
    String INSERT_LEVEL_LOG_TAG = "INSERT_LEVEL_LOG_TAG";

    /**
     * 等级初始化推送第三方mq tag
     */
    String LEVEL_INIT_PUSH_THIRD_TAG = "LEVEL_INIT_PUSH_THIRD_TAG";

    String POINT_CLEAN_MAIN_TOPIC = "POINT_CLEAN_MAIN_TOPIC";

    String POINT_CLEAN_FINAL_TOPIC = "POINT_CLEAN_FINAL_TOPIC";

    String REBUILD_WAIT_POINT_MAIN_TOPIC = "REBUILD_WAIT_POINT_MAIN_TOPIC";

    String REBUILD_WAIT_POINT_FIANL_TOPIC = "REBUILD_WAIT_POINT_FIANL_TOPIC";

    String WECHAT_APPLET_REGISTER_TOPIC = "WECHAT_APPLET_REGISTER_TOPIC";

}
