package com.dtyunxi.cube.biz.commons.dto.event;

import com.dtyunxi.cube.biz.commons.annotation.ClassDesc;
import com.dtyunxi.cube.biz.commons.annotation.PropertyDesc;
import com.dtyunxi.util.DateUtil;

import java.io.Serializable;
import java.util.UUID;

@ClassDesc(value = "EventMarketingExecDto", description = "事件营销执行参数")
public class EventMarketingExecDto extends MarketingExecReqDto {

    private static final long serialVersionUID = -4161948040984784920L;

    public EventMarketingExecDto() {
        this.setUuid(UUID.randomUUID().toString().replace("-",""));
    }

    @PropertyDesc(value = "事件触发店铺id(是us_organization表的主键id，不是那个shop_id字段)【" +
            "1、消费店铺：消费获得积分、使用积分、卡储值使用、礼品卡使用、券使用、订单状态、退换货提醒、门店消费完成提醒\n" +
            "2、注册店铺：注册完成\n" +
            "3、行为发生店铺：行为获得积分、卡储值到账、礼品卡绑定】",notes = "事件营销需指定")
    private Long shopId;

    @PropertyDesc(value = "事件触发店铺编码，没有shopId的传shopCode【" +
            "1、消费店铺：消费获得积分、使用积分、卡储值使用、礼品卡使用、券使用、订单状态、退换货提醒、门店消费完成提醒\n" +
            "2、注册店铺：注册完成\n" +
            "3、行为发生店铺：行为获得积分、卡储值到账、礼品卡绑定】",notes = "事件营销需指定")
    private String shopCode;

    @PropertyDesc(value = "是否线上店铺触发【线上店铺：true   线下店铺：false】")
    private Boolean online;

    @PropertyDesc(value = "默认0，事件触发的差值天数，triggerType=1时表示触发前X天，triggerType=2表示触发后X天")
    private Integer subDay = 0;

    @PropertyDesc(value = "营销时间触发类型（0：触发时 1：触发前X天 2：触发后X天）")
    private Integer triggerType = 0;

    @PropertyDesc(value = "指定时间点")
    private String time;

    @PropertyDesc(value = "触发事件当时的系统时间")
    private String currentTime;

    @PropertyDesc(value = "事件数据，用于确定事件营销是否满足执行条件或者消息推送时的消息内容替换",notes = "事件营销需指定")
    private EventData eventData;

    @ClassDesc(value = "EventData", description = "各种事件进行满足执行条件校验的必要数据")
    public static class EventData implements Serializable {

        @PropertyDesc(value = "事件码(根据事件取营销中心数据库的mk_event的code字段)")
        private String eventCode;

        @PropertyDesc("等级数据")
        private LevelEventDataDto level;

        @PropertyDesc("权益数据")
        private RightEventDataDto right;

        @PropertyDesc("积分数据")
        private PointEventDataDto point;

        @PropertyDesc("卡数据")
        private CardEventDataDto card;

        @PropertyDesc("优惠券数据")
        private CouponEventDataDto coupon;

        @PropertyDesc("标签数据")
        private LabelEventDataDto label;

        public String getEventCode() {
            return eventCode;
        }

        public void setEventCode(String eventCode) {
            this.eventCode = eventCode;
        }

        public LevelEventDataDto getLevel() {
            return level;
        }

        public void setLevel(LevelEventDataDto level) {
            this.level = level;
        }

        public RightEventDataDto getRight() {
            return right;
        }

        public void setRight(RightEventDataDto right) {
            this.right = right;
        }

        public PointEventDataDto getPoint() {
            return point;
        }

        public void setPoint(PointEventDataDto point) {
            this.point = point;
        }

        public CardEventDataDto getCard() {
            return card;
        }

        public void setCard(CardEventDataDto card) {
            this.card = card;
        }

        public CouponEventDataDto getCoupon() {
            return coupon;
        }

        public void setCoupon(CouponEventDataDto coupon) {
            this.coupon = coupon;
        }

        public LabelEventDataDto getLabel() {
            return label;
        }

        public void setLabel(LabelEventDataDto label) {
            this.label = label;
        }
    }

    public EventData getEventData() {
        return eventData == null?new EventData():eventData;
    }

    public void setEventData(EventData eventData) {
        this.eventData = eventData;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Boolean isOnline() {
        return online;
    }

    public Boolean getOnline() {
        return online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public Integer getSubDay() {
        return subDay;
    }

    public void setSubDay(Integer subDay) {
        this.subDay = subDay;
    }

    public Integer getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(Integer triggerType) {
        this.triggerType = triggerType;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public String getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(String currentTime) {
        this.currentTime = currentTime;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 初始化触发参数对象：必要参数
     * @author : 萧玄
     * @Date   : 17:04 2019/8/2
     * @param eventCode
     * @param memberId
     * @return : com.dtyunxi.yundt.cube.biz.marketing.api.dto.request.event.EventMarketingExecDto
     */
    public static EventMarketingExecDto init(String eventCode,Long memberId){
        EventMarketingExecDto eventMarketingExecDto = new EventMarketingExecDto();
        eventMarketingExecDto.setMemberId(memberId);

        EventData eventData = new EventData();
        eventData.setEventCode(eventCode);
        eventMarketingExecDto.setEventData(eventData);
        eventMarketingExecDto.currentTime = DateUtil.getCurrenDate();

        return eventMarketingExecDto;
    }

}
