package com.dtyunxi.cube.biz.commons.dto.event;

import com.dtyunxi.cube.biz.commons.annotation.ClassDesc;
import com.dtyunxi.cube.biz.commons.annotation.PropertyDesc;

import java.io.Serializable;
import java.math.BigDecimal;

@ClassDesc(value = "LevelEventDataDto", description = "等级事件数据")
public class LevelEventDataDto implements Serializable {

    @PropertyDesc("等级id")
    private Long id;

    @PropertyDesc("等级名称")
    private String name;

    @PropertyDesc("近365天累计消费总额")
    private BigDecimal recentlyConsumption;

    @PropertyDesc("差X元升级")
    private BigDecimal amount4LevelUp;

    @PropertyDesc("等级距离到期还剩的天数")
    private int day;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getRecentlyConsumption() {
        return recentlyConsumption;
    }

    public void setRecentlyConsumption(BigDecimal recentlyConsumption) {
        this.recentlyConsumption = recentlyConsumption;
    }

    public int getDay() {
        return day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public BigDecimal getAmount4LevelUp() {
        return amount4LevelUp;
    }

    public void setAmount4LevelUp(BigDecimal amount4LevelUp) {
        this.amount4LevelUp = amount4LevelUp;
    }
}
