package com.dtyunxi.cube.biz.commons.dto.level;

import com.dtyunxi.cube.biz.commons.annotation.ClassDesc;
import com.dtyunxi.cube.biz.commons.annotation.PropertyDesc;
import com.dtyunxi.vo.BaseVo;

import java.util.List;
import java.util.UUID;

/**
 * 等级初始化触发参数
 * @author : 萧玄
 * @Date: 15:53 2019/10/11
 */
@ClassDesc(value = "LevelInitTriggerDto", description = "等级初始化触发参数")
public class LevelInitTriggerDto extends BaseVo {

    @PropertyDesc(value = "批次号")
    private String batchNo;

    @PropertyDesc(value = "等级初始化id")
    private Long taskInitId;

    @PropertyDesc(value = "需要初始化的等级id集合")
    private List<Long> levelIds;

    @PropertyDesc(value = "序执行步骤自动还是手动调用[true 自动 false 手动]")
    private boolean autoInvoke;

    public String getBatchNo() {
        return batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public List<Long> getLevelIds() {
        return levelIds;
    }

    public void setLevelIds(List<Long> levelIds) {
        this.levelIds = levelIds;
    }

    public boolean isAutoInvoke() {
        return autoInvoke;
    }

    public void setAutoInvoke(boolean autoInvoke) {
        this.autoInvoke = autoInvoke;
    }

    public Long getTaskInitId() {
        return taskInitId;
    }

    public void setTaskInitId(Long taskInitId) {
        this.taskInitId = taskInitId;
    }

    public LevelInitTriggerDto(Long taskInitId, List<Long> levelIds, boolean autoInvoke) {
        this.taskInitId = taskInitId;
        this.batchNo = UUID.randomUUID().toString().replace("-","");
        this.levelIds = levelIds;
        this.autoInvoke = autoInvoke;
    }

}
