package com.dtyunxi.cube.biz.commons.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 注册来源
 * create By qiudao on 2019/7/24
 */
public enum BestoreRegisterSource {

    /**
     *
     */
    CRM("crm", "crm", "ZCM004", "crm"),
    H5("h5", "h5活动", "ZCM999", "h5活动"),
    APP("app", "app", "ZCM109", "app"),
    WXZF("wxzf", "微信支付", "ZCM103", "微信"),
    HY("hyxcx", "领取优惠券注册", "ZCM038", "微信"),
    WXHYK("wxhyk", "一店一码小程序注册", "ZCM110", "微信"),
    YDYM("ydym", "一店一码微信授权", "ZCM007", "微信"),
    WECHAT_PLATFORM("wechat", "微信公众号粉丝授权", "ZCM005", "微信"),
    ZFBXCX("zfbxcx", "支付宝小程序", "ZCM102", "支付宝"),
    ZFBSHH("zfbshh", "支付宝生活号", "ZCM101", "支付宝"),
    TAOBAO("taobao", "淘宝", "ZCM008", "线上电商"),
    TMQJ("tmqj", "天猫", "ZCM006", "线上电商"),
    JDQJ("jdqj", "京东", "ZCM009", "线上电商"),
    YZ("yz", "有赞", "ZCM014", "线上电商"),
    SUNING("suning", "苏宁", "ZCM013", "线上电商"),
    YHD("yhd", "1号店", "ZCM010", "线上电商"),
    WEIDIAN("weidian", "微店", "ZCM105", "线上电商"),
    MTHY("mt", "美团", "ZCM108", "线下门店"),
    ELE("ele", "饿了么", "ZCM104", "线下门店"),
    MICRO_DISTRIBUTION("md", "微分销", "ZCM106", "外卖平台"),
    GROUP_BUY("groupbuy", "团购", "ZCM107", "外卖平台"),
    POS("pos", "pos", "ZCM011", "分销分润"),
    ASMDC("asmdc", "扫码点单", "ZCM012", "分销分润");

    private String code;
    private String name;
    private String channelCode;
    private String channelName;

    public static Map<String, BestoreRegisterSource> codeMap = new HashMap<>();
    public static Map<String, BestoreRegisterSource> channelCodeMap = new HashMap<>();

    static {
        BestoreRegisterSource[] datas = BestoreRegisterSource.values();
        for (BestoreRegisterSource data : datas) {
            codeMap.put(data.code, data);
            channelCodeMap.put(data.channelCode, data);
        }
    }

    BestoreRegisterSource(String code, String name, String channelCode, String channelName) {
        this.code = code;
        this.name = name;
        this.channelCode = channelCode;
        this.channelName = channelName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public static List<BestoreRegisterSource> getSourceList(String channelName) {
        return Arrays.stream(BestoreRegisterSource.values()).filter(source ->
                source.getChannelName().equals(channelName)).collect(Collectors.toList());
    }
}
