package com.dtyunxi.cube.biz.commons.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 店铺渠道枚举类
 * @author diyun
 * @date 2019/8/1
 */
public enum BestoreShopChannel {

    /**
     * 店铺渠道
     */
    STORE("store","门店","3001"),
    APP("app","APP商城","1149"),
    YZ("yz","有赞","1028"),
    JDQJ("jdqj","京东","1001"),
    TM("tm","天猫","1006"),
    WECHAT("wechat","微信","1149"),
    SELF_WM("wmxcx","自营外卖","1101"),
    THIRD_WM("thirdwm","第三方外卖","1102,1103,1104,1105,1138,1150,1186,1197"),
    OTHER("other","其他线上","3000");


    private String code;
    private String name;
    private String shopCode;

    BestoreShopChannel(String code, String name,String shopCode) {
        this.code = code;
        this.name = name;
        this.shopCode = shopCode;
    }

    public String getCode() {
        return code;
    }


    public String getName() {
        return name;
    }

    public String getShopCode() {
        return shopCode;
    }

    public static BestoreShopChannel getByCode(String code) {
        if(StringUtils.isBlank(code)) {
            return OTHER;
        }
        BestoreShopChannel[] datas = BestoreShopChannel.values();
        for(BestoreShopChannel data: datas) {
            if(code.equals(data.getCode())) {
                return data;
            }
        }
        return OTHER;
    }

    public static BestoreShopChannel getByShopCode(String shopCode) {
        if(StringUtils.isBlank(shopCode)) {
            return OTHER;
        }
        try {
            if(Integer.parseInt(shopCode) > 3000){
                return STORE;
            }else{
                BestoreShopChannel[] datas = BestoreShopChannel.values();
                for(BestoreShopChannel data: datas) {
                    if(shopCode.equals(data.getShopCode()) || data.getShopCode().contains(shopCode)) {
                        return data;
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return OTHER;
    }
}
