/*
 * *
 *  @(#)ErrorCodeEnum.java 1.0 19-6-21 下午4:51
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * /
 */

package com.dtyunxi.cube.biz.commons.enums;

public enum ErrorCodeEnum {
    MEMBER_NOT_EXIST("E0004","会员中心判断账户状态异常或者剩余账户余额不足"),
    GIFT_CARD_ERROR("M0101","礼品卡状态异常"),
    GIFT_CARD_BALANCE_LOW("M0102","礼品卡余额不足"),
    GIFT_CARD_ACCOUNT_ERROR("M0103","会员礼品卡账户不存在"),
    GIFT_CARD_ACCOUNT_BALANCE_LOW("M0104","会员礼品卡账户余额不足"),
    GIFT_CARD_FLOW_NOT_EXIST("M0105","礼品卡账户流水不存在"),

    IMPROPER_PARAMETER("M0001","参数不合法"),
    MISSING_PARAMETER("M0002","参数为空"),
    ILLEGAL_AMENDMENTS("M0003","导入数量不合法"),
    INTERNAL_SYSTEM_ERROR("M1000","系统内部错误"),
    INTERNAL_STATUS_ACTIVE("M0004","此账户未激活"),
    INTERNAL_STATUS_DISCOUNT("M0005","折扣率超过上限"),
    SELECT_STATUS_DISCOUNT("M0006","此账户状态无法被冻结/加挂"),

    MEMBER_LEVEL_INIT_TASK_NOT_FOUND("M0007","等级初始化任务不存在"),
            ;
    private final String errorCode;
    private final String errorMsg;

    ErrorCodeEnum(String errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }
}
