package com.dtyunxi.cube.biz.commons.enums;


import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消息模板变量枚举
 * @author : 萧玄
 * @Date: 14:07 2019/11/7
 */
public enum MessageTemplateVariableEnum {
    /**
     *
     */
    NAME("姓名", "&NAME&"),
    GENDER("性别", "&GENDER&"),
    LEVEL("等级", "&LEVEL&"),
    COUPON_CODE("赠送券码", "&QM&"),
    STORE_BALANCE("储值余额", "&CZYE&"),
    LEVEL_DISTANCE_EXPIRES_IN_X_DAYS("等级距离X天到期", "&XTDQ&"),
    NEED_X_YUAN_UPGRADE("差X元升级", "&XYSJ&"),
    POINTS_TO_BE_CLEARED("待清零积分", "&DQLJF&"),
    POINTS_CHANGE_AMOUNT("积分变动值", "&JFBDZ&"),
    POINTS_BALANCE("积分余额", "&JFYE&"),
    EXTERNAL_LINK("外部链接", "&WBLJ&"),
    CYCLE_TOTAL_CONSUMPTION_AMOUNT("周期累计消费金额", "&SJJE&"),
    HAPPEN_TIME("发生时间", "&TIME&"),
    COUPON_NAME("券名称", "&QMC&"),
    MEMBER_CARD_NO("会员卡号", "&HYKH&"),
    STORE_CHANGE_AMOUNT("储值变动金额", "&CZBDJE&"),
    GIFT_CARD_BALANCE("礼品卡余额", "&LPKYE&"),
    GIFT_CARD_CHANGE_AMOUNT("礼品卡变动金额", "&LPKBDJE&"),
    MEMBER_RIGHTS_NAME("权益包名称", "&QYB&"),
    MEMBER_RIGHTS_START_TIME("权益包开始时间", "&STIME&"),
    MEMBER_RIGHTS_END_TIME("权益包结束时间", "&ETIME&");

    private String key;
    private String value;

    private MessageTemplateVariableEnum(String key, String describe) {
        this.key = key;
        this.value = describe;
    }

    public static Map<String, String> getMessageTemplateVariableMap() {
        return (Map) Arrays.stream(values()).collect(Collectors.toMap(MessageTemplateVariableEnum::getKey, MessageTemplateVariableEnum::getValue));
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static void main(String[] args) {
        System.out.println(MessageTemplateVariableEnum.LEVEL.getKey());
    }
}
