package com.dtyunxi.cube.biz.commons.enums;

import java.util.HashMap;
import java.util.Map;

public enum RegisterSourceChannelEnum {

    /**
     *
     */
    CRM("crm", "crm"),
    H5("h5活动", "h5活动"),
    APP("app", "app"),
    WECHAT_PAY("微信支付", "微信"),
    WECHAT_COUPON_APPLET("微信优惠券小程序", "微信"),
    WECHAT_CARD_APPLET("微信电子会员卡小程序", "微信"),
    WECHAT_SHOP_CODE_APPLET("微信一店一码小程序", "微信"),
    WECHAT_PLATFORM("微信公众号授权", "微信"),
    ALIPAY_APPLET("支付宝小程序", "支付宝"),
    ALIPAY_LIFE("支付宝生活号", "支付宝"),
    TAOBAO("淘宝", "线上电商"),
    TMALL("天猫", "线上电商"),
    JD("京东", "线上电商"),
    YOUZAN("有赞", "线上电商"),
    SUNING("苏宁", "线上电商"),
    YHD("1号店", "线上电商"),
    WEIDIAN("微店", "线上电商"),
    MEITUAN("美团", "外卖平台"),
    ELE("饿了么", "外卖平台"),
    MICRO_DISTRIBUTION("微分销", "分销分润"),
    GROUP_BUY("团购", "分销分润"),
    POS("pos", "线下门店"),
    SCAN_CODE("扫码点单", "线下门店");

    private String source;

    private String channel;

    RegisterSourceChannelEnum(String source, String channel) {
        this.source = source;
        this.channel = channel;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    static public Map<String, RegisterSourceChannelEnum> sourceMap = new HashMap<>();

    static {
        for(RegisterSourceChannelEnum sourceChannel : RegisterSourceChannelEnum.values()) {
            sourceMap.put(sourceChannel.getSource(), sourceChannel);
        }
    }
}
