package com.dtyunxi.cube.biz.commons.utils;

import com.dtyunxi.cube.biz.commons.dto.BestoreRfcConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

/**
 * 良品rfc工具类
 * @author li.jundong
 * @date: 2019/7/25 20:19
 */
public class BestoreRfcUtils {

    private static final Logger logger = LoggerFactory.getLogger(BestoreRfcUtils.class);

    private static final String CRM_ABAP_AS_POOLED = "crm";

    private static final String APP_ABAP_AS_POOLED = "app";

    private static final String FICO_ABAP_AS_POOLED = "fico";

    private static final Map<String, BestoreRfcConfig> rfcMap = new HashMap<>();

//    /**
//     * 获取CRM-SAP连接
//     * @author li.jundong
//     * @date 2019/7/25
//     * @param
//     * @return com.sap.conn.jco.JCoDestination
//     */
//    public static JCoDestination getCrmConnect() {
//        return getJCoDestination(CRM_ABAP_AS_POOLED);
//    }
//
//    /**
//     * 获取APP-SAP连接
//     * @author li.jundong
//     * @date 2019/7/25
//     * @param
//     * @return com.sap.conn.jco.JCoDestination
//     */
//    public static JCoDestination getAppConnect() {
//        return getJCoDestination(APP_ABAP_AS_POOLED);
//    }
//
//    /**
//     * 获取FICO-SAP连接
//     * @author li.jundong
//     * @date 2019/7/25
//     * @param
//     * @return com.sap.conn.jco.JCoDestination
//     */
//    public static JCoDestination getFicoConnect() {
//        return getJCoDestination(FICO_ABAP_AS_POOLED);
//    }
//
//    private static JCoDestination getJCoDestination(String destinationName){
//        if(StringUtils.isBlank(destinationName)){
//            return null;
//        }
//        JCoDestination destination = null;
//        try {
//            destination = JCoDestinationManager.getDestination(destinationName);
//        } catch (JCoException e) {
//            logger.error("Connect SAP fault, error msg=", e.getMessage(), e);
//        }
//        return destination;
//    }

    public static void put(String key, BestoreRfcConfig bestoreRfcConfig){
        rfcMap.put(key, bestoreRfcConfig);
    }

    /**
     * 获取CRM-SAP配置
     * @author li.jundong
     * @date 2019/7/26
     * @param
     * @return com.dtyunxi.yundt.cube.biz.marketing.commons.dto.BestoreRfcConfig
     */
    public static BestoreRfcConfig getCrmConfig() {
        return rfcMap.get(CRM_ABAP_AS_POOLED);
    }

    /**
     * 获取APP-SAP配置
     * @author li.jundong
     * @date 2019/7/25
     * @param
     * @return com.sap.conn.jco.JCoDestination
     */
    public static BestoreRfcConfig getAppConfig() {
        return rfcMap.get(APP_ABAP_AS_POOLED);
    }

    /**
     * 获取FICO-SAP配置
     * @author li.jundong
     * @date 2019/7/25
     * @param
     * @return com.sap.conn.jco.JCoDestination
     */
    public static BestoreRfcConfig getFicoConfig() {
        return rfcMap.get(FICO_ABAP_AS_POOLED);
    }
}
