package com.dtyunxi.cube.biz.commons.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.biz.commons.annotation.SqlFilterProperty;
import com.dtyunxi.cube.biz.commons.enums.SqlOperator;
import org.springframework.web.util.UriUtils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 前端请求对象转中心filter字符串工具类
 * @author li.jundong
 * @date: 2019/6/24 17:53
 */
public class Object2FilterUtil {

    public static String object2FilterWithUriEncode(Object object){
       return UriUtils.encode(object2Filter(object),StandardCharsets.UTF_8);
    }

    public static String object2Filter(Object object){
        if(null == object){
            return null;
        }
        List<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
        Class clazz = object.getClass();
        Field[] fields = clazz.getDeclaredFields();
        Map<String, Object> criteria = new HashMap<String, Object>();

        for(Field field: fields){
            field.setAccessible(true);
            try {
                //获取字段名
                String property = field.getName();
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                //获取get方法
                Method method = pd.getReadMethod();
                //获取到方法的值
                Object value = method.invoke(object);
                if(value == null) {
                    continue;
                }
                String operator = null;
                String column = null;

                if (property.equals("tenantId") || property.equals("instanceId") || property.equals("orderBy")
                        || property.equals("orderByDesc")) {
                    criteria.put(property, value);
                    continue;
                }

                //获取字段注解上的操作类型
                SqlFilterProperty sqlFilterProperty = field.getAnnotation(SqlFilterProperty.class);
                if(sqlFilterProperty == null){
                    operator = SqlOperator.eq.toString();
                    //字段名=属性名
                    column = property;
                }else{
                    if(!sqlFilterProperty.ignore()){
                        operator = sqlFilterProperty.operator().toString();
                        column = sqlFilterProperty.column();
                        if(column == null || "".equals(column)){
                            column = property;
                        }
                        if (sqlFilterProperty.operator() == SqlOperator.left_like) {
                            value = "%" + value;
                        } else if (sqlFilterProperty.operator() == SqlOperator.right_like) {
                            value = value + "%";
                        } else if (sqlFilterProperty.operator() == SqlOperator.like) {
                            value = "%" + value + "%";
                        }
                    }
                }

                Map<String, Object> filter = buildFilter(column, operator, value);
                filters.add(filter);
            } catch (Exception e){
                e.printStackTrace();
            }
        }

        criteria.put("filters", filters);
        return JSON.toJSONString(criteria, SerializerFeature.WriteDateUseDateFormat);
    }

    private static Map<String, Object> buildFilter(String column, String operator, Object value) {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("property", column);
        map.put("operator", operator);
        map.put("value", value);
        return map;
    }
}
