/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.constant.OrderStatusConstant;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.AccountBillRecordReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.AccountBillRecordRespDto;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.IAccountBillRecordService;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.AccountBillRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.AccountBillRecordEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountBillEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountBillRecordServiceImpl
implements IAccountBillRecordService {
    private static Logger logger = LoggerFactory.getLogger(AccountBillRecordServiceImpl.class);
    @Resource
    private AccountBillRecordDas accountBillRecordDas;
    @Resource
    private CrAccountBillDas accountBillDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICreditAccountService creditAccountService;
    @Resource
    private ILockService lockService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addAccountBillRecord(List<AccountBillRecordReqDto> accountBillRecordReqDtos) {
        for (AccountBillRecordReqDto addReqDto : accountBillRecordReqDtos) {
            Mutex lock = null;
            try {
                CrAccountBillEo billEo;
                lock = this.lockService.lock(this.getClass().getSimpleName(), "bill::record::" + addReqDto.getBillNo(), 50, 50, TimeUnit.MILLISECONDS);
                if (lock != null) {
                    CrAccountBillEo accountBillEo = new CrAccountBillEo();
                    accountBillEo.setBillNo(addReqDto.getBillNo());
                    billEo = (CrAccountBillEo)this.accountBillDas.selectOne((BaseEo)accountBillEo);
                    BigDecimal notYetAmount = billEo.getNotYetAmount();
                    BigDecimal alreadyRepaidAmount = billEo.getAlreadyRepaidAmount();
                    BigDecimal billAmount = billEo.getBillAmount();
                    logger.info("\u5f85\u8fd8\u6b3e\u7684\u8d26\u671f\u8d26\u5355\u53f7\u4e3a[{}]\uff0c\u672a\u8fd8\u91d1\u989d\u4e3a[{}],\u7533\u8bf7\u8fd8\u6b3e\u91d1\u989d[{}]", new Object[]{addReqDto.getBillNo(), notYetAmount, addReqDto.getReturnAmount()});
                    if (addReqDto.getReturnAmount().compareTo(notYetAmount) > 0) {
                        throw new BizException("\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                    }
                    AccountBillRecordEo accountBillRecordEo = new AccountBillRecordEo();
                    DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)accountBillRecordEo);
                    Long orgId = this.creditAccountService.queryOrgIdByUserId();
                    if (ObjectUtil.isNotEmpty((Object)orgId)) {
                        accountBillRecordEo.setOrgInfoId(orgId);
                    }
                    if (ObjectUtil.isEmpty((Object)addReqDto.getOperatePerson())) {
                        accountBillRecordEo.setOperatePerson(this.context.userName());
                    }
                    this.accountBillRecordDas.insert((BaseEo)accountBillRecordEo);
                    billEo.setBillNo(addReqDto.getBillNo());
                    if (ObjectUtil.isEmpty((Object)addReqDto.getOperatePerson())) {
                        billEo.setPayBackPerson(this.context.userName());
                    } else {
                        billEo.setPayBackPerson(addReqDto.getOperatePerson());
                    }
                    billEo.setPayBackTime(addReqDto.getOperateTime());
                    if (addReqDto.getReturnAmount().compareTo(notYetAmount) >= 0) {
                        billEo.setAlreadyRepaidAmount(billAmount);
                        billEo.setNotYetAmount(BigDecimal.ZERO);
                        billEo.setStatus(OrderStatusConstant.ACCOUNT_PAID);
                    } else {
                        billEo.setAlreadyRepaidAmount(alreadyRepaidAmount.add(addReqDto.getReturnAmount()));
                        billEo.setNotYetAmount(notYetAmount.subtract(addReqDto.getReturnAmount()));
                        billEo.setStatus(OrderStatusConstant.PART_PAYMENT);
                    }
                } else {
                    throw new BizException("\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                }
                this.accountBillDas.updateSelective((BaseEo)billEo);
            }
            catch (Exception e) {
                try {
                    throw new BizException("\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(lock);
                    throw throwable;
                }
            }
            this.lockService.unlock(lock);
        }
    }

    @Override
    public void modifyAccountBillRecord(AccountBillRecordReqDto modifyReqDto) {
        AccountBillRecordEo accountBillRecordEo = new AccountBillRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)accountBillRecordEo);
        this.accountBillRecordDas.updateSelective((BaseEo)accountBillRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAccountBillRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.accountBillRecordDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AccountBillRecordRespDto queryById(Long id) {
        AccountBillRecordEo accountBillRecordEo = (AccountBillRecordEo)this.accountBillRecordDas.selectByPrimaryKey(id);
        AccountBillRecordRespDto accountBillRecordRespDto = new AccountBillRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)accountBillRecordEo, (BaseVo)accountBillRecordRespDto);
        return accountBillRecordRespDto;
    }

    @Override
    public PageInfo<AccountBillRecordRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        AccountBillRecordReqDto accountBillRecordReqDto = (AccountBillRecordReqDto)JSON.parseObject((String)filter, AccountBillRecordReqDto.class);
        AccountBillRecordEo accountBillRecordEo = new AccountBillRecordEo();
        DtoHelper.dto2Eo((BaseVo)accountBillRecordReqDto, (BaseEo)accountBillRecordEo);
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            accountBillRecordEo.setOrgInfoId(orgId);
        }
        PageInfo eoPageInfo = this.accountBillRecordDas.selectPage((BaseEo)accountBillRecordEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AccountBillRecordRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

