/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.AccountOrderLogReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.AccountOrderLogRespDto;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.IAccountOrderLogService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.AccountOrderLogDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.AccountOrderLogEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountOrderLogServiceImpl
implements IAccountOrderLogService {
    @Resource
    private AccountOrderLogDas accountOrderLogDas;

    @Override
    public Long addAccountOrderLog(AccountOrderLogReqDto addReqDto) {
        AccountOrderLogEo accountOrderLogEo = new AccountOrderLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)accountOrderLogEo);
        this.accountOrderLogDas.insert((BaseEo)accountOrderLogEo);
        return accountOrderLogEo.getId();
    }

    @Override
    public void modifyAccountOrderLog(AccountOrderLogReqDto modifyReqDto) {
        AccountOrderLogEo accountOrderLogEo = new AccountOrderLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)accountOrderLogEo);
        this.accountOrderLogDas.updateSelective((BaseEo)accountOrderLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAccountOrderLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.accountOrderLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AccountOrderLogRespDto queryById(Long id) {
        AccountOrderLogEo accountOrderLogEo = (AccountOrderLogEo)this.accountOrderLogDas.selectByPrimaryKey(id);
        AccountOrderLogRespDto accountOrderLogRespDto = new AccountOrderLogRespDto();
        DtoHelper.eo2Dto((BaseEo)accountOrderLogEo, (BaseVo)accountOrderLogRespDto);
        return accountOrderLogRespDto;
    }

    @Override
    public PageInfo<AccountOrderLogRespDto> queryByPage(AccountOrderLogReqDto reqDto, Integer pageNum, Integer pageSize) {
        AccountOrderLogEo logEo = new AccountOrderLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)logEo);
        if (ObjectUtil.isNotEmpty((Object)reqDto.getBeginTimeEnd()) && ObjectUtil.isNotEmpty((Object)reqDto.getBeginTimeStart())) {
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.ge((String)"create_time", (Object)reqDto.getBeginTimeStart()));
            sqlFilterList.add(SqlFilter.le((String)"create_time", (Object)reqDto.getBeginTimeEnd()));
            logEo.setSqlFilters(sqlFilterList);
        }
        logEo.setOrderBy("order_no");
        logEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.accountOrderLogDas.selectPage((BaseEo)logEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AccountOrderLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

