/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountBillReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.AccountBillAndOrderRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.AccountBillTotalRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountBillRespDto;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountBillService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.util.BusinessUtil;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountBillEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.util.Strings;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrAccountBillServiceImpl
implements ICrAccountBillService {
    @Resource
    private CrAccountBillDas crAccountBillDas;
    @Resource
    private CrAccountRecordDas accountRecordDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ICreditAccountService creditAccountService;

    @Override
    public Long addCrAccountBill(CrAccountBillReqDto addReqDto) {
        CrAccountBillEo crAccountBillEo = new CrAccountBillEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountBillEo);
        crAccountBillEo.setLastPayBackTime(addReqDto.getLastPayBackTime());
        crAccountBillEo.setStatementDate(addReqDto.getStatementDate());
        if (Strings.isNotEmpty((CharSequence)addReqDto.getOrgInfoId())) {
            crAccountBillEo.setOrgInfoId(Long.valueOf(Long.parseLong(addReqDto.getOrgInfoId())));
        }
        this.crAccountBillDas.insert((BaseEo)crAccountBillEo);
        return crAccountBillEo.getId();
    }

    @Override
    public void modifyCrAccountBill(CrAccountBillReqDto modifyReqDto) {
        CrAccountBillEo crAccountBillEo = new CrAccountBillEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)crAccountBillEo);
        this.crAccountBillDas.updateSelective((BaseEo)crAccountBillEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCrAccountBill(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.crAccountBillDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CrAccountBillRespDto queryById(Long id) {
        CrAccountBillEo crAccountBillEo = (CrAccountBillEo)this.crAccountBillDas.selectByPrimaryKey(id);
        CrAccountBillRespDto crAccountBillRespDto = new CrAccountBillRespDto();
        DtoHelper.eo2Dto((BaseEo)crAccountBillEo, (BaseVo)crAccountBillRespDto);
        BusinessUtil.checkExpireStatus(crAccountBillRespDto);
        return crAccountBillRespDto;
    }

    @Override
    public PageInfo<CrAccountBillRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CrAccountBillReqDto crAccountBillReqDto = (CrAccountBillReqDto)JSON.parseObject((String)filter, CrAccountBillReqDto.class);
        if (ObjectUtil.isNotEmpty((Object)crAccountBillReqDto.getOrgInfoId())) {
            ArrayList<Long> orgIds = new ArrayList<Long>();
            orgIds.add(Long.valueOf(crAccountBillReqDto.getOrgInfoId()));
            List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(orgIds).getData();
            crAccountBillReqDto.setCustomerIdList(customerIds);
            crAccountBillReqDto.setOrgInfoId(null);
        } else {
            Long orgId = this.creditAccountService.queryOrgIdByUserId();
            if (ObjectUtil.isNotEmpty((Object)orgId)) {
                crAccountBillReqDto.setOrgInfoId(String.valueOf(orgId));
            }
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        PageInfo dtoPageInfo = PageInfo.of((List)this.crAccountBillDas.queryAccountBillAndOrderByPage(crAccountBillReqDto));
        dtoPageInfo.getList().stream().forEach(p -> BusinessUtil.checkExpireStatus(p));
        return dtoPageInfo;
    }

    @Override
    public AccountBillAndOrderRespDto queryTotalAmountByPage(String filter, Integer pageNum, Integer pageSize) {
        CrAccountBillReqDto crAccountBillReqDto = (CrAccountBillReqDto)JSON.parseObject((String)filter, CrAccountBillReqDto.class);
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountBillReqDto.setOrgInfoId(String.valueOf(orgId));
        }
        BigDecimal totalAmount = this.crAccountBillDas.queryAccountBillAndOrderTotalAmount(crAccountBillReqDto);
        PageInfo<CrAccountBillRespDto> dtoPageInfo = this.queryByPage(filter, pageNum, pageSize);
        AccountBillAndOrderRespDto respDto = new AccountBillAndOrderRespDto();
        respDto.setTotalAmount(totalAmount);
        respDto.setDtoPageInfo(dtoPageInfo);
        return respDto;
    }

    @Override
    public AccountBillTotalRespDto queryByCustomer(String filter) {
        List accountBillShopTotalRespDtos;
        CrAccountBillReqDto accountBillReqDto = (CrAccountBillReqDto)JSON.parseObject((String)filter, CrAccountBillReqDto.class);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(Long.valueOf(accountBillReqDto.getOrgInfoId()));
        List customerIds = (List)this.customerExtQueryApi.queryCustomerIdByOrgId(orgIds).getData();
        if (CollectionUtil.isEmpty((Collection)customerIds)) {
            return null;
        }
        accountBillReqDto.setCustomerIdList(customerIds);
        AccountBillTotalRespDto accountBillTotalRespDto = new AccountBillTotalRespDto();
        List accountBillTotalRespDtoList = this.crAccountBillDas.queryAccountBillTotalAmount(accountBillReqDto);
        if (CollectionUtil.isNotEmpty((Collection)accountBillTotalRespDtoList)) {
            if (accountBillTotalRespDtoList.size() == 1) {
                accountBillTotalRespDto = (AccountBillTotalRespDto)accountBillTotalRespDtoList.get(0);
            } else {
                BigDecimal total = BigDecimal.ZERO;
                for (AccountBillTotalRespDto respDto : accountBillTotalRespDtoList) {
                    total = total.add(respDto.getTotalAmount());
                }
                accountBillTotalRespDto.setTotalAmount(total);
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)(accountBillShopTotalRespDtos = this.crAccountBillDas.queryAccountBillShopTotalAmount(accountBillReqDto)))) {
            accountBillTotalRespDto.setList(accountBillShopTotalRespDtos);
        }
        return accountBillTotalRespDto;
    }

    @Override
    public List<CrAccountBillRespDto> queryByBillNo(String billNo) {
        CrAccountBillReqDto crAccountBillReqDto = new CrAccountBillReqDto();
        crAccountBillReqDto.setBillNo(billNo);
        List dtos = this.crAccountBillDas.queryAccountBillAndOrderByPage(crAccountBillReqDto);
        return dtos;
    }
}

