/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.biz.account.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.credit.api.account.constant.ModelStatusConstant;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.request.CrAccountCustomerConfigReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CommonImportRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.dto.response.CrAccountCustomerConfigRespDto;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessException;
import com.dtyunxi.yundt.cube.center.credit.api.account.exception.AccountBusinessExceptionCode;
import com.dtyunxi.yundt.cube.center.credit.biz.account.service.ICrAccountCustomerConfigService;
import com.dtyunxi.yundt.cube.center.credit.biz.account.vo.AccountCustomerConfigVo;
import com.dtyunxi.yundt.cube.center.credit.biz.credit.service.ICreditAccountService;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountBillDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountCustomerConfigDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountModelDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountOrderDas;
import com.dtyunxi.yundt.cube.center.credit.dao.account.das.CrAccountRecordDas;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountCustomerConfigEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountModelEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.CrAccountOrderEo;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.account.StdCrAccountCustomerConfigEo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CrAccountCustomerConfigServiceImpl
implements ICrAccountCustomerConfigService {
    private static Logger logger = LoggerFactory.getLogger(CrAccountCustomerConfigServiceImpl.class);
    @Resource
    private CrAccountCustomerConfigDas crAccountCustomerConfigDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private CrAccountModelDas accountModelDas;
    @Resource
    private ICreditAccountService creditAccountService;
    @Resource
    private CrAccountOrderDas accountOrderDas;
    @Resource
    private CrAccountBillDas accountBillDas;
    @Resource
    private CrAccountRecordDas accountRecordDas;

    @Override
    public CrAccountCustomerConfigRespDto queryAccountByCustomerCode(CrAccountCustomerConfigReqDto reqDto) {
        return this.crAccountCustomerConfigDas.queryAccountByCustomerCode(reqDto);
    }

    @Override
    public CrAccountCustomerConfigRespDto queryAccountByOrderNo(String orderNo) {
        CrAccountOrderEo orderEo = new CrAccountOrderEo();
        orderEo.setOrderNo(orderNo);
        CrAccountOrderEo accountOrderEo = (CrAccountOrderEo)this.accountOrderDas.selectOne((BaseEo)orderEo);
        if (ObjectUtil.isNotEmpty((Object)accountOrderEo)) {
            CrAccountCustomerConfigReqDto reqDto = new CrAccountCustomerConfigReqDto();
            reqDto.setCustomerCode(accountOrderEo.getCustomerCode());
            CrAccountCustomerConfigRespDto dto = this.queryAccountByCustomerCode(reqDto);
            if (ObjectUtil.isNotEmpty((Object)dto)) {
                if (ObjectUtil.isNotEmpty((Object)dto.getId())) {
                    return dto;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void addCrAccountCustomerConfig(List<CrAccountCustomerConfigReqDto> list) {
        ArrayList<CrAccountCustomerConfigEo> eoList = new ArrayList<CrAccountCustomerConfigEo>();
        for (CrAccountCustomerConfigReqDto addReqDto : list) {
            CrAccountCustomerConfigEo crAccountCustomerConfigEo = new CrAccountCustomerConfigEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)crAccountCustomerConfigEo);
            crAccountCustomerConfigEo.setEffectStarttime(addReqDto.getEffectStarttime());
            crAccountCustomerConfigEo.setEffectEndtime(addReqDto.getEffectEndtime());
            if (ObjectUtil.isEmpty((Object)addReqDto.getEffectStarttime()) || ObjectUtil.isEmpty((Object)addReqDto.getEffectEndtime())) {
                throw new AccountBusinessException(AccountBusinessExceptionCode.ACCOUNT_MODEL_ADD_FAIL);
            }
            Long orgId = this.creditAccountService.queryOrgIdByUserId();
            if (ObjectUtil.isNotEmpty((Object)orgId)) {
                crAccountCustomerConfigEo.setOrgInfoId(orgId);
            }
            eoList.add(crAccountCustomerConfigEo);
        }
        this.crAccountCustomerConfigDas.insertBatch(eoList);
    }

    @Override
    public void modifyCrAccountCustomerConfig(CrAccountCustomerConfigReqDto modifyReqDto) {
        CrAccountCustomerConfigEo crAccountCustomerConfigEo = new CrAccountCustomerConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)crAccountCustomerConfigEo);
        this.crAccountCustomerConfigDas.updateSelective((BaseEo)crAccountCustomerConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCrAccountCustomerConfig(String id) {
        this.crAccountCustomerConfigDas.logicDeleteById(Long.valueOf(id));
    }

    @Override
    public CrAccountCustomerConfigRespDto queryById(Long id) {
        CrAccountCustomerConfigEo crAccountCustomerConfigEo = (CrAccountCustomerConfigEo)this.crAccountCustomerConfigDas.selectByPrimaryKey(id);
        CrAccountCustomerConfigRespDto crAccountCustomerConfigRespDto = new CrAccountCustomerConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)crAccountCustomerConfigEo, (BaseVo)crAccountCustomerConfigRespDto);
        return crAccountCustomerConfigRespDto;
    }

    @Override
    public PageInfo<CrAccountCustomerConfigRespDto> queryByPageSetup(String filter, Integer pageNum, Integer pageSize) {
        CrAccountCustomerConfigReqDto crAccountCustomerConfigReqDto = (CrAccountCustomerConfigReqDto)JSON.parseObject((String)filter, CrAccountCustomerConfigReqDto.class);
        CrAccountCustomerConfigEo crAccountCustomerConfigEo = new CrAccountCustomerConfigEo();
        Long orgId = this.creditAccountService.queryOrgIdByUserId();
        if (ObjectUtil.isNotEmpty((Object)orgId)) {
            crAccountCustomerConfigEo.setOrgInfoId(orgId);
        }
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (ObjectUtil.isNotEmpty((Object)crAccountCustomerConfigReqDto.getStatus())) {
            crAccountCustomerConfigEo.setStatus(null);
            if (ModelStatusConstant.MODEL_LOSE_EFFECT.equals(crAccountCustomerConfigReqDto.getStatus())) {
                sqlFilterList.add(SqlFilter.ge((String)"effect_starttime", (Object)DateUtil.date()));
            } else {
                sqlFilterList.add(SqlFilter.le((String)"effect_starttime", (Object)DateUtil.date()));
                sqlFilterList.add(SqlFilter.ge((String)"effect_endtime", (Object)DateUtil.date()));
            }
        }
        crAccountCustomerConfigEo.setSqlFilters(sqlFilterList);
        List customerConfigRespDtoList = this.crAccountCustomerConfigDas.select((BaseEo)crAccountCustomerConfigEo);
        List customerCodeList = customerConfigRespDtoList.stream().map(e -> e.getCustomerCode()).collect(Collectors.toList());
        crAccountCustomerConfigReqDto.setCodeInList(customerCodeList);
        logger.info("\u8bf7\u6c42\u67e5\u8be2\u914d\u7f6e[{}]", (Object)crAccountCustomerConfigReqDto.getCodeInList());
        PageInfo respDtoPageInfo = (PageInfo)this.customerQueryApi.queryByPage(JSONObject.toJSONString((Object)crAccountCustomerConfigReqDto), pageNum, pageSize).getData();
        logger.info("\u67e5\u8be2\u5230\u5df2\u7ecf\u914d\u7f6e\u7528\u6237\u4fe1\u606f\u4e3a[{}]", (Object)respDtoPageInfo);
        PageInfo dtoPageInfo = new PageInfo();
        if (ObjectUtil.isNotEmpty((Object)respDtoPageInfo) && CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            List respDtoPageInfoList = respDtoPageInfo.getList();
            Map<String, CrAccountCustomerConfigEo> configEoMap = customerConfigRespDtoList.stream().collect(Collectors.toMap(StdCrAccountCustomerConfigEo::getCustomerCode, CrAccountCustomerConfigEo2 -> CrAccountCustomerConfigEo2, (key1, key2) -> key1));
            ArrayList<CrAccountCustomerConfigRespDto> result = new ArrayList<CrAccountCustomerConfigRespDto>();
            for (CustomerRespDto respDto : respDtoPageInfoList) {
                if (!configEoMap.containsKey(respDto.getCode())) continue;
                CrAccountCustomerConfigEo customerConfigEo = configEoMap.get(respDto.getCode());
                CrAccountCustomerConfigRespDto dto = new CrAccountCustomerConfigRespDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)customerConfigEo, (String[])new String[0]);
                dto.setCustomerName(respDto.getName());
                dto.setCustomerArea(respDto.getRegionNames());
                dto.setCustomerType(respDto.getCustomerTypeName());
                result.add(dto);
            }
            if (CollectionUtil.isEmpty(result)) {
                return dtoPageInfo;
            }
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)respDtoPageInfo, (String[])new String[0]);
            dtoPageInfo.setList(result);
            for (CrAccountCustomerConfigRespDto dto : dtoPageInfo.getList()) {
                if (DateUtil.compare((Date)dto.getEffectStarttime(), (Date)DateTime.now()) < 0 && DateUtil.compare((Date)dto.getEffectEndtime(), (Date)DateTime.now()) > 0) {
                    dto.setStatus(ModelStatusConstant.MODEL_TAKE_EFFECT);
                    continue;
                }
                if (DateUtil.compare((Date)dto.getEffectEndtime(), (Date)DateTime.now()) < 0) {
                    dto.setStatus(ModelStatusConstant.MODEL_EXPIRED_EFFECT);
                    continue;
                }
                dto.setStatus(ModelStatusConstant.MODEL_LOSE_EFFECT);
            }
            List crAccountModelEos = this.accountModelDas.selectAll();
            Map<Long, CrAccountModelEo> modelEoMap = crAccountModelEos.stream().collect(Collectors.toMap(BaseEo::getId, CrAccountModelEo2 -> CrAccountModelEo2, (key1, key2) -> key1));
            for (CrAccountCustomerConfigRespDto dto : dtoPageInfo.getList()) {
                if (!modelEoMap.containsKey(dto.getModelId())) continue;
                CrAccountModelEo modelEo = modelEoMap.get(dto.getModelId());
                dto.setModelType(modelEo.getModelType());
                dto.setModelName(modelEo.getModelName());
                dto.setModelRule(modelEo.getModelRule());
            }
        }
        return dtoPageInfo;
    }

    @Override
    public List<String> queryCustomerType() {
        List eoList = this.crAccountCustomerConfigDas.selectAll();
        eoList = eoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CrAccountCustomerConfigEo>(Comparator.comparing(StdCrAccountCustomerConfigEo::getCustomerType))), ArrayList::new));
        List<String> collect = eoList.stream().map(StdCrAccountCustomerConfigEo::getCustomerType).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<String> queryCustomerArea() {
        List eoList = this.crAccountCustomerConfigDas.selectAll();
        eoList = eoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CrAccountCustomerConfigEo>(Comparator.comparing(StdCrAccountCustomerConfigEo::getCustomerArea))), ArrayList::new));
        List<String> collect = eoList.stream().map(StdCrAccountCustomerConfigEo::getCustomerArea).collect(Collectors.toList());
        return collect;
    }

    @Override
    public CommonImportRespDto importCrAccountCustomerConfig(MultipartFile file) {
        CommonImportRespDto importRespDto = new CommonImportRespDto();
        boolean flag = true;
        ArrayList<String> msg = new ArrayList<String>();
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setNeedVerfiy(false);
        HashMap<String, CustomerRespDto> customerRespDtoMap = new HashMap<String, CustomerRespDto>();
        HashMap<String, CrAccountModelEo> modelEoMap = new HashMap<String, CrAccountModelEo>();
        List customerConfigVos = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), AccountCustomerConfigVo.class, (ImportParams)importParams);
            customerConfigVos = result.getList();
            if (CollectionUtils.isEmpty(customerConfigVos)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        ArrayList<CrAccountCustomerConfigReqDto> addList = new ArrayList<CrAccountCustomerConfigReqDto>();
        for (int i = 0; i < customerConfigVos.size(); ++i) {
            AccountCustomerConfigVo customerConfigVo = (AccountCustomerConfigVo)customerConfigVos.get(i);
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getCustomerName())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u5ba2\u6237\u540d\u79f0\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getEffectStarttime())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u8d26\u671f\u751f\u6548\u65f6\u95f4\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getEffectEndtime())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u8d26\u671f\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getCustomerCode())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u5ba2\u6237\u7f16\u53f7\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            } else if (!customerRespDtoMap.containsKey(customerConfigVo.getCustomerCode())) {
                CustomerRespDto respDto = (CustomerRespDto)this.customerQueryApi.queryByCode(customerConfigVo.getCustomerCode()).getData();
                if (ObjectUtil.isEmpty((Object)respDto)) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5ba2\u6237\u7f16\u53f7:" + customerConfigVo.getCustomerCode() + "\u4e0d\u5b58\u5728\u3002");
                    flag = false;
                }
                customerRespDtoMap.put(customerConfigVo.getCustomerCode(), respDto);
            }
            if (ObjectUtil.isEmpty((Object)customerConfigVo.getModelName())) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u65e0\u8d26\u671f\u540d\u79f0\uff0c\u8bf7\u586b\u5199\u3002");
                flag = false;
            } else if (!modelEoMap.containsKey(customerConfigVo.getModelName())) {
                CrAccountModelEo modelEo = new CrAccountModelEo();
                modelEo.setModelName(customerConfigVo.getModelName());
                CrAccountModelEo selectModelEo = (CrAccountModelEo)this.accountModelDas.selectOne((BaseEo)modelEo);
                if (ObjectUtil.isEmpty((Object)selectModelEo)) {
                    msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u8d26\u671f\u540d\u79f0:" + customerConfigVo.getModelName() + "\u4e0d\u5b58\u5728\u3002");
                    flag = false;
                }
                modelEoMap.put(customerConfigVo.getModelName(), selectModelEo);
            }
            if (!flag) continue;
            CrAccountCustomerConfigReqDto customerConfigReqDto = new CrAccountCustomerConfigReqDto();
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(customerConfigVo.getCustomerCode());
            customerConfigReqDto.setCustomerName(customerConfigVo.getCustomerName());
            customerConfigReqDto.setCustomerCode(customerConfigVo.getCustomerCode());
            customerConfigReqDto.setCustomerType(customerRespDto.getCustomerTypeName());
            customerConfigReqDto.setCustomerArea(customerRespDto.getRegionNames());
            CrAccountModelEo categoryEo = (CrAccountModelEo)modelEoMap.get(customerConfigVo.getModelName());
            customerConfigReqDto.setModelId(categoryEo.getId());
            customerConfigReqDto.setEffectStarttime((Date)DateUtil.parse((CharSequence)customerConfigVo.getEffectStarttime(), (DateParser)DatePattern.JDK_DATETIME_FORMAT));
            customerConfigReqDto.setEffectEndtime((Date)DateUtil.parse((CharSequence)customerConfigVo.getEffectEndtime(), (DateParser)DatePattern.JDK_DATETIME_FORMAT));
            CrAccountCustomerConfigEo customerConfigEo = new CrAccountCustomerConfigEo();
            customerConfigEo.setCustomerCode(customerConfigVo.getCustomerCode());
            List eoList = this.crAccountCustomerConfigDas.select((BaseEo)customerConfigEo);
            if (CollectionUtil.isNotEmpty((Collection)eoList)) {
                msg.add("\u7b2c" + (i + 1) + "\u884c\uff0c\u5ba2\u6237\u7f16\u53f7:" + customerConfigVo.getCustomerCode() + "\u5df2\u5b58\u5728\u8d26\u671f\u8bbe\u7f6e\uff0c\u4e0d\u9700\u5bfc\u5165\u3002");
                continue;
            }
            addList.add(customerConfigReqDto);
        }
        if (!flag) {
            importRespDto.setFlag(Boolean.valueOf(false));
            importRespDto.setMsg(msg);
            return importRespDto;
        }
        if (CollectionUtil.isNotEmpty(addList)) {
            this.addCrAccountCustomerConfig(addList);
        }
        importRespDto.setFlag(Boolean.valueOf(true));
        if (CollectionUtil.isNotEmpty(msg)) {
            importRespDto.setMsg(msg);
        }
        return importRespDto;
    }

    @Override
    public PageInfo<CrAccountCustomerConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List customerConfigRespDtoList = this.crAccountCustomerConfigDas.queryAccountCustomer();
        List customerCodeList = customerConfigRespDtoList.stream().map(e -> e.getCustomerCode()).collect(Collectors.toList());
        CustomerSearchReqDto reqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            reqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        reqDto.setCodeNotInList(customerCodeList);
        reqDto.setListFlag(Boolean.valueOf(true));
        reqDto.setIsFilterDownstreamCustomersByCurrentUser(Boolean.valueOf(true));
        PageInfo respDtoPageInfo = (PageInfo)this.customerQueryApi.queryByPage(JSONObject.toJSONString((Object)reqDto), pageNum, pageSize).getData();
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)respDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (ObjectUtil.isNotEmpty((Object)respDtoPageInfo) && CollectionUtil.isNotEmpty((Collection)respDtoPageInfo.getList())) {
            ArrayList<CrAccountCustomerConfigRespDto> dtos = new ArrayList<CrAccountCustomerConfigRespDto>(respDtoPageInfo.getList().size());
            for (CustomerRespDto customerRespDto : respDtoPageInfo.getList()) {
                CrAccountCustomerConfigRespDto dto = new CrAccountCustomerConfigRespDto();
                dto.setCustomerCode(customerRespDto.getCode());
                dto.setCustomerName(customerRespDto.getName());
                dto.setCustomerType(customerRespDto.getCustomerTypeName());
                dto.setCustomerArea(customerRespDto.getRegionNames());
                dtos.add(dto);
            }
            pageInfo.setList(dtos);
        }
        return pageInfo;
    }
}

