/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.credit.dao.credit.das;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.ConfigAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.dto.request.CreditAccountSearchReqDto;
import com.dtyunxi.yundt.cube.center.credit.api.credit.enums.ConfigType;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.credit.dao.credit.mapper.CreditAccountMapper;
import com.dtyunxi.yundt.cube.center.credit.dao.eo.credit.CreditAccountEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class CreditAccountDas
extends AbstractBaseDas<CreditAccountEo, String> {
    @Resource
    private CreditAccountMapper creditAccountMapper;

    public List<CreditAccountEo> queryById(Long creditAccountId) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        creditAccountEo.setId(creditAccountId);
        creditAccountEo.setDr(0);
        List accountEoList = this.selectList((BaseEo)creditAccountEo);
        return accountEoList;
    }

    public Map<Long, Integer> queryConfigAccountNum(List<Long> ids, ConfigType type) {
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(ids.size());
        List<CreditAccountEo> eoList = this.creditAccountMapper.queryConfigAccountNum(ids, type.getCode());
        if (CollectionUtils.isNotEmpty(eoList)) {
            for (CreditAccountEo numDto : eoList) {
                map.put(numDto.getId(), Integer.valueOf(numDto.getExtension()));
            }
        }
        return map;
    }

    public List<CreditAccountEo> queryConfigAccount(ConfigAccountSearchReqDto dto, String type, List<Long> configIds) {
        if (CollectionUtils.isEmpty(configIds)) {
            configIds = null;
        }
        return this.creditAccountMapper.queryConfigAccount(dto, type, configIds);
    }

    public void updateAccountConfig(List<Long> ids, String type, String valueName, Long id) {
        String value = type.replace("id", "value");
        this.creditAccountMapper.updateAccountConfig(ids, type, value, valueName, id);
    }

    public void updateAccountRemoveConfig(List<Long> ids, String type, Long id) {
        String value = type.replace("id", "value");
        try {
            this.creditAccountMapper.updateAccountRemoveConfig(ids, type, value, id);
        }
        catch (Exception ex) {
            throw new BizException("\u89e3\u7ed1\u7684\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
    }

    public void updateAccountDimValue(String type, String valueName, Long dimId) {
        String value = type.replace("id", "value");
        this.creditAccountMapper.updateAccountDimValue(type, value, valueName, dimId);
    }

    public List<Long> findAccountIdsById(Long applyId) {
        return this.creditAccountMapper.findAccountIdsById(applyId);
    }

    public int countAccountNum(Long id) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        creditAccountEo.setCreditEntityId(id);
        creditAccountEo.setDr(0);
        int count = this.count((BaseEo)creditAccountEo);
        return count;
    }

    public BigDecimal countUsedAccountAmount(Long entityId) {
        BigDecimal bigDecimal = this.creditAccountMapper.countUsedAccountNum(entityId);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public BigDecimal countTotalAccountAmount(Long entityId) {
        BigDecimal bigDecimal = this.creditAccountMapper.countTotalAccountNum(entityId);
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    @Transactional(rollbackFor={Exception.class})
    public void addQuota(Long creditAccountId, BigDecimal grantQuota) {
        this.creditAccountMapper.addQuota(creditAccountId, grantQuota);
    }

    @Transactional(rollbackFor={Exception.class})
    public void subQuota(Long creditAccountId, BigDecimal grantQuota) {
        this.creditAccountMapper.subQuota(creditAccountId, grantQuota);
    }

    @Transactional(rollbackFor={Exception.class})
    public void releaseUseQuota(Long creditAccountId, BigDecimal grantQuota) {
        this.creditAccountMapper.releaseUseQuota(creditAccountId, grantQuota);
    }

    @Transactional(rollbackFor={Exception.class})
    public void useQuota(Long creditAccountId, BigDecimal useQuota) {
        if (useQuota.compareTo(BigDecimal.ZERO) < 0) {
            useQuota = useQuota.negate();
        }
        this.creditAccountMapper.useQuota(creditAccountId, useQuota);
    }

    public List<CreditAccountEo> queryByIds(List<Long> ids) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        creditAccountEo.setDr(0);
        creditAccountEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", ids)));
        return this.select((BaseEo)creditAccountEo);
    }

    public PageInfo<CreditAccountEo> queryByPage(CreditAccountSearchReqDto queryEo, Integer pageNum, Integer pageSize) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        BeanUtils.copyProperties((Object)queryEo, (Object)creditAccountEo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)queryEo.getCreditAccountCode())) {
            sqlFilterList.add(SqlFilter.like((String)"credit_account_name", (Object)("%" + queryEo.getCreditAccountCode() + "%")));
        }
        if (!CollectionUtils.isEmpty((Collection)queryEo.getAccountIds())) {
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)queryEo.getAccountIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryEo.getCreditEntityIds())) {
            sqlFilterList.add(SqlFilter.in((String)"credit_entity_id", (Object)queryEo.getCreditEntityIds()));
        }
        creditAccountEo.setSqlFilters(sqlFilterList);
        ArrayList<SqlOrderBy> orderBys = new ArrayList<SqlOrderBy>();
        orderBys.add(new SqlOrderBy("creditAccountStatus", SortOrder.ASC));
        orderBys.add(new SqlOrderBy("create_time", SortOrder.DESC));
        creditAccountEo.setSqlOrderBys(orderBys);
        creditAccountEo.setOrgInfoId(queryEo.getOrgInfoId());
        return this.selectPage((BaseEo)creditAccountEo, pageNum, pageSize);
    }

    public List<CreditAccountEo> queryByList(CreditAccountSearchReqDto queryEo) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        BeanUtils.copyProperties((Object)queryEo, (Object)creditAccountEo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)queryEo.getCreditAccountCode())) {
            sqlFilterList.add(SqlFilter.like((String)"credit_account_name", (Object)("%" + queryEo.getCreditAccountCode() + "%")));
        }
        if (!CollectionUtils.isEmpty((Collection)queryEo.getAccountIds())) {
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)queryEo.getAccountIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)queryEo.getCreditEntityIds())) {
            sqlFilterList.add(SqlFilter.in((String)"credit_entity_id", (Object)queryEo.getCreditEntityIds()));
        }
        if (queryEo.getDim1Id() != null) {
            creditAccountEo.setDim1Id(queryEo.getDim1Id());
        } else {
            sqlFilterList.add(SqlFilter.isNull((String)"dim1_id"));
        }
        if (queryEo.getDim2Id() != null) {
            creditAccountEo.setDim2Id(queryEo.getDim2Id());
        } else {
            sqlFilterList.add(SqlFilter.isNull((String)"dim2_id"));
        }
        if (queryEo.getDim3Id() != null) {
            creditAccountEo.setDim3Id(queryEo.getDim3Id());
        } else {
            sqlFilterList.add(SqlFilter.isNull((String)"dim3_id"));
        }
        creditAccountEo.setDr(0);
        creditAccountEo.setSqlFilters(sqlFilterList);
        return this.selectList((BaseEo)creditAccountEo);
    }

    public List<CreditAccountEo> queryAccountByEntityIds(CreditAccountSearchReqDto queryEo) {
        CreditAccountEo creditAccountEo = new CreditAccountEo();
        BeanUtils.copyProperties((Object)queryEo, (Object)creditAccountEo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (!CollectionUtils.isEmpty((Collection)queryEo.getAccountIds())) {
            sqlFilterList.add(SqlFilter.in((String)"credit_entity_id", (Object)queryEo.getAccountIds()));
        }
        creditAccountEo.setDr(0);
        creditAccountEo.setSqlFilters(sqlFilterList);
        return this.selectList((BaseEo)creditAccountEo);
    }

    public List<Long> queryEntityIdById(List<Long> ids) {
        return this.creditAccountMapper.queryEntityIdById(ids);
    }

    public List<CreditAccountEo> queryUseAccountByEntityIds(List<Long> entityIds) {
        return this.creditAccountMapper.queryUseAccountByEntityIds(entityIds);
    }

    public List<CreditAccountEo> queryAccountByEntityIds(List<Long> entityIds) {
        return this.creditAccountMapper.queryAccountByEntityIds(entityIds);
    }

    public List<CreditAccountEo> queryAccountByEntityIdsAndDimId(List<Long> entityIds, Long dim1Id, Long dim2Id) {
        return this.creditAccountMapper.queryAccountByEntityIdsAndDimId(entityIds, dim1Id, dim2Id);
    }

    public List<CreditAccountEo> getCreditAccountEos(Long entityId) {
        CreditAccountEo selectItemCreditAccount = new CreditAccountEo();
        selectItemCreditAccount.setCreditEntityId(entityId);
        ArrayList sqlFilterList = new ArrayList();
        selectItemCreditAccount.setSqlFilters(sqlFilterList);
        selectItemCreditAccount.setDr(0);
        return this.selectList((BaseEo)selectItemCreditAccount);
    }
}

