/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.api.exception;

import java.util.HashMap;
import java.util.Map;

public enum ChargeModeEnum {
    VOLUME(1, "\u6309\u4ef6\u4f53\u79ef"),
    TRANSPORT(2, "\u6309\u4f53\u79ef\u8ba1\u8d39"),
    WEIGHT(3, "\u6309\u91cd\u91cf\u8ba1\u8d39"),
    MINIMUM(4, "\u6309\u6700\u4f4e\u6536\u8d39"),
    FIXED_PRICE(5, "\u5b9a\u4ef7"),
    NO_CHARGE(6, "\u4e0d\u8ba1\u8d39"),
    SELF_LIFTING(7, "\u81ea\u63d0");

    private Integer type;
    private String name;
    public static final Map<Integer, ChargeModeEnum> CHARGE_MODE_TYPE_MAP;

    private ChargeModeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public static ChargeModeEnum getChargeMode(Integer type) {
        ChargeModeEnum chargeModeEnum = CHARGE_MODE_TYPE_MAP.get(type);
        return chargeModeEnum;
    }

    public Integer getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    static {
        CHARGE_MODE_TYPE_MAP = new HashMap<Integer, ChargeModeEnum>();
        CHARGE_MODE_TYPE_MAP.put(VOLUME.getType(), VOLUME);
        CHARGE_MODE_TYPE_MAP.put(TRANSPORT.getType(), TRANSPORT);
        CHARGE_MODE_TYPE_MAP.put(WEIGHT.getType(), WEIGHT);
        CHARGE_MODE_TYPE_MAP.put(MINIMUM.getType(), MINIMUM);
        CHARGE_MODE_TYPE_MAP.put(FIXED_PRICE.getType(), FIXED_PRICE);
        CHARGE_MODE_TYPE_MAP.put(NO_CHARGE.getType(), NO_CHARGE);
        CHARGE_MODE_TYPE_MAP.put(SELF_LIFTING.getType(), SELF_LIFTING);
    }
}

