/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.interceptor;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.ITokenApi;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class UserLoginInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(UserLoginInterceptor.class);
    private String respResult = "{\"resultCode\":401,\"resultMsg\":\"no login\"}";
    public final ITokenApi tokenApi;

    public UserLoginInterceptor(ITokenApi tokenApi) {
        this.tokenApi = tokenApi;
    }

    public boolean preHandle(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Object handler) throws Exception {
        boolean isContinue = false;
        String auth = httpRequest.getHeader("Access-Token");
        if (StringUtils.isNotBlank((CharSequence)auth) && this.checkToken(auth)) {
            isContinue = true;
        } else {
            this.notLoginResponse(httpResponse);
        }
        return isContinue;
    }

    private boolean checkToken(String token) {
        try {
            RestResponse<Map<String, Object>> restResponse = this.tokenApi.checkToken(token);
            if ("0".equals(restResponse.getResultCode())) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8ctoken\u51fa\u9519 : {} \u3002\u8be5\u9519\u8bef\u88ab\u5ffd\u7565", (Object)e.getMessage());
        }
        return false;
    }

    private void notLoginResponse(HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(401);
        PrintWriter out = httpResponse.getWriter();
        out.append(this.respResult);
        out.close();
    }
}

