/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.apiimpl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.IThirdLoginApi;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.AuthLoginTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.BindLoginWithoutAccessTokenDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserBindLoginThirdDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdLoginRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.ThirdUserInfoRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IThirdLoginService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="thirdLoginApi")
public class ThirdLoginApiImpl
implements IThirdLoginApi {
    @Resource
    IThirdLoginService iThirdLoginService;

    public RestResponse<ThirdUserInfoRespDto> thirdAuth(AuthLoginReqDto authReqDto) {
        if (StringUtils.isEmpty((Object)authReqDto.getState())) {
            authReqDto.setState("STATE");
        }
        Long tenantId = authReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : authReqDto.getTenantId();
        Long instanceId = authReqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : authReqDto.getInstanceId();
        authReqDto.setTenantId(tenantId);
        authReqDto.setInstanceId(instanceId);
        return new RestResponse((Object)this.iThirdLoginService.thirdAuth(authReqDto));
    }

    public RestResponse<ThirdLoginRespDto> tokenAuth(AuthLoginTokenReqDto authTokenReqDto) {
        Long tenantId = authTokenReqDto.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : authTokenReqDto.getTenantId();
        Long instanceId = authTokenReqDto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : authTokenReqDto.getInstanceId();
        authTokenReqDto.setTenantId(tenantId);
        authTokenReqDto.setInstanceId(instanceId);
        return new RestResponse((Object)this.iThirdLoginService.tokenAuth(authTokenReqDto));
    }

    public RestResponse<TokenRespDto> bindLogin(@Valid UserBindLoginThirdDto user) {
        Long tenantId = user.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : user.getTenantId();
        Long instanceId = user.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : user.getInstanceId();
        user.setTenantId(tenantId);
        user.setInstanceId(instanceId);
        return new RestResponse((Object)this.iThirdLoginService.bindLogin(user));
    }

    public RestResponse<TokenRespDto> bindLoginWithoutAccessToken(@Valid BindLoginWithoutAccessTokenDto user) {
        Long tenantId = user.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : user.getTenantId();
        Long instanceId = user.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : user.getInstanceId();
        user.setTenantId(tenantId);
        user.setInstanceId(instanceId);
        return new RestResponse((Object)this.iThirdLoginService.bindLoginWithoutAccessToken(user));
    }

    public RestResponse<Void> redirectUri(String code, String uriKey, HttpServletResponse httpServletResponse) {
        this.iThirdLoginService.redirectUri(code, uriKey, httpServletResponse);
        return RestResponse.VOID;
    }
}

