/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.apiimpl.v3;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.CheckTokenReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.v3.ITokenApi;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="tokenApi-v3")
public class TokenApiImpl
implements ITokenApi {
    @Resource
    private ITokenService tokenService;

    public RestResponse<Map<String, Object>> checkToken(@Valid String token) {
        return new RestResponse(this.tokenService.checkToken(token));
    }

    public RestResponse<Map<String, Object>> checkToken(@Valid CheckTokenReqDto checkTokenReqDto) {
        return new RestResponse(this.tokenService.checkToken(checkTokenReqDto));
    }

    public RestResponse<Void> deleteToken(String userId) {
        this.tokenService.deleteToken(userId);
        return new RestResponse();
    }

    public RestResponse<Void> deleteLoginToken(String userId, String loginSource) {
        this.tokenService.deleteLoginToken(userId, loginSource);
        return RestResponse.SUCCESS;
    }

    public RestResponse<TokenRespDto> createToken(@Valid UserLoginReqDto user) {
        Long tenantId = user.getTenantId() == null ? ServiceContext.getContext().getRequestTenantId() : user.getTenantId();
        Long instanceId = user.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : user.getInstanceId();
        user.setInstanceId(instanceId);
        user.setTenantId(tenantId);
        TokenRespDto resToken = this.tokenService.createToken(user);
        RestResponse restResponse = new RestResponse((Object)resToken);
        return restResponse;
    }

    public RestResponse<TokenRespDto> createSsoToken(@Valid UserLoginReqDto user) {
        TokenRespDto resToken = this.tokenService.createSsoToken(user);
        return new RestResponse((Object)resToken);
    }

    public RestResponse<Void> deleteSsoToken(String appKey, String token) {
        this.tokenService.deleteSsoToken(appKey, token);
        return RestResponse.SUCCESS;
    }

    public RestResponse<Void> exitLogin(String token, String userId, Long tenantId) {
        this.tokenService.exitLogin(token, userId, tenantId);
        return new RestResponse();
    }
}

