/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.apiimpl.v3.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserLoginConfigReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.v3.query.IUserLoginConfigQueryApi;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserLoginConfigService;
import com.dtyunxi.yundt.cube.center.identity.dao.eo.UserLoginConfigEo;
import com.github.pagehelper.PageInfo;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service(value="userLoginConfigQueryApi-v3")
public class UserLoginConfigQueryApiImpl
implements IUserLoginConfigQueryApi {
    @Resource
    IUserLoginConfigService userLoginConfigService;

    public RestResponse<String> getUserLoginConfig(Long userId) {
        UserLoginConfigEo config = this.userLoginConfigService.selectByUserId(userId);
        if (config == null) {
            return new RestResponse(null);
        }
        return new RestResponse((Object)config.getConfigs());
    }

    public RestResponse<PageInfo<UserLoginConfigReqDto>> getUserLoginConfigs(@RequestParam(name="filters") String filters, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        UserLoginConfigReqDto loginConfigDto = (UserLoginConfigReqDto)JSON.parseObject((String)filters, UserLoginConfigReqDto.class);
        UserLoginConfigEo loginConfigEo = new UserLoginConfigEo();
        DtoHelper.dto2Eo((BaseVo)loginConfigDto, (BaseEo)loginConfigEo);
        PageInfo<UserLoginConfigEo> pageInfo = this.userLoginConfigService.queryLoginConfigsByPage(loginConfigEo, pageNum, pageSize);
        return new RestResponse(pageInfo);
    }
}

