/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.UserInfo;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.IDPUserRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.TokenRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.config.IdpUrlProperties;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ITokenService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IdpService;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class IdpServiceImpl
implements IdpService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICacheService cacheService;
    @Resource
    IBindService bindService;
    @Autowired
    IUserService userService;
    @Autowired
    ITokenService tokenService;
    @Autowired
    IdpUrlProperties idpUrlProperties;
    public static final String IDP_AUTHENTICATION_URL = "%s/iam/v1/users/self";
    private Integer thirdType = 10;

    @Override
    public String QueryByTenantId(Long tenantId) {
        String idpUrl = this.idpUrlProperties.getRedirectHost().get(tenantId);
        this.logger.info("\u83b7\u53d6\u5230\u7684idpUrl: {}", (Object)idpUrl);
        return idpUrl;
    }

    @Override
    public IDPUserRespDto queryUserByToken(String authorization, Long tenantId) {
        String idpUrl = this.idpUrlProperties.getRedirectHost().get(tenantId);
        String url = String.format(IDP_AUTHENTICATION_URL, idpUrl);
        this.logger.info("\u8bf7\u6c42idp\u7684url: {}", (Object)url);
        HttpHeaders headers = new HttpHeaders();
        this.logger.info("\u83b7\u53d6\u5230\u7684Authorization: {}", (Object)authorization);
        headers.add("Authorization", authorization);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = null;
        try {
            resEntity = new RestTemplate().exchange(url.toString(), HttpMethod.GET, requestEntity, String.class, new Object[0]);
        }
        catch (Exception e) {
            this.logger.info("[ERROR]\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6c42\u5934Authorization: [{}],url: [{}],\u9519\u8bef\u4fe1\u606f: [{}]", new Object[]{authorization, url, e.getMessage()});
            throw new BizException(e.getMessage());
        }
        this.logger.debug("respose = " + resEntity.toString());
        JSONObject json = JSON.parseObject((String)((String)resEntity.getBody()));
        IDPUserRespDto dto = new IDPUserRespDto();
        dto.setId(json.getString("id"));
        dto.setLoginName(json.getString("loginName"));
        dto.setUserName(json.getString("realName"));
        dto.setEmail(json.getString("email"));
        dto.setPhone(json.getString("phone"));
        dto.setPosition(json.getString("position"));
        dto.setOrganizationId(json.getString("organizationId"));
        dto.setOrganizationCode(json.getString("organizationCode"));
        dto.setOrganizationName(json.getString("organizationName"));
        TokenRespDto tokenRespDto = this.createDefaultUser(dto);
        this.cacheService.setCache("", tokenRespDto.getToken(), (Object)authorization, tokenRespDto.getTokenValidTime().intValue());
        dto.setToken(tokenRespDto.getToken());
        return dto;
    }

    private TokenRespDto createDefaultUser(IDPUserRespDto userRespDto) {
        UserInfo userInfo = new UserInfo();
        userInfo.setNickname(userRespDto.getUserName());
        userInfo.setOpenid(userRespDto.getId());
        Long instanceId = ServiceContext.getContext().getRequestInstanceId();
        if (instanceId == -1L) {
            instanceId = 1L;
        }
        Long tenantId = Long.valueOf(userRespDto.getOrganizationId());
        UserDto bindingUser = this.bindService.queryThirdUser(userInfo.getOpenid(), "", this.thirdType, instanceId, tenantId);
        if (null != bindingUser) {
            return this.tokenService.createTokenByPhone(this.thirdType, bindingUser, null);
        }
        Integer userType = 1;
        HashMap<String, Object> extFields = new HashMap<String, Object>();
        UserDto userDto = this.userService.addDefaultUser(instanceId, tenantId, userType, extFields, null, userInfo);
        if ((userDto = this.bindService.bindThirdNo(instanceId, tenantId, userDto.getId(), userInfo.getOpenid(), this.thirdType)) == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.BINDING_FAIL);
        }
        return this.tokenService.createTokenByPhone(this.thirdType, userDto, null);
    }
}

