/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.LoginLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.response.LoginLogRespDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.biz.service.ILoginLogSearchService;
import com.dtyunxi.yundt.cube.center.identity.dao.das.AuLoginLogDas;
import com.dtyunxi.yundt.cube.center.identity.dao.vo.AuLoginLogQueryVo;
import com.dtyunxi.yundt.cube.center.identity.dao.vo.AuLoginLogVo;
import com.dtyunxi.yundt.cube.center.identity.util.ListUtils;
import com.dtyunxi.yundt.cube.center.identity.util.PageInfoUtil;
import com.dtyunxi.yundt.cube.center.user.api.dto.AppInstanceDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.TenantDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IApplicationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.github.pagehelper.PageInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class LoginLogSearchServiceImpl
implements ILoginLogSearchService {
    @Resource
    private AuLoginLogDas auLoginLogDas;
    @Resource
    private IApplicationQueryApi applicationQueryApi;
    @Resource
    private IUserQueryApi userQueryApi;

    @Override
    public PageInfo<LoginLogRespDto> findList(String filter, Integer pageNum, Integer pageSize) {
        return this.queryLoginLog(filter, pageNum, pageSize);
    }

    @Override
    public PageInfo<LoginLogRespDto> queryPage(LoginLogQueryReqDto loginLogQueryReqDto, Integer pageNum, Integer pageSize) {
        return this.queryLoginLog(JSONObject.toJSONString((Object)loginLogQueryReqDto), pageNum, pageSize);
    }

    @Override
    public PageInfo<LoginLogRespDto> queryLoginLog(String filter, Integer pageNum, Integer pageSize) {
        LoginLogQueryReqDto loginLogQueryReqDto;
        try {
            loginLogQueryReqDto = (LoginLogQueryReqDto)ObjectHelper.Json2Bean((String)filter, LoginLogQueryReqDto.class);
        }
        catch (Exception e) {
            throw new BizException(IdentityExceptionCode.FAIL.getCode(), IdentityExceptionCode.FAIL.getMsg());
        }
        Long tenantId = ServiceContext.getContext().getRequestTenantId() != null ? ServiceContext.getContext().getRequestTenantId() : loginLogQueryReqDto.getTenantId();
        Long instanceId = ServiceContext.getContext().getRequestInstanceId() != null ? ServiceContext.getContext().getRequestInstanceId() : loginLogQueryReqDto.getInstanceId();
        Assert.notNull((Object)tenantId, (String)"\u8bfb\u53d6\u4e0d\u5230\u79df\u6237id");
        Assert.notNull((Object)instanceId, (String)"\u8bfb\u53d6\u4e0d\u5230\u5b9e\u4f8bid");
        AppInstanceDto appInstanceDto = (AppInstanceDto)this.applicationQueryApi.queryInsById(instanceId, "{}").getData();
        TenantDto tenantDto = (TenantDto)this.userQueryApi.queryTenantById(tenantId).getData();
        AuLoginLogVo auLoginLogVo = new AuLoginLogVo();
        BeanUtils.copyProperties((Object)loginLogQueryReqDto, (Object)auLoginLogVo, (String[])new String[]{"instanceId", "tenantId"});
        auLoginLogVo.setTenantId(tenantId);
        auLoginLogVo.setInstanceId(instanceId);
        List auLoginLogQueryVoList = this.auLoginLogDas.queryByCondition(auLoginLogVo);
        for (AuLoginLogQueryVo auLoginLogQueryVo : auLoginLogQueryVoList) {
            auLoginLogQueryVo.setTenantName(tenantDto.getTenantName());
            auLoginLogQueryVo.setAppInstanceName(appInstanceDto.getAppInsName());
            if (null != auLoginLogQueryVo.getLogoutTime() || null == auLoginLogQueryVo.getExpectedLogoutTime()) continue;
            Date currentTime = new Date();
            if (null != auLoginLogQueryVo.getLogoutTime()) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date expectedLogoutTime = null;
            try {
                expectedLogoutTime = simpleDateFormat.parse(auLoginLogQueryVo.getExpectedLogoutTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (null == expectedLogoutTime || !expectedLogoutTime.before(currentTime)) continue;
            auLoginLogQueryVo.setLogoutTime(auLoginLogQueryVo.getExpectedLogoutTime());
        }
        List<LoginLogRespDto> loginLogRespDtoList = ListUtils.entityListToModelList(auLoginLogQueryVoList, LoginLogRespDto.class);
        if (CollectionUtils.isEmpty(loginLogRespDtoList)) {
            return new PageInfo();
        }
        return PageInfoUtil.doPage(loginLogRespDtoList, pageNum, pageSize);
    }
}

