/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.biz.member.api.basis.IMemberInfoBestoreApi;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.request.MemberExtCreateReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MemberRegisterReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserReqDto;
import com.dtyunxi.yundt.cube.center.identity.biz.config.DefaultMemberModelProperties;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IMemberService;
import com.dtyunxi.yundt.cube.center.member.api.basis.IMemberApi;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.MemberInfoReqDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.MemberReqDto;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MemberServiceImpl
implements IMemberService {
    private static final Logger logger = LoggerFactory.getLogger(MemberServiceImpl.class);
    @Autowired
    private DefaultMemberModelProperties memberModelProperties;
    @Autowired
    private IMemberApi memberApi;
    @Autowired
    private IMemberInfoBestoreApi memberInfoBestoreApi;

    @Override
    public void activateMember(MemberRegisterReqDto dto) {
        if (this.memberModelProperties != null && CollectionUtils.isNotEmpty(this.memberModelProperties.getMemberModels())) {
            for (DefaultMemberModelProperties.MemberModel memberModel : this.memberModelProperties.getMemberModels()) {
                if (!dto.getInstanceId().equals(memberModel.getInstanceId())) continue;
                for (DefaultMemberModelProperties.Model model : memberModel.getModelId()) {
                    MemberExtCreateReqDto createReqDto = new MemberExtCreateReqDto();
                    createReqDto.setAvatar(dto.getAvatar());
                    createReqDto.setEmail(dto.getEmail());
                    createReqDto.setInstanceId(dto.getInstanceId());
                    createReqDto.setTenantId(dto.getTenantId());
                    if (StringUtils.isEmpty((Object)dto.getPhone())) {
                        createReqDto.setPhone("2" + dto.getUserId().toString().substring(9));
                    } else {
                        createReqDto.setPhone(dto.getPhone());
                    }
                    createReqDto.setName(dto.getUserName());
                    createReqDto.setNickName(dto.getNickName());
                    createReqDto.setMemberModelId(Long.valueOf(model.getModelId()));
                    createReqDto.setUserId(dto.getUserId());
                    createReqDto.setSex(dto.getSex());
                    createReqDto.setAvatar(dto.getAvatar());
                    createReqDto.setExtFields(dto.getExtFields());
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\u8fdb\u884c\u6fc0\u6d3b\u4f1a\u5458createReqDto={}", (Object)JSON.toJSONString((Object)createReqDto));
                    }
                    this.memberInfoBestoreApi.registerByManage(createReqDto);
                }
            }
        }
    }

    private MemberReqDto buildMemberReqDto(MemberRegisterReqDto dto) {
        MemberReqDto memberDto = new MemberReqDto();
        memberDto.setActivateTime(new Date());
        memberDto.setCreateTime(new Date());
        memberDto.setGrowthValue(0);
        memberDto.setLevelName("");
        memberDto.setUserId(dto.getUserId());
        memberDto.setName(dto.loginName());
        memberDto.setStatus(Integer.valueOf(1));
        memberDto.setUserSource("");
        memberDto.setTenantId(dto.getTenantId());
        return memberDto;
    }

    private MemberInfoReqDto buildMemberInfoReq(UserReqDto userReqDto) {
        MemberInfoReqDto memberInfoReqDto = new MemberInfoReqDto();
        memberInfoReqDto.setRegisterTime(userReqDto.getRegisterTime());
        memberInfoReqDto.setType(userReqDto.getUserType());
        memberInfoReqDto.setChannelCode(userReqDto.getChannelCode());
        memberInfoReqDto.setNickName(userReqDto.getNickName());
        memberInfoReqDto.setAvatar(userReqDto.getAvatar());
        memberInfoReqDto.setTenantId(userReqDto.getTenantId());
        memberInfoReqDto.setInstanceId(userReqDto.getInstanceId());
        memberInfoReqDto.setUserName(userReqDto.getUserName());
        memberInfoReqDto.setEmail(userReqDto.getEmail());
        if (!StringUtils.isEmpty((Object)userReqDto.getPhone())) {
            memberInfoReqDto.setPhone(userReqDto.getPhone());
            memberInfoReqDto.setBusinessCode(userReqDto.getPhone());
        } else if (!StringUtils.isEmpty((Object)userReqDto.getEmail())) {
            memberInfoReqDto.setEmail(userReqDto.getEmail());
            memberInfoReqDto.setBusinessCode(userReqDto.getEmail());
        } else {
            memberInfoReqDto.setUserName(userReqDto.getUserName());
            memberInfoReqDto.setBusinessCode(userReqDto.getUserName());
        }
        return memberInfoReqDto;
    }
}

