/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.identity.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.starter.extension.BizIdContext;
import com.dtyunxi.cube.starter.extension.reader.IConfReader;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.RegexUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.MemberRegisterReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.ResetPasswordReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.dto.request.UserReqDto;
import com.dtyunxi.yundt.cube.center.identity.api.exception.IdentityExceptionCode;
import com.dtyunxi.yundt.cube.center.identity.api.vo.ExtensionExecuteResult;
import com.dtyunxi.yundt.cube.center.identity.biz.config.DefaultMemberModelProperties;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IBindService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IMemberService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IRegisterService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IUserService;
import com.dtyunxi.yundt.cube.center.identity.biz.service.IVerifyCodeService;
import com.dtyunxi.yundt.cube.center.identity.conf.ext.IRegisterParamVerifyExt;
import com.dtyunxi.yundt.cube.center.identity.enhance.extension.IRegisterVerifyPhoneEmail;
import com.dtyunxi.yundt.cube.center.identity.event.RegisterEventDto;
import com.dtyunxi.yundt.cube.center.identity.mq.event.RegisterEventPublisher;
import com.dtyunxi.yundt.cube.center.user.api.ISecurityApi;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Service
@EnableConfigurationProperties(value={DefaultMemberModelProperties.class})
public class RegisterServiceImpl
implements IRegisterService {
    private static final Logger logger = LoggerFactory.getLogger(RegisterServiceImpl.class);
    private static final Integer ACTIVE_STATE_ACTIVE = 1;
    private static final String USER_EXIST_RESULT_MSG = "\u8be5\u7528\u6237\u5df2\u88ab\u6ce8\u518c";
    private static final String USER_PHONE_EXIST_RESULT_MSG = "\u624b\u673a\u53f7\u7801\u5df2\u88ab\u6ce8\u518c!";
    private static final String USER_ERROR_MESSAGE_UPDATE = "\u8be5\u7528\u6237\u5df2\u88ab\u6ce8\u518c";
    private static final String USER_EXIST = "\u5df2\u88ab\u6ce8\u518c";
    @Value(value="${verify.username:true}")
    private Boolean verifyUserName;
    @Resource
    IUserApi iUserApi;
    @Resource
    IVerifyCodeService iverifyCodeService;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private ISecurityApi securityApi;
    @Resource
    private IUserService userService;
    @Resource
    private IMemberService memberService;
    @Autowired
    private IBindService bindService;
    @Resource
    private IConfReader iConfReader;
    @CubeResource
    private IRegisterParamVerifyExt registerParamVerifyExt;
    @Resource
    private RegisterEventPublisher registerEventPublisher;

    @Override
    public Long register(MemberRegisterReqDto dto) {
        long userId = 0L;
        try {
            UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(dto.loginName(), dto.getInstanceId(), JSON.toJSONString((Object)dto.getExtFields())).getData();
            if (userDto != null) {
                userId = userDto.getId();
                if (userDto.getUserType() != null && userDto.getUserType() != 0) {
                    throw new BizException(IdentityExceptionCode.EXIST_FAIL.getCode(), "\u7528\u6237\u540d/\u624b\u673a\u53f7/\u90ae\u7bb1\u5df2\u5b58\u5728");
                }
                HashMap<String, Boolean> ext = dto.getExtFields();
                if (null == ext) {
                    ext = new HashMap<String, Boolean>();
                }
                dto.setUserType(Integer.valueOf(1));
                ext.put("isOverride", true);
                dto.setExtFields(ext);
            }
            userId = Long.parseLong(this.register(dto.toUserReqDto()));
        }
        catch (Exception e) {
            logger.info("", (Throwable)e);
            throw e;
        }
        finally {
            dto.setUserId(Long.valueOf(userId));
            this.memberService.activateMember(dto);
        }
        return userId;
    }

    @Override
    public Long importUserAndMember(MemberRegisterReqDto dto) {
        long userId = 0L;
        try {
            userId = Long.parseLong(this.importUser(dto.toUserReqDto()));
        }
        catch (BizException be) {
            logger.info("", (Throwable)be);
            try {
                UserDto userDto = (UserDto)this.userQueryApi.queryByLoginStr(dto.loginName(), dto.getInstanceId(), JSON.toJSONString((Object)dto.getExtFields())).getData();
                userId = userDto.getId();
            }
            catch (Exception e) {
                logger.debug("", (Throwable)e);
                throw be;
            }
        }
        dto.setUserId(Long.valueOf(userId));
        this.memberService.activateMember(dto);
        if (CollectionUtils.isEmpty((Collection)dto.getBindings())) {
            return userId;
        }
        long finalUserId = userId;
        dto.getBindings().stream().filter(thirdAccountReqDto -> !StringUtils.isEmpty((Object)thirdAccountReqDto.getOpenId())).forEach(thirdAccountReqDto -> this.bindService.bindThirdNo(dto.getInstanceId(), dto.getTenantId(), (Long)finalUserId, thirdAccountReqDto.getOpenId(), null, thirdAccountReqDto.getThirdType(), thirdAccountReqDto.getStatus()));
        return userId;
    }

    private String importUser(UserReqDto dto) {
        RestResponse result;
        String loginType = null;
        String loginStr = null;
        if (StringUtils.isEmpty((Object)dto.getRegisterType())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_REGISTERPARAM_ERROR);
        }
        int registerType = dto.getRegisterType();
        switch (registerType) {
            case 1: 
            case 2: {
                loginType = "phone";
                loginStr = dto.getPhone();
                if (StringUtils.isEmpty((Object)dto.getPhone())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_PHONEPARAM_ERROR);
                }
                if (registerType != 2 || !StringUtils.isEmpty((Object)dto.getPassword())) break;
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_IS_REQUIRED);
                break;
            }
            case 3: {
                loginType = "email";
                loginStr = dto.getEmail();
                if (StringUtils.isEmpty((Object)dto.getEmail())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_EMAILPARAM_ERROR);
                    break;
                }
                if (!StringUtils.isEmpty((Object)dto.getPassword())) break;
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_IS_REQUIRED);
                break;
            }
            case 4: {
                loginType = "userName";
                loginStr = dto.getUserName();
                if (StringUtils.isEmpty((Object)dto.getUserName())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_USERNAMEPARAM_ERROR);
                    break;
                }
                if (!StringUtils.isEmpty((Object)dto.getPassword())) break;
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_IS_REQUIRED);
                break;
            }
            default: {
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_REGISTERPARAM_ERROR);
            }
        }
        String password = dto.getPassword();
        String confirmPassword = dto.getConfirmPassword();
        if (password != null && confirmPassword != null && !password.equals(confirmPassword)) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_CONFIRM_ERROR);
        }
        if (!StringUtils.isEmpty((Object)dto.getJsonParam()) && !RegisterServiceImpl.isJSONType(dto.getJsonParam())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.JSONPARAM_CONFIRM_ERROR);
        }
        if (!StringUtils.isEmpty((Object)dto.getVerifyCode())) {
            if (1 == registerType || 2 == registerType) {
                boolean verifyResult;
                if (!dto.getUniqueId().contains(dto.getPhone())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_PHONE_ERROR);
                }
                if (!(verifyResult = this.iverifyCodeService.checkPhoneCode(dto.getVerifyCode(), dto.getUniqueId()))) {
                    IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
                }
            } else if (3 == registerType) {
                if (!dto.getUniqueId().contains(dto.getEmail())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_EMAIL_ERROR);
                }
                if (!this.iverifyCodeService.checkEmailCode(dto.getVerifyCode(), dto.getUniqueId())) {
                    IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
                }
            }
        }
        if (!StringUtils.isEmpty((Object)dto.getUserName())) {
            Boolean isCheck = this.verifyUserName;
            if (null != dto.getExtFields() && null != dto.getExtFields().get("verifyUserName")) {
                isCheck = (Boolean)dto.getExtFields().get("verifyUserName");
            }
            if (isCheck.booleanValue() && !RegexUtils.isUsername((String)dto.getUserName())) {
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USERNAME_FORMAT_ERROR);
            }
        }
        UserDto user = new UserDto();
        user.setUserName(dto.getUserName());
        user.setNickName(dto.getNickName());
        user.setAvatar(dto.getAvatar());
        user.setRegisterTime(dto.getRegisterTime());
        user.setStatus(dto.getStatus());
        user.setId(dto.getId());
        user.setPassword(dto.getPassword());
        user.setSalt(dto.getSalt());
        user.setEmail(dto.getEmail());
        user.setPhone(dto.getPhone());
        user.setTenantId(dto.getTenantId());
        user.setInstanceId(dto.getInstanceId());
        user.setUserType(dto.getUserType());
        user.setChannelCode(dto.getChannelCode());
        user.setExtraParams(dto.getJsonParam());
        user.setExtFields(dto.getExtFields());
        JSONObject jsonObject = JSON.parseObject((String)dto.getExtension());
        if (jsonObject != null) {
            user.setBrief(jsonObject.getString("brief"));
            jsonObject.remove((Object)"brief");
            user.setExtension(jsonObject.toJSONString());
        }
        if (!(result = this.iUserApi.addUserWithSalt(dto.getInstanceId(), user)).getResultCode().equals("0")) {
            String resultMsg = result.getResultMsg();
            if (null != resultMsg && resultMsg.contains(USER_EXIST)) {
                JSONObject ptUserIdMap = JSON.parseObject((String)dto.getExtension());
                if (ptUserIdMap == null) {
                    throw new BizException(result.getResultCode(), result.getResultMsg());
                }
            } else {
                throw new BizException(result.getResultCode(), result.getResultMsg());
            }
            loginStr = "fz_" + jsonObject.getString("ptUserId");
            UserDto queryUser = this.userService.queryByLoginStr(loginStr, user);
            if (queryUser == null && (queryUser = this.userService.queryByLoginStr(loginStr = dto.getUserName(), user)) == null) {
                throw new BizException(result.getResultCode(), result.getResultMsg());
            }
            user.setId(queryUser.getId());
            result = this.iUserApi.addUserWithSalt(dto.getInstanceId(), user);
            if (!result.getResultCode().equals("0")) {
                throw new BizException(result.getResultCode(), result.getResultMsg());
            }
        }
        return String.valueOf(result.getData());
    }

    private Boolean registerVerify(UserReqDto dto) {
        IRegisterVerifyPhoneEmail impl = (IRegisterVerifyPhoneEmail)this.iConfReader.readExtImpl(IRegisterVerifyPhoneEmail.class, new BizIdContext().setReqTenantId(dto.getTenantId()));
        return impl == null || impl.registerVerify(dto);
    }

    @Override
    public String register(UserReqDto dto) {
        ExtensionExecuteResult result;
        StopWatch stopWatch = new StopWatch("register user");
        stopWatch.start("pre check");
        logger.info("get instanceId from context:{}", (Object)ServiceContext.getContext().getRequestInstanceId());
        Long instanceId = dto.getInstanceId() == null ? ServiceContext.getContext().getRequestInstanceId() : dto.getInstanceId();
        Assert.notNull((Object)instanceId, (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        String loginType = null;
        String loginStr = null;
        if (StringUtils.isEmpty((Object)dto.getRegisterType())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_REGISTERPARAM_ERROR);
        }
        int registerType = dto.getRegisterType();
        switch (registerType) {
            case 1: 
            case 2: {
                loginType = "phone";
                loginStr = dto.getPhone();
                if (StringUtils.isEmpty((Object)dto.getPhone())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_PHONEPARAM_ERROR);
                }
                if (registerType != 2 || !StringUtils.isEmpty((Object)dto.getPassword())) break;
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_IS_REQUIRED);
                break;
            }
            case 3: {
                loginType = "email";
                loginStr = dto.getEmail();
                if (StringUtils.isEmpty((Object)dto.getEmail())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_EMAILPARAM_ERROR);
                    break;
                }
                if (!StringUtils.isEmpty((Object)dto.getPassword())) break;
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_IS_REQUIRED);
                break;
            }
            case 4: {
                loginType = "userName";
                loginStr = dto.getUserName();
                if (StringUtils.isEmpty((Object)dto.getUserName())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_USERNAMEPARAM_ERROR);
                    break;
                }
                if (!StringUtils.isEmpty((Object)dto.getPassword())) break;
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_IS_REQUIRED);
                break;
            }
            default: {
                IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.EMPTY_REGISTERPARAM_ERROR);
            }
        }
        String password = dto.getPassword();
        String confirmPassword = dto.getConfirmPassword();
        if (password != null && confirmPassword != null && !password.equals(confirmPassword)) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.PASSWORD_CONFIRM_ERROR);
        }
        if (!StringUtils.isEmpty((Object)dto.getJsonParam()) && !RegisterServiceImpl.isJSONType(dto.getJsonParam())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.JSONPARAM_CONFIRM_ERROR);
        }
        stopWatch.stop();
        if (!StringUtils.isEmpty((Object)dto.getVerifyCode())) {
            if (1 == registerType || 2 == registerType) {
                if (!dto.getUniqueId().contains(dto.getPhone())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_PHONE_ERROR);
                }
                stopWatch.start("checkPhoneCode");
                boolean verifyResult = this.iverifyCodeService.checkPhoneCode(dto.getVerifyCode(), dto.getUniqueId());
                stopWatch.stop();
                if (!verifyResult) {
                    IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.SMS_VERIFYCODE_CONFIRM_ERROR);
                }
            } else if (3 == registerType) {
                if (!dto.getUniqueId().contains(dto.getEmail())) {
                    IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_EMAIL_ERROR);
                }
                stopWatch.start("checkEmailCode");
                if (!this.iverifyCodeService.checkEmailCode(dto.getVerifyCode(), dto.getUniqueId())) {
                    IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
                }
                stopWatch.stop();
            }
        }
        if (!StringUtils.isEmpty((Object)dto.getUserName())) {
            Boolean isCheck = this.verifyUserName;
            if (null != dto.getExtFields() && null != dto.getExtFields().get("verifyUserName")) {
                isCheck = (Boolean)dto.getExtFields().get("verifyUserName");
            }
            stopWatch.start("verifyUserName");
            if (isCheck.booleanValue()) {
                if (this.registerParamVerifyExt.verifyUserName(dto.getUserName()) != null) {
                    stopWatch.start("inner  verifyUserName");
                    if (!this.registerParamVerifyExt.verifyUserName(dto.getUserName()).getFlag().booleanValue()) {
                        IdentityExceptionCode.throwBizException((IdentityExceptionCode)this.registerParamVerifyExt.verifyUserName(dto.getUserName()).getExceptionCode());
                    }
                    stopWatch.stop();
                } else {
                    stopWatch.start("\u9ed8\u8ba4\u6821\u9a8c\u65b9\u6cd5");
                    if (!this.verifyUserName(dto.getUserName()).booleanValue()) {
                        IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USERNAME_FORMAT_ERROR);
                    }
                    stopWatch.stop();
                }
            }
            stopWatch.stop();
        }
        stopWatch.start("\u6821\u9a8cpassword\u683c\u5f0f\u7684\u5408\u6cd5\u6027");
        if (!dto.getRegisterType().equals(1) && (result = this.registerParamVerifyExt.verifyPassword(dto.getPassword())) != null && !result.getFlag().booleanValue()) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)result.getExceptionCode());
        }
        stopWatch.stop();
        stopWatch.start("\u8bbe\u7f6e\u6269\u5c55\u4fe1\u606f");
        UserDto user = new UserDto();
        user.setUserName(dto.getUserName());
        user.setNickName(dto.getNickName());
        user.setAvatar(dto.getAvatar());
        user.setRegisterTime(dto.getRegisterTime());
        user.setStatus(dto.getStatus());
        user.setId(dto.getId());
        user.setPassword(dto.getPassword());
        user.setEmail(dto.getEmail());
        user.setPhone(dto.getPhone());
        user.setTenantId(dto.getTenantId());
        user.setInstanceId(instanceId);
        user.setUserType(dto.getUserType());
        user.setChannelCode(dto.getChannelCode());
        user.setExtraParams(dto.getJsonParam());
        user.setExtFields(dto.getExtFields());
        user.setValidType(dto.getValidType());
        JSONObject jsonObject = JSON.parseObject((String)dto.getExtension());
        if (jsonObject != null) {
            user.setBrief(jsonObject.getString("brief"));
            jsonObject.remove((Object)"brief");
            user.setExtension(jsonObject.toJSONString());
        }
        stopWatch.stop();
        stopWatch.start("\u5728\u7528\u6237\u4e2d\u5fc3\u521b\u5efa\u8d26\u6237");
        RestResponse result2 = this.iUserApi.addUser(instanceId, user);
        stopWatch.stop();
        stopWatch.start("\u5c1d\u8bd5\u8986\u76d6\u7528\u6237");
        if (!result2.getResultCode().equals("0")) {
            if (result2.getResultMsg() != null && result2.getResultMsg().contains(USER_EXIST)) {
                if (null != dto.getExtFields() && dto.getExtFields().getOrDefault("isOverride", false).booleanValue()) {
                    UserDto queryUser = this.userService.queryByLoginStr(loginStr, user);
                    if (null == queryUser) {
                        IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
                    }
                    this.iUserApi.updatePasswordPermitted(queryUser.getId(), user);
                    return String.valueOf(queryUser.getId());
                }
                IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.EXIST_FAIL);
            } else {
                throw new BizException(result2.getResultCode(), result2.getResultMsg());
            }
        }
        stopWatch.stop();
        stopWatch.start("\u6fc0\u6d3b\u4f1a\u5458");
        this.activateMember((Long)result2.getData(), dto);
        stopWatch.stop();
        logger.info("stopWatch :{}", (Object)stopWatch.prettyPrint());
        RegisterEventDto registerEventDto = new RegisterEventDto();
        CubeBeanUtils.copyProperties((Object)registerEventDto, (Object)dto, (String[])new String[0]);
        registerEventDto.setUserId((Long)result2.getData());
        this.registerEventPublisher.send(registerEventDto);
        return String.valueOf(result2.getData());
    }

    @Override
    public Boolean verifyUserName(String userName) {
        return RegexUtils.isUsername((String)userName);
    }

    private void activateMember(Long userId, UserReqDto userReqDto) {
        MemberRegisterReqDto memberRegisterReqDto = new MemberRegisterReqDto();
        CubeBeanUtils.copyProperties((Object)memberRegisterReqDto, (Object)userReqDto, (String[])new String[0]);
        memberRegisterReqDto.setUserId(userId);
        this.memberService.activateMember(memberRegisterReqDto);
    }

    public static boolean isJSONType(String strParam) {
        boolean result = true;
        if (!(StringUtils.isEmpty((Object)strParam) || (strParam = strParam.trim()).startsWith("{") && strParam.endsWith("}") || strParam.startsWith("[") && strParam.endsWith("]"))) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean checkAccountExist(String account, String instanceId) {
        try {
            RestResponse restResponse = this.userQueryApi.queryByLoginStr(account, Long.valueOf(instanceId), "{}");
            return null != restResponse.getData();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void resetPassword(ResetPasswordReqDto resetPasswordReqDto) {
        RestResponse result;
        RestResponse restResponse;
        boolean verifyResult = this.iverifyCodeService.checkPhoneCode(resetPasswordReqDto.getVerifyCode(), resetPasswordReqDto.getUniqueId());
        if (!verifyResult) {
            IdentityExceptionCode.throwBizException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_CONFIRM_ERROR);
        }
        if (!resetPasswordReqDto.getUniqueId().contains(resetPasswordReqDto.getPhone())) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.VERIFYCODE_PHONE_ERROR);
        }
        if (!"0".equals((restResponse = this.userQueryApi.queryByLoginStr(resetPasswordReqDto.getPhone(), resetPasswordReqDto.getInstanceId(), JSON.toJSONString((Object)resetPasswordReqDto.getExtFields()))).getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
        UserDto userDto = (UserDto)restResponse.getData();
        if (userDto == null) {
            IdentityExceptionCode.throwParamException((IdentityExceptionCode)IdentityExceptionCode.USER_NO_EXIST);
        }
        if (!"0".equals((result = this.securityApi.resetPasswordByAdmin(userDto.getId(), resetPasswordReqDto.getNewPassword())).getResultCode())) {
            throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
        }
    }
}

